/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ImplementFilteredAggregations
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().matching(ImplementFilteredAggregations::hasFilters);
    private final LogicalRowExpressions logicalRowExpressions;

    public ImplementFilteredAggregations(FunctionAndTypeManager functionAndTypeManager) {
        Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
        this.logicalRowExpressions = new LogicalRowExpressions((DeterminismEvaluator)new RowExpressionDeterminismEvaluator(functionAndTypeManager), (StandardFunctionResolution)new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver()), (FunctionMetadataManager)functionAndTypeManager);
    }

    private static boolean hasFilters(AggregationNode aggregation) {
        return aggregation.getAggregations().values().stream().anyMatch(e -> e.getFilter().isPresent() && !e.getMask().isPresent());
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode aggregation, Captures captures, Rule.Context context) {
        Assignments.Builder newAssignments = Assignments.builder();
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        ImmutableList.Builder maskSymbols = ImmutableList.builder();
        boolean aggregateWithoutFilterPresent = false;
        for (Map.Entry entry : aggregation.getAggregations().entrySet()) {
            VariableReferenceExpression output = (VariableReferenceExpression)entry.getKey();
            Optional<VariableReferenceExpression> mask = ((AggregationNode.Aggregation)entry.getValue()).getMask();
            if (((AggregationNode.Aggregation)entry.getValue()).getFilter().isPresent()) {
                RowExpression filter = (RowExpression)((AggregationNode.Aggregation)entry.getValue()).getFilter().get();
                VariableReferenceExpression variable = context.getVariableAllocator().newVariable(filter);
                Verify.verify((!mask.isPresent() ? 1 : 0) != 0, (String)"Expected aggregation without mask symbols, see Rule pattern", (Object[])new Object[0]);
                newAssignments.put(variable, filter);
                mask = Optional.of(variable);
                maskSymbols.add((Object)variable);
            } else {
                aggregateWithoutFilterPresent = true;
            }
            aggregations.put((Object)output, (Object)new AggregationNode.Aggregation(((AggregationNode.Aggregation)entry.getValue()).getCall(), Optional.empty(), ((AggregationNode.Aggregation)entry.getValue()).getOrderBy(), ((AggregationNode.Aggregation)entry.getValue()).isDistinct(), (Optional)mask));
        }
        ConstantExpression predicate = LogicalRowExpressions.TRUE_CONSTANT;
        if (!aggregation.hasNonEmptyGroupingSet() && !aggregateWithoutFilterPresent) {
            predicate = this.logicalRowExpressions.combineDisjunctsWithDefault((Collection)maskSymbols.build(), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
        }
        newAssignments.putAll(AssignmentUtils.identityAssignments(aggregation.getSource().getOutputVariables()));
        return Rule.Result.ofPlanNode((PlanNode)new AggregationNode(aggregation.getSourceLocation(), context.getIdAllocator().getNextId(), (PlanNode)new FilterNode(aggregation.getSourceLocation(), context.getIdAllocator().getNextId(), (PlanNode)new ProjectNode(context.getIdAllocator().getNextId(), aggregation.getSource(), newAssignments.build()), (RowExpression)predicate), (Map)aggregations.build(), aggregation.getGroupingSets(), (List)ImmutableList.of(), aggregation.getStep(), aggregation.getHashVariable(), aggregation.getGroupIdVariable(), aggregation.getAggregationId()));
    }
}

