/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.PartialAggregationStatsEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.spi.function.AggregationFunctionImplementation;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.SymbolMapper;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class PushPartialAggregationThroughExchange
implements Rule<AggregationNode> {
    private final FunctionAndTypeManager functionAndTypeManager;
    private String statsSource;
    private static final Capture<ExchangeNode> EXCHANGE_NODE = Capture.newCapture();
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().with(Patterns.source().matching(Patterns.exchange().matching(node -> !node.getOrderingScheme().isPresent()).capturedAs(EXCHANGE_NODE)));

    public PushPartialAggregationThroughExchange(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isCostBased(Session session) {
        return SystemSessionProperties.getPartialAggregationStrategy(session) == FeaturesConfig.PartialAggregationStrategy.AUTOMATIC;
    }

    @Override
    public String getStatsSource() {
        return this.statsSource;
    }

    @Override
    public Rule.Result apply(AggregationNode aggregationNode, Captures captures, Rule.Context context) {
        ExchangeNode exchangeNode = (ExchangeNode)((Object)captures.get(EXCHANGE_NODE));
        boolean decomposable = AggregationUtils.isDecomposable(aggregationNode, this.functionAndTypeManager);
        if (aggregationNode.getStep().equals((Object)AggregationNode.Step.SINGLE) && aggregationNode.hasEmptyGroupingSet() && aggregationNode.hasNonEmptyGroupingSet() && exchangeNode.getType() == ExchangeNode.Type.REPARTITION) {
            Preconditions.checkState((boolean)decomposable, (Object)"Distributed aggregation with empty grouping set requires partial but functions are not decomposable");
            return Rule.Result.ofPlanNode(this.split(aggregationNode, context));
        }
        FeaturesConfig.PartialAggregationStrategy partialAggregationStrategy = SystemSessionProperties.getPartialAggregationStrategy(context.getSession());
        if (!decomposable || partialAggregationStrategy == FeaturesConfig.PartialAggregationStrategy.NEVER || partialAggregationStrategy == FeaturesConfig.PartialAggregationStrategy.AUTOMATIC && this.partialAggregationNotUseful(aggregationNode, exchangeNode, context, aggregationNode.getGroupingKeys().size())) {
            return Rule.Result.empty();
        }
        if (exchangeNode.getType() != ExchangeNode.Type.GATHER && exchangeNode.getType() != ExchangeNode.Type.REPARTITION || exchangeNode.getPartitioningScheme().isReplicateNullsAndAny()) {
            return Rule.Result.empty();
        }
        if (exchangeNode.getType() == ExchangeNode.Type.REPARTITION) {
            List partitioningColumns = exchangeNode.getPartitioningScheme().getPartitioning().getArguments().stream().filter(VariableReferenceExpression.class::isInstance).map(VariableReferenceExpression.class::cast).collect(Collectors.toList());
            if (!aggregationNode.getGroupingKeys().containsAll(partitioningColumns)) {
                return Rule.Result.empty();
            }
        }
        if (aggregationNode.getHashVariable().isPresent() || exchangeNode.getPartitioningScheme().getHashColumn().isPresent()) {
            return Rule.Result.empty();
        }
        if (SystemSessionProperties.isNativeExecutionEnabled(context.getSession()) && PlannerUtils.containsSystemTableScan(exchangeNode, context.getLookup())) {
            return Rule.Result.empty();
        }
        PlanNode resultNode = null;
        switch (aggregationNode.getStep()) {
            case SINGLE: {
                resultNode = this.split(aggregationNode, context);
                this.storeStatsSourceInfo(context, partialAggregationStrategy, (PlanNode)aggregationNode);
                return Rule.Result.ofPlanNode(resultNode);
            }
            case PARTIAL: {
                resultNode = this.pushPartial(aggregationNode, exchangeNode, context);
                this.storeStatsSourceInfo(context, partialAggregationStrategy, (PlanNode)aggregationNode);
                return Rule.Result.ofPlanNode(resultNode);
            }
        }
        return Rule.Result.empty();
    }

    private void storeStatsSourceInfo(Rule.Context context, FeaturesConfig.PartialAggregationStrategy partialAggregationStrategy, PlanNode resultNode) {
        if (partialAggregationStrategy == FeaturesConfig.PartialAggregationStrategy.AUTOMATIC) {
            this.statsSource = context.getStatsProvider().getStats(resultNode).getSourceInfo().getSourceInfoName();
        }
    }

    private PlanNode pushPartial(AggregationNode aggregation, ExchangeNode exchange, Rule.Context context) {
        ArrayList<PlanNode> partials = new ArrayList<PlanNode>();
        for (int i = 0; i < exchange.getSources().size(); ++i) {
            PlanNode source = exchange.getSources().get(i);
            SymbolMapper.Builder mappingsBuilder = SymbolMapper.builder();
            for (int outputIndex = 0; outputIndex < exchange.getOutputVariables().size(); ++outputIndex) {
                VariableReferenceExpression input;
                VariableReferenceExpression output = exchange.getOutputVariables().get(outputIndex);
                if (output.equals((Object)(input = exchange.getInputs().get(i).get(outputIndex)))) continue;
                mappingsBuilder.put(output, input);
            }
            SymbolMapper symbolMapper = mappingsBuilder.build();
            AggregationNode mappedPartial = symbolMapper.map(aggregation, source, context.getIdAllocator());
            Assignments.Builder assignments = Assignments.builder();
            for (VariableReferenceExpression output : aggregation.getOutputVariables()) {
                VariableReferenceExpression input = symbolMapper.map(output);
                assignments.put(output, (RowExpression)input);
            }
            partials.add((PlanNode)new ProjectNode(exchange.getSourceLocation(), context.getIdAllocator().getNextId(), (PlanNode)mappedPartial, assignments.build(), ProjectNode.Locality.LOCAL));
        }
        for (PlanNode node : partials) {
            Verify.verify((boolean)aggregation.getOutputVariables().equals(node.getOutputVariables()));
        }
        List aggregationOutputs = aggregation.getOutputVariables();
        PartitioningScheme partitioning = new PartitioningScheme(exchange.getPartitioningScheme().getPartitioning(), aggregationOutputs, exchange.getPartitioningScheme().getHashColumn(), exchange.getPartitioningScheme().isReplicateNullsAndAny(), exchange.getPartitioningScheme().getBucketToPartition());
        return new ExchangeNode(aggregation.getSourceLocation(), context.getIdAllocator().getNextId(), exchange.getType(), exchange.getScope(), partitioning, partials, (List<List<VariableReferenceExpression>>)ImmutableList.copyOf(Collections.nCopies(partials.size(), aggregationOutputs)), exchange.isEnsureSourceOrdering(), Optional.empty());
    }

    private PlanNode split(AggregationNode node, Rule.Context context) {
        HashMap<VariableReferenceExpression, AggregationNode.Aggregation> intermediateAggregation = new HashMap<VariableReferenceExpression, AggregationNode.Aggregation>();
        HashMap finalAggregation = new HashMap();
        for (Map.Entry entry : node.getAggregations().entrySet()) {
            AggregationNode.Aggregation originalAggregation = (AggregationNode.Aggregation)entry.getValue();
            String functionName = this.functionAndTypeManager.getFunctionMetadata(originalAggregation.getFunctionHandle()).getName().getObjectName();
            FunctionHandle functionHandle = originalAggregation.getFunctionHandle();
            AggregationFunctionImplementation function = this.functionAndTypeManager.getAggregateFunctionImplementation(functionHandle);
            VariableReferenceExpression intermediateVariable = context.getVariableAllocator().newVariable(((AggregationNode.Aggregation)entry.getValue()).getCall().getSourceLocation(), functionName, function.getIntermediateType());
            Preconditions.checkState((!originalAggregation.getOrderBy().isPresent() ? 1 : 0) != 0, (Object)"Aggregate with ORDER BY does not support partial aggregation");
            intermediateAggregation.put(intermediateVariable, new AggregationNode.Aggregation(new CallExpression(originalAggregation.getCall().getSourceLocation(), functionName, functionHandle, function.getIntermediateType(), originalAggregation.getArguments()), originalAggregation.getFilter(), originalAggregation.getOrderBy(), originalAggregation.isDistinct(), originalAggregation.getMask()));
            finalAggregation.put(entry.getKey(), new AggregationNode.Aggregation(new CallExpression(originalAggregation.getCall().getSourceLocation(), functionName, functionHandle, function.getFinalType(), (List)ImmutableList.builder().add((Object)intermediateVariable).addAll((Iterable)originalAggregation.getArguments().stream().filter(PushPartialAggregationThroughExchange::isLambda).collect(ImmutableList.toImmutableList())).build()), Optional.empty(), Optional.empty(), false, Optional.empty()));
        }
        ImmutableList preGroupedSymbols = ImmutableList.of();
        if (SystemSessionProperties.isStreamingForPartialAggregationEnabled(context.getSession())) {
            preGroupedSymbols = ImmutableList.copyOf((Collection)node.getGroupingSets().getGroupingKeys());
        }
        Integer aggregationId = Integer.parseInt(context.getIdAllocator().getNextId().getId());
        AggregationNode partial = new AggregationNode(node.getSourceLocation(), context.getIdAllocator().getNextId(), node.getSource(), intermediateAggregation, node.getGroupingSets(), (List)preGroupedSymbols, AggregationNode.Step.PARTIAL, node.getHashVariable(), node.getGroupIdVariable(), Optional.of(aggregationId));
        return new AggregationNode(node.getSourceLocation(), node.getId(), (PlanNode)partial, finalAggregation, node.getGroupingSets(), (List)ImmutableList.of(), AggregationNode.Step.FINAL, node.getHashVariable(), node.getGroupIdVariable(), Optional.of(aggregationId));
    }

    private boolean partialAggregationNotUseful(AggregationNode aggregationNode, ExchangeNode exchangeNode, Rule.Context context, int numAggregationKeys) {
        boolean numberOfKeyCheck;
        StatsProvider stats = context.getStatsProvider();
        PlanNodeStatsEstimate exchangeStats = stats.getStats(exchangeNode);
        PlanNodeStatsEstimate aggregationStats = stats.getStats((PlanNode)aggregationNode);
        double inputSize = exchangeStats.getOutputSizeInBytes(exchangeNode);
        double outputSize = aggregationStats.getOutputSizeInBytes((PlanNode)aggregationNode);
        PartialAggregationStatsEstimate partialAggregationStatsEstimate = aggregationStats.getPartialAggregationStatsEstimate();
        boolean isConfident = exchangeStats.isConfident();
        boolean bl = numberOfKeyCheck = SystemSessionProperties.usePartialAggregationHistory(context.getSession()) || numAggregationKeys == 1;
        if (!PartialAggregationStatsEstimate.isUnknown(partialAggregationStatsEstimate) && SystemSessionProperties.usePartialAggregationHistory(context.getSession())) {
            isConfident = aggregationStats.isConfident();
            inputSize = partialAggregationStatsEstimate.getInputRowCount();
            outputSize = partialAggregationStatsEstimate.getOutputRowCount();
        }
        double byteReductionThreshold = SystemSessionProperties.getPartialAggregationByteReductionThreshold(context.getSession());
        return numberOfKeyCheck && isConfident && outputSize > inputSize * byteReductionThreshold;
    }

    private static boolean isLambda(RowExpression rowExpression) {
        return rowExpression instanceof LambdaDefinitionExpression;
    }
}

