/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class LimitPushDown
implements PlanOptimizer {
    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Rewriter rewriter = new Rewriter(idAllocator);
        PlanNode rewrittenPlan = SimplePlanRewriter.rewriteWith(rewriter, plan, null);
        return PlanOptimizerResult.optimizerResult(rewrittenPlan, rewriter.isPlanChanged());
    }

    private static class Rewriter
    extends SimplePlanRewriter<LimitContext> {
        private final PlanNodeIdAllocator idAllocator;
        private boolean planChanged;

        private Rewriter(PlanNodeIdAllocator idAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        }

        @Override
        public PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<LimitContext> context) {
            PlanNode rewrittenNode = context.defaultRewrite(node);
            LimitContext limit = context.get();
            if (limit != null) {
                rewrittenNode = new LimitNode(rewrittenNode.getSourceLocation(), this.idAllocator.getNextId(), rewrittenNode, limit.getCount(), limit.getStep());
                this.planChanged = true;
            }
            return rewrittenNode;
        }

        public PlanNode visitLimit(LimitNode node, SimplePlanRewriter.RewriteContext<LimitContext> context) {
            long count = node.getCount();
            if (context.get() != null) {
                count = Math.min(count, context.get().getCount());
            }
            if (count == 0L) {
                this.planChanged = true;
                return new ValuesNode(node.getSourceLocation(), this.idAllocator.getNextId(), node.getOutputVariables(), (List)ImmutableList.of(), Optional.empty());
            }
            return context.rewrite(node.getSource(), new LimitContext(count, LimitNode.Step.FINAL));
        }

        @Deprecated
        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<LimitContext> context) {
            LimitContext limit = context.get();
            if (limit != null && node.getAggregations().isEmpty() && node.getOutputVariables().size() == node.getGroupingKeys().size() && node.getOutputVariables().containsAll(node.getGroupingKeys())) {
                PlanNode rewrittenSource = context.rewrite(node.getSource());
                this.planChanged = true;
                return new DistinctLimitNode(node.getSourceLocation(), this.idAllocator.getNextId(), rewrittenSource, limit.getCount(), false, rewrittenSource.getOutputVariables(), Optional.empty(), 0);
            }
            PlanNode rewrittenNode = context.defaultRewrite((PlanNode)node);
            if (limit != null) {
                this.planChanged = true;
                rewrittenNode = new LimitNode(rewrittenNode.getSourceLocation(), this.idAllocator.getNextId(), rewrittenNode, limit.getCount(), limit.getStep());
            }
            return rewrittenNode;
        }

        public PlanNode visitMarkDistinct(MarkDistinctNode node, SimplePlanRewriter.RewriteContext<LimitContext> context) {
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<LimitContext> context) {
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        public PlanNode visitTopN(TopNNode node, SimplePlanRewriter.RewriteContext<LimitContext> context) {
            LimitContext limit = context.get();
            PlanNode rewrittenSource = context.rewrite(node.getSource());
            if (rewrittenSource == node.getSource() && limit == null) {
                return node;
            }
            long count = node.getCount();
            if (limit != null) {
                this.planChanged = true;
                count = Math.min(count, limit.getCount());
            }
            return new TopNNode(node.getSourceLocation(), node.getId(), rewrittenSource, count, node.getOrderingScheme(), node.getStep());
        }

        @Override
        @Deprecated
        public PlanNode visitSort(SortNode node, SimplePlanRewriter.RewriteContext<LimitContext> context) {
            LimitContext limit = context.get();
            PlanNode rewrittenSource = context.rewrite(node.getSource());
            if (limit != null) {
                this.planChanged = true;
                return new TopNNode(node.getSourceLocation(), node.getId(), rewrittenSource, limit.getCount(), node.getOrderingScheme(), TopNNode.Step.SINGLE);
            }
            if (rewrittenSource != node.getSource()) {
                this.planChanged = true;
                return new SortNode(node.getSourceLocation(), node.getId(), rewrittenSource, node.getOrderingScheme(), node.isPartial());
            }
            return node;
        }

        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<LimitContext> context) {
            LimitContext limit = context.get();
            LimitContext childLimit = null;
            if (limit != null) {
                childLimit = new LimitContext(limit.getCount(), LimitNode.Step.PARTIAL);
            }
            ArrayList<PlanNode> sources = new ArrayList<PlanNode>();
            for (int i = 0; i < node.getSources().size(); ++i) {
                sources.add(context.rewrite((PlanNode)node.getSources().get(i), childLimit));
            }
            UnionNode output = new UnionNode(node.getSourceLocation(), node.getId(), sources, node.getOutputVariables(), node.getVariableMapping());
            if (limit != null) {
                this.planChanged = true;
                output = new LimitNode(output.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)output, limit.getCount(), limit.getStep());
            }
            return output;
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<LimitContext> context) {
            PlanNode source = context.rewrite(node.getSource(), context.get());
            if (source != node.getSource()) {
                this.planChanged = true;
                return new SemiJoinNode(node.getSourceLocation(), node.getId(), source, node.getFilteringSource(), node.getSourceJoinVariable(), node.getFilteringSourceJoinVariable(), node.getSemiJoinOutput(), node.getSourceHashVariable(), node.getFilteringSourceHashVariable(), node.getDistributionType(), node.getDynamicFilters());
            }
            return node;
        }

        public boolean isPlanChanged() {
            return this.planChanged;
        }
    }

    private static class LimitContext {
        private final long count;
        private final LimitNode.Step step;

        public LimitContext(long count, LimitNode.Step step) {
            this.count = count;
            this.step = step;
        }

        public long getCount() {
            return this.count;
        }

        public LimitNode.Step getStep() {
            return this.step;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("count", this.count).add("step", (Object)this.step).toString();
        }
    }
}

