/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.eventlistener.CTEInformation;
import com.facebook.presto.spi.plan.CteConsumerNode;
import com.facebook.presto.spi.plan.CteProducerNode;
import com.facebook.presto.spi.plan.CteReferenceNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.SequenceNode;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.Traverser;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;

public class LogicalCteOptimizer
implements PlanOptimizer {
    private final Metadata metadata;

    public LogicalCteOptimizer(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(warningCollector, "warningCollector is null");
        if (!SystemSessionProperties.getCteMaterializationStrategy(session).equals((Object)FeaturesConfig.CteMaterializationStrategy.ALL) || session.getCteInformationCollector().getCTEInformationList().stream().noneMatch(CTEInformation::isMaterialized)) {
            return PlanOptimizerResult.optimizerResult(plan, false);
        }
        CteEnumerator cteEnumerator = new CteEnumerator(idAllocator, variableAllocator);
        PlanNode rewrittenPlan = cteEnumerator.transformPersistentCtes(plan);
        return PlanOptimizerResult.optimizerResult(rewrittenPlan, cteEnumerator.isPlanRewritten());
    }

    public class CteTransformerContext {
        public Map<String, CteProducerNode> cteProducerMap = new HashMap<String, CteProducerNode>();
        MutableGraph<String> graph = GraphBuilder.directed().build();
        public Stack<String> activeCteStack = new Stack();

        public Map<String, CteProducerNode> getCteProducerMap() {
            return ImmutableMap.copyOf(this.cteProducerMap);
        }

        public void addProducer(String cteName, CteProducerNode cteProducer) {
            this.cteProducerMap.putIfAbsent(cteName, cteProducer);
        }

        public void pushActiveCte(String cte) {
            this.activeCteStack.push(cte);
        }

        public String popActiveCte() {
            return this.activeCteStack.pop();
        }

        public Optional<String> peekActiveCte() {
            return this.activeCteStack.isEmpty() ? Optional.empty() : Optional.ofNullable(this.activeCteStack.peek());
        }

        public void addDependency(String currentCte) {
            this.graph.addNode((Object)currentCte);
            Optional<String> parentCte = this.peekActiveCte();
            parentCte.ifPresent(s -> this.graph.putEdge((Object)currentCte, s));
        }

        public List<PlanNode> getTopologicalOrdering() {
            ImmutableList.Builder topSortedCteProducerListBuilder = ImmutableList.builder();
            Traverser.forGraph(this.graph).depthFirstPostOrder((Iterable)this.graph.nodes()).forEach(cteName -> topSortedCteProducerListBuilder.add((Object)this.cteProducerMap.get(cteName)));
            return topSortedCteProducerListBuilder.build();
        }
    }

    public class CteConsumerTransformer
    extends SimplePlanRewriter<CteTransformerContext> {
        private final PlanNodeIdAllocator idAllocator;
        private final VariableAllocator variableAllocator;

        public CteConsumerTransformer(PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator must not be null");
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator must not be null");
        }

        public PlanNode visitCteReference(CteReferenceNode node, SimplePlanRewriter.RewriteContext<CteTransformerContext> context) {
            context.get().addDependency(node.getCteName());
            context.get().pushActiveCte(node.getCteName());
            PlanNode actualSource = context.rewrite(node.getSource(), context.get());
            context.get().popActiveCte();
            CteProducerNode cteProducerSource = new CteProducerNode(node.getSourceLocation(), this.idAllocator.getNextId(), actualSource, node.getCteName(), this.variableAllocator.newVariable("rows", (Type)BigintType.BIGINT), node.getOutputVariables());
            context.get().addProducer(node.getCteName(), cteProducerSource);
            return new CteConsumerNode(node.getSourceLocation(), this.idAllocator.getNextId(), Optional.of(actualSource), actualSource.getOutputVariables(), node.getCteName(), actualSource);
        }

        @Override
        public PlanNode visitApply(ApplyNode node, SimplePlanRewriter.RewriteContext<CteTransformerContext> context) {
            return new ApplyNode(node.getSourceLocation(), this.idAllocator.getNextId(), context.rewrite(node.getInput(), context.get()), context.rewrite(node.getSubquery(), context.get()), node.getSubqueryAssignments(), node.getCorrelation(), node.getOriginSubqueryError(), node.getMayParticipateInAntiJoin());
        }
    }

    public class CteEnumerator {
        private PlanNodeIdAllocator planNodeIdAllocator;
        private VariableAllocator variableAllocator;
        private boolean isPlanRewritten;

        public CteEnumerator(PlanNodeIdAllocator planNodeIdAllocator, VariableAllocator variableAllocator) {
            this.planNodeIdAllocator = Objects.requireNonNull(planNodeIdAllocator, "planNodeIdAllocator must not be null");
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator must not be null");
        }

        public PlanNode transformPersistentCtes(PlanNode root) {
            Preconditions.checkArgument((root.getSources().size() == 1 ? 1 : 0) != 0, (Object)"expected newChildren to contain 1 node");
            CteTransformerContext context = new CteTransformerContext();
            PlanNode transformedCte = SimplePlanRewriter.rewriteWith(new CteConsumerTransformer(this.planNodeIdAllocator, this.variableAllocator), root, context);
            List<PlanNode> topologicalOrderedList = context.getTopologicalOrdering();
            if (topologicalOrderedList.isEmpty()) {
                this.isPlanRewritten = false;
                return root;
            }
            this.isPlanRewritten = true;
            SequenceNode sequenceNode = new SequenceNode(root.getSourceLocation(), this.planNodeIdAllocator.getNextId(), topologicalOrderedList, (PlanNode)transformedCte.getSources().get(0));
            return root.replaceChildren(Arrays.asList(sequenceNode));
        }

        public boolean isPlanRewritten() {
            return this.isPlanRewritten;
        }
    }
}

