/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UnnestNode
extends InternalPlanNode {
    private final PlanNode source;
    private final List<VariableReferenceExpression> replicateVariables;
    private final Map<VariableReferenceExpression, List<VariableReferenceExpression>> unnestVariables;
    private final Optional<VariableReferenceExpression> ordinalityVariable;

    @JsonCreator
    public UnnestNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="replicateVariables") List<VariableReferenceExpression> replicateVariables, @JsonProperty(value="unnestVariables") Map<VariableReferenceExpression, List<VariableReferenceExpression>> unnestVariables, @JsonProperty(value="ordinalityVariable") Optional<VariableReferenceExpression> ordinalityVariable) {
        this(sourceLocation, id, Optional.empty(), source, replicateVariables, unnestVariables, ordinalityVariable);
    }

    public UnnestNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source, List<VariableReferenceExpression> replicateVariables, Map<VariableReferenceExpression, List<VariableReferenceExpression>> unnestVariables, Optional<VariableReferenceExpression> ordinalityVariable) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.source = Objects.requireNonNull(source, "source is null");
        this.replicateVariables = ImmutableList.copyOf((Collection)Objects.requireNonNull(replicateVariables, "replicateVariables is null"));
        Preconditions.checkArgument((boolean)source.getOutputVariables().containsAll(replicateVariables), (Object)"Source does not contain all replicateSymbols");
        Objects.requireNonNull(unnestVariables, "unnestVariables is null");
        Preconditions.checkArgument((!unnestVariables.isEmpty() ? 1 : 0) != 0, (Object)"unnestVariables is empty");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<VariableReferenceExpression, List<VariableReferenceExpression>> entry : unnestVariables.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)ImmutableList.copyOf((Collection)entry.getValue()));
        }
        this.unnestVariables = builder.build();
        this.ordinalityVariable = Objects.requireNonNull(ordinalityVariable, "ordinalityVariable is null");
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder().addAll(this.replicateVariables).addAll(Iterables.concat(this.unnestVariables.values()));
        this.ordinalityVariable.ifPresent(arg_0 -> ((ImmutableList.Builder)outputSymbolsBuilder).add(arg_0));
        return outputSymbolsBuilder.build();
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getReplicateVariables() {
        return this.replicateVariables;
    }

    @JsonProperty
    public Map<VariableReferenceExpression, List<VariableReferenceExpression>> getUnnestVariables() {
        return this.unnestVariables;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getOrdinalityVariable() {
        return this.ordinalityVariable;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitUnnest(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new UnnestNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), (PlanNode)Iterables.getOnlyElement(newChildren), this.replicateVariables, this.unnestVariables, this.ordinalityVariable);
    }

    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new UnnestNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.replicateVariables, this.unnestVariables, this.ordinalityVariable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        UnnestNode that = (UnnestNode)((Object)o);
        return Objects.equals(this.source, that.source) && Objects.equals(this.replicateVariables, that.replicateVariables) && Objects.equals(this.unnestVariables, that.unnestVariables) && Objects.equals(this.ordinalityVariable, that.ordinalityVariable);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.replicateVariables, this.unnestVariables, this.ordinalityVariable);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("source", (Object)this.source).add("replicateVariables", this.replicateVariables).add("unnestVariables", this.unnestVariables).add("ordinalityVariable", this.ordinalityVariable).toString();
    }
}

