/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.AbstractTestBlock;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.ByteArrayBlock;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.RowBlock;
import com.facebook.presto.common.block.RowBlockBuilder;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.block.SingleRowBlock;
import com.facebook.presto.common.block.UncheckedBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.assertj.core.api.Fail;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRowBlock
extends AbstractTestBlock {
    @Test
    void testWithVarcharBigint() {
        ImmutableList fieldTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
        List<Object>[] testRows = this.generateTestRows((List<Type>)fieldTypes, 100);
        this.testWith((List<Type>)fieldTypes, testRows);
        this.testWith((List<Type>)fieldTypes, TestRowBlock.alternatingNullValues(testRows));
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        ImmutableList fieldTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
        List<Object>[] expectedValues = TestRowBlock.alternatingNullValues(this.generateTestRows((List<Type>)fieldTypes, 100));
        BlockBuilder blockBuilder = this.createBlockBuilderWithValues((List<Type>)fieldTypes, expectedValues);
        Block block = blockBuilder.build();
        Assert.assertEquals((int)block.getPositionCount(), (int)expectedValues.length);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            int expectedSize = this.getExpectedEstimatedDataSize(expectedValues[i]);
            Assert.assertEquals((long)blockBuilder.getEstimatedDataSizeForStats(i), (long)expectedSize);
            Assert.assertEquals((long)block.getEstimatedDataSizeForStats(i), (long)expectedSize);
        }
    }

    @Test
    public void testFromFieldBlocksNoNullsDetection() {
        ByteArrayBlock emptyBlock = new ByteArrayBlock(0, Optional.empty(), new byte[0]);
        ByteArrayBlock fieldBlock = new ByteArrayBlock(5, Optional.empty(), TestRowBlock.createExpectedValue(5).getBytes());
        boolean[] rowIsNull = new boolean[fieldBlock.getPositionCount()];
        Arrays.fill(rowIsNull, false);
        Assert.assertFalse((boolean)RowBlock.fromFieldBlocks((int)5, Optional.of(rowIsNull), (Block[])new Block[]{fieldBlock}).mayHaveNull());
        rowIsNull[rowIsNull.length - 1] = true;
        Assert.assertTrue((boolean)RowBlock.fromFieldBlocks((int)5, Optional.of(rowIsNull), (Block[])new Block[]{fieldBlock}).mayHaveNull());
        Assert.assertFalse((boolean)RowBlock.fromFieldBlocks((int)0, Optional.of(new boolean[0]), (Block[])new Block[]{emptyBlock}).mayHaveNull());
        ImmutableList fieldTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
        Block hasNullsBlock = this.createBlockBuilderWithValues((List<Type>)fieldTypes, TestRowBlock.alternatingNullValues(this.generateTestRows((List<Type>)fieldTypes, 100))).build();
        Assert.assertTrue((boolean)hasNullsBlock.mayHaveNull());
    }

    private int getExpectedEstimatedDataSize(List<Object> row) {
        if (row == null) {
            return 0;
        }
        int size = 0;
        size += row.get(0) == null ? 0 : ((String)row.get(0)).length();
        return size += row.get(1) == null ? 0 : 8;
    }

    @Test
    public void testCompactBlock() {
        ByteArrayBlock emptyBlock = new ByteArrayBlock(0, Optional.empty(), new byte[0]);
        ByteArrayBlock compactFieldBlock1 = new ByteArrayBlock(5, Optional.empty(), TestRowBlock.createExpectedValue(5).getBytes());
        ByteArrayBlock compactFieldBlock2 = new ByteArrayBlock(5, Optional.empty(), TestRowBlock.createExpectedValue(5).getBytes());
        ByteArrayBlock incompactFiledBlock1 = new ByteArrayBlock(5, Optional.empty(), TestRowBlock.createExpectedValue(6).getBytes());
        ByteArrayBlock incompactFiledBlock2 = new ByteArrayBlock(5, Optional.empty(), TestRowBlock.createExpectedValue(6).getBytes());
        boolean[] rowIsNull = new boolean[]{false, true, false, false, false, false};
        TestRowBlock.assertCompact(RowBlock.fromFieldBlocks((int)0, Optional.empty(), (Block[])new Block[]{emptyBlock, emptyBlock}));
        TestRowBlock.assertCompact(RowBlock.fromFieldBlocks((int)rowIsNull.length, Optional.of(rowIsNull), (Block[])new Block[]{compactFieldBlock1, compactFieldBlock2}));
        TestRowBlock.testIncompactBlock(RowBlock.fromFieldBlocks((int)rowIsNull.length, Optional.of(rowIsNull), (Block[])new Block[]{incompactFiledBlock1, incompactFiledBlock2}));
        TestRowBlock.testIncompactBlock(RowBlock.fromFieldBlocks((int)rowIsNull.length, Optional.of(rowIsNull), (Block[])new Block[]{incompactFiledBlock1, incompactFiledBlock2}));
    }

    @Test
    public void testLogicalSizeInBytes() {
        int positionCount = 100;
        int[] offsets = IntStream.rangeClosed(0, positionCount).toArray();
        boolean[] nulls = new boolean[positionCount];
        Block fieldBlock11 = BlockAssertions.createRandomLongsBlock(positionCount, 0.0f);
        Block fieldBlock12 = BlockAssertions.createRandomLongsBlock(positionCount, 0.0f);
        Block rowOfLongAndLong = RowBlock.fromFieldBlocks((int)positionCount, Optional.of(nulls), (Block[])new Block[]{fieldBlock11, fieldBlock12});
        Assert.assertEquals((long)rowOfLongAndLong.getLogicalSizeInBytes(), (long)2300L);
        RunLengthEncodedBlock fieldBlock21 = BlockAssertions.createRLEBlock(1L, positionCount);
        RunLengthEncodedBlock fieldBlock22 = BlockAssertions.createRLEBlock(2L, positionCount);
        Block rowOfRleOfLongAndRleOfLong = RowBlock.fromFieldBlocks((int)positionCount, Optional.of(nulls), (Block[])new Block[]{fieldBlock21, fieldBlock22});
        Assert.assertEquals((long)rowOfRleOfLongAndRleOfLong.getLogicalSizeInBytes(), (long)2300L);
        RunLengthEncodedBlock fieldBlock31 = BlockAssertions.createRLEBlock(1L, positionCount);
        RunLengthEncodedBlock fieldBlock32 = BlockAssertions.createRleBlockWithRandomValue(RowBlock.fromFieldBlocks((int)positionCount, Optional.of(nulls), (Block[])new Block[]{BlockAssertions.createRandomLongsBlock(positionCount, 0.0f), BlockAssertions.createRandomLongsBlock(positionCount, 0.0f)}), positionCount);
        Block rowOfRleOfLongAndRleOfRowOfLongAndLong = RowBlock.fromFieldBlocks((int)positionCount, Optional.of(nulls), (Block[])new Block[]{fieldBlock31, fieldBlock32});
        Assert.assertEquals((long)rowOfRleOfLongAndRleOfRowOfLongAndLong.getLogicalSizeInBytes(), (long)3700L);
        Block fieldBlock41 = BlockAssertions.createLongDictionaryBlock(0, positionCount);
        Block fieldBlock42 = BlockAssertions.createLongDictionaryBlock(0, positionCount);
        Block rowOfDictionaryOfLongAndDictionaryOfLong = RowBlock.fromFieldBlocks((int)positionCount, Optional.of(nulls), (Block[])new Block[]{fieldBlock41, fieldBlock42});
        Assert.assertEquals((long)rowOfDictionaryOfLongAndDictionaryOfLong.getLogicalSizeInBytes(), (long)2300L);
        Block fieldBlock51 = BlockAssertions.createLongDictionaryBlock(1, positionCount);
        DictionaryBlock fieldBlock52 = BlockAssertions.createRandomDictionaryBlock(RowBlock.fromFieldBlocks((int)positionCount, Optional.of(nulls), (Block[])new Block[]{BlockAssertions.createRandomLongsBlock(positionCount, 0.0f), BlockAssertions.createRandomLongsBlock(positionCount, 0.0f)}), positionCount, false);
        Block rowOfDictionaryOfLongAndDictionaryOfRowOfLongAndLong = RowBlock.fromFieldBlocks((int)positionCount, Optional.of(nulls), (Block[])new Block[]{fieldBlock51, fieldBlock52});
        Assert.assertEquals((long)rowOfDictionaryOfLongAndDictionaryOfRowOfLongAndLong.getLogicalSizeInBytes(), (long)3700L);
    }

    private void testWith(List<Type> fieldTypes, List<Object>[] expectedValues) {
        BlockBuilder blockBuilder = this.createBlockBuilderWithValues(fieldTypes, expectedValues);
        this.assertBlock((Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
        this.assertBlock(blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
        IntArrayList positionList = this.generatePositionList(expectedValues.length, expectedValues.length / 2);
        this.assertBlockFilteredPositions(expectedValues, (Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), positionList.toIntArray());
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), positionList.toIntArray());
    }

    private BlockBuilder createBlockBuilderWithValues(List<Type> fieldTypes, List<Object>[] rows) {
        RowBlockBuilder rowBlockBuilder = new RowBlockBuilder(fieldTypes, null, 1);
        for (List<Object> row : rows) {
            if (row == null) {
                rowBlockBuilder.appendNull();
                continue;
            }
            BlockBuilder singleRowBlockWriter = rowBlockBuilder.beginBlockEntry();
            for (Object fieldValue : row) {
                if (fieldValue == null) {
                    singleRowBlockWriter.appendNull();
                    continue;
                }
                if (fieldValue instanceof Long) {
                    BigintType.BIGINT.writeLong(singleRowBlockWriter, ((Long)fieldValue).longValue());
                    continue;
                }
                if (fieldValue instanceof String) {
                    VarcharType.VARCHAR.writeSlice(singleRowBlockWriter, Slices.utf8Slice((String)((String)fieldValue)));
                    continue;
                }
                throw new IllegalArgumentException();
            }
            rowBlockBuilder.closeEntry();
        }
        return rowBlockBuilder;
    }

    @Override
    protected <T> void assertCheckedPositionValue(Block block, int position, T expectedValue) {
        if (expectedValue instanceof List) {
            this.assertValue(block, position, (List)expectedValue);
            return;
        }
        super.assertCheckedPositionValue(block, position, expectedValue);
    }

    @Override
    protected <T> void assertPositionValueUnchecked(Block block, int internalPosition, T expectedValue) {
        if (expectedValue instanceof List) {
            this.assertValueUnchecked(block, internalPosition, (List)expectedValue);
            return;
        }
        super.assertPositionValueUnchecked(block, internalPosition, expectedValue);
    }

    private void assertValue(Block rowBlock, int position, List<Object> row) {
        Objects.requireNonNull(row, "row is null");
        Assert.assertFalse((boolean)rowBlock.isNull(position));
        SingleRowBlock singleRowBlock = (SingleRowBlock)rowBlock.getBlock(position);
        Assert.assertEquals((int)singleRowBlock.getPositionCount(), (int)row.size());
        for (int i = 0; i < row.size(); ++i) {
            Object fieldValue = row.get(i);
            if (fieldValue == null) {
                Assert.assertTrue((boolean)singleRowBlock.isNull(i));
                continue;
            }
            if (fieldValue instanceof Long) {
                Assert.assertEquals((long)BigintType.BIGINT.getLong((Block)singleRowBlock, i), (long)((Long)fieldValue));
                continue;
            }
            if (fieldValue instanceof String) {
                Assert.assertEquals((Object)VarcharType.VARCHAR.getSlice((Block)singleRowBlock, i), (Object)Slices.utf8Slice((String)((String)fieldValue)));
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    private void assertValueUnchecked(Block rowBlock, int internalPosition, List<Object> row) {
        Objects.requireNonNull(row, "row is null");
        Assert.assertFalse((rowBlock.mayHaveNull() && rowBlock.isNullUnchecked(internalPosition) ? 1 : 0) != 0);
        SingleRowBlock singleRowBlock = (SingleRowBlock)rowBlock.getBlockUnchecked(internalPosition);
        Assert.assertEquals((int)singleRowBlock.getPositionCount(), (int)row.size());
        for (int i = 0; i < row.size(); ++i) {
            Object fieldValue = row.get(i);
            if (fieldValue == null) {
                Assert.assertTrue((boolean)singleRowBlock.isNullUnchecked(i + singleRowBlock.getOffsetBase()));
                continue;
            }
            if (fieldValue instanceof Long) {
                Assert.assertEquals((long)BigintType.BIGINT.getLongUnchecked((UncheckedBlock)singleRowBlock, i + singleRowBlock.getOffsetBase()), (long)((Long)fieldValue));
                continue;
            }
            if (fieldValue instanceof String) {
                Assert.assertEquals((Object)VarcharType.VARCHAR.getSliceUnchecked((Block)singleRowBlock, i + singleRowBlock.getOffsetBase()), (Object)Slices.utf8Slice((String)((String)fieldValue)));
                continue;
            }
            Fail.fail((String)("Unexpected type: " + fieldValue.getClass().getSimpleName()));
        }
    }

    private List<Object>[] generateTestRows(List<Type> fieldTypes, int numRows) {
        List[] testRows = new List[numRows];
        for (int i = 0; i < numRows; ++i) {
            ArrayList<Object> testRow = new ArrayList<Object>(fieldTypes.size());
            for (int j = 0; j < fieldTypes.size(); ++j) {
                int cellId = i * fieldTypes.size() + j;
                if (cellId % 7 == 3) {
                    testRow.add(null);
                    continue;
                }
                if (fieldTypes.get(j) == BigintType.BIGINT) {
                    testRow.add((long)i * 100L + (long)j);
                    continue;
                }
                if (fieldTypes.get(j) == VarcharType.VARCHAR) {
                    testRow.add(String.format("field(%s, %s)", i, j));
                    continue;
                }
                throw new IllegalArgumentException();
            }
            testRows[i] = testRow;
        }
        return testRows;
    }

    private IntArrayList generatePositionList(int numRows, int numPositions) {
        IntArrayList positions = new IntArrayList(numPositions);
        for (int i = 0; i < numPositions; ++i) {
            positions.add((7 * i + 3) % numRows);
        }
        Collections.sort(positions);
        return positions;
    }
}

