/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchHandleResolver;
import com.facebook.presto.tpch.TpchRecordSetProvider;
import com.facebook.presto.tpch.TpchSplitManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;

public class MockConnectorFactory
implements ConnectorFactory {
    private final Function<ConnectorSession, List<String>> listSchemaNames;
    private final BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables;
    private final BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews;
    private final BiFunction<ConnectorSession, ConnectorTableHandle, Map<String, TpchColumnHandle>> getColumnHandles;
    private final Supplier<TableStatistics> getTableStatistics;

    private MockConnectorFactory(Function<ConnectorSession, List<String>> listSchemaNames, BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables, BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews, BiFunction<ConnectorSession, ConnectorTableHandle, Map<String, TpchColumnHandle>> getColumnHandles, Supplier<TableStatistics> getTableStatistics) {
        this.listSchemaNames = Objects.requireNonNull(listSchemaNames, "listSchemaNames is null");
        this.listTables = Objects.requireNonNull(listTables, "listTables is null");
        this.getViews = Objects.requireNonNull(getViews, "getViews is null");
        this.getColumnHandles = Objects.requireNonNull(getColumnHandles, "getColumnHandles is null");
        this.getTableStatistics = Objects.requireNonNull(getTableStatistics, "getTableStatistics is null");
    }

    public String getName() {
        return "mock";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new TpchHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        return new MockConnector(context, this.listSchemaNames, this.listTables, this.getViews, this.getColumnHandles, this.getTableStatistics);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Function<ConnectorSession, List<String>> listSchemaNames = session -> ImmutableList.of();
        private BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables = (session, schemaName) -> ImmutableList.of();
        private BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews = (session, schemaTablePrefix) -> ImmutableMap.of();
        private BiFunction<ConnectorSession, ConnectorTableHandle, Map<String, TpchColumnHandle>> getColumnHandles = (session, tableHandle) -> (Map)Builder.notSupported();
        private Supplier<TableStatistics> getTableStatistics = TableStatistics::empty;

        public Builder withListSchemaNames(Function<ConnectorSession, List<String>> listSchemaNames) {
            this.listSchemaNames = Objects.requireNonNull(listSchemaNames, "listSchemaNames is null");
            return this;
        }

        public Builder withListTables(BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables) {
            this.listTables = Objects.requireNonNull(listTables, "listTables is null");
            return this;
        }

        public Builder withGetViews(BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews) {
            this.getViews = Objects.requireNonNull(getViews, "getViews is null");
            return this;
        }

        public Builder withGetColumnHandles(BiFunction<ConnectorSession, ConnectorTableHandle, Map<String, TpchColumnHandle>> getColumnHandles) {
            this.getColumnHandles = Objects.requireNonNull(getColumnHandles, "getColumnHandles is null");
            return this;
        }

        public Builder withGetTableStatistics(Supplier<TableStatistics> getTableStatistics) {
            this.getTableStatistics = Objects.requireNonNull(getTableStatistics, "getTableStatistics is null");
            return this;
        }

        public MockConnectorFactory build() {
            return new MockConnectorFactory(this.listSchemaNames, this.listTables, this.getViews, this.getColumnHandles, this.getTableStatistics);
        }

        private static <T> T notSupported() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MockConnector
    implements Connector {
        private final ConnectorContext context;
        private final Function<ConnectorSession, List<String>> listSchemaNames;
        private final BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables;
        private final BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews;
        private final BiFunction<ConnectorSession, ConnectorTableHandle, Map<String, TpchColumnHandle>> getColumnHandles;
        private final Supplier<TableStatistics> getTableStatistics;

        public MockConnector(ConnectorContext context, Function<ConnectorSession, List<String>> listSchemaNames, BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables, BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews, BiFunction<ConnectorSession, ConnectorTableHandle, Map<String, TpchColumnHandle>> getColumnHandles, Supplier<TableStatistics> getTableStatistics) {
            this.context = Objects.requireNonNull(context, "context is null");
            this.listSchemaNames = Objects.requireNonNull(listSchemaNames, "listSchemaNames is null");
            this.listTables = Objects.requireNonNull(listTables, "listTables is null");
            this.getViews = Objects.requireNonNull(getViews, "getViews is null");
            this.getColumnHandles = Objects.requireNonNull(getColumnHandles, "getColumnHandles is null");
            this.getTableStatistics = Objects.requireNonNull(getTableStatistics, "getTableStatistics is null");
        }

        public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
            return new ConnectorTransactionHandle(){};
        }

        public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
            return new MockConnectorMetadata();
        }

        public ConnectorSplitManager getSplitManager() {
            return new TpchSplitManager(this.context.getNodeManager(), 1);
        }

        public ConnectorRecordSetProvider getRecordSetProvider() {
            return new TpchRecordSetProvider();
        }

        private class MockConnectorMetadata
        implements ConnectorMetadata {
            private MockConnectorMetadata() {
            }

            public List<String> listSchemaNames(ConnectorSession session) {
                return (List)MockConnector.this.listSchemaNames.apply(session);
            }

            public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
                return new ConnectorTableHandle(){};
            }

            public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
                return null;
            }

            public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
                return (List)MockConnector.this.listTables.apply(session, schemaNameOrNull);
            }

            public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
                return (Map)MockConnector.this.getColumnHandles.apply(session, tableHandle);
            }

            public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
                TpchColumnHandle tpchColumnHandle = (TpchColumnHandle)columnHandle;
                return new ColumnMetadata(tpchColumnHandle.getColumnName(), tpchColumnHandle.getType());
            }

            public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
                return (Map)this.listTables(session, prefix.getSchemaName()).stream().collect(ImmutableMap.toImmutableMap(table -> table, table -> (ImmutableList)IntStream.range(0, 100).boxed().map(i -> new ColumnMetadata("column_" + i, (Type)VarcharType.createUnboundedVarcharType())).collect(ImmutableList.toImmutableList())));
            }

            public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
                throw new UnsupportedOperationException();
            }

            public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
                throw new UnsupportedOperationException();
            }

            public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, SchemaTablePrefix prefix) {
                return (Map)MockConnector.this.getViews.apply(session, prefix);
            }

            public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<ConnectorTableLayoutHandle> tableLayoutHandle, List<ColumnHandle> columnHandles, Constraint<ColumnHandle> constraint) {
                return (TableStatistics)MockConnector.this.getTableStatistics.get();
            }
        }
    }
}

