/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.spi.statistics.ConnectorHistogram;
import org.apache.commons.math3.distribution.RealDistribution;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class TestHistogram {
    abstract ConnectorHistogram createHistogram();

    abstract RealDistribution getDistribution();

    abstract double getDistinctValues();

    @Test
    public void testInverseCumulativeProbability() {
        ConnectorHistogram hist = this.createHistogram();
        RealDistribution dist = this.getDistribution();
        Assert.assertThrows(IllegalArgumentException.class, () -> hist.inverseCumulativeProbability(Double.NaN));
        Assert.assertThrows(IllegalArgumentException.class, () -> hist.inverseCumulativeProbability(-1.0));
        Assert.assertThrows(IllegalArgumentException.class, () -> hist.inverseCumulativeProbability(2.0));
        Assert.assertEquals((double)hist.inverseCumulativeProbability(0.0).getValue(), (double)dist.getSupportLowerBound(), (double)0.001);
        Assert.assertEquals((double)hist.inverseCumulativeProbability(0.25).getValue(), (double)dist.inverseCumulativeProbability(0.25), (double)0.001);
        Assert.assertEquals((double)hist.inverseCumulativeProbability(0.5).getValue(), (double)dist.getNumericalMean(), (double)0.001);
        Assert.assertEquals((double)hist.inverseCumulativeProbability(1.0).getValue(), (double)dist.getSupportUpperBound(), (double)0.001);
    }

    @Test
    public void testCumulativeProbability() {
        ConnectorHistogram hist = this.createHistogram();
        RealDistribution dist = this.getDistribution();
        Assert.assertTrue((boolean)hist.cumulativeProbability(Double.NaN, true).isUnknown());
        Assert.assertEquals((double)hist.cumulativeProbability(Double.NEGATIVE_INFINITY, true).getValue(), (double)0.0, (double)0.001);
        Assert.assertEquals((double)hist.cumulativeProbability(Double.NEGATIVE_INFINITY, false).getValue(), (double)0.0, (double)0.001);
        Assert.assertEquals((double)hist.cumulativeProbability(Double.POSITIVE_INFINITY, true).getValue(), (double)1.0, (double)0.001);
        Assert.assertEquals((double)hist.cumulativeProbability(Double.POSITIVE_INFINITY, false).getValue(), (double)1.0, (double)0.001);
        Assert.assertEquals((double)hist.cumulativeProbability(dist.getSupportLowerBound() - 1.0, true).getValue(), (double)0.0, (double)0.001);
        Assert.assertEquals((double)hist.cumulativeProbability(dist.getSupportLowerBound(), true).getValue(), (double)0.0, (double)0.001);
        Assert.assertEquals((double)hist.cumulativeProbability(dist.getSupportUpperBound() + 1.0, true).getValue(), (double)1.0, (double)0.001);
        Assert.assertEquals((double)hist.cumulativeProbability(dist.getSupportUpperBound(), true).getValue(), (double)1.0, (double)0.001);
        Assert.assertEquals((double)hist.cumulativeProbability(dist.getNumericalMean(), true).getValue(), (double)0.5, (double)0.001);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((double)hist.cumulativeProbability(dist.inverseCumulativeProbability(0.1 * (double)i), true).getValue(), (double)dist.cumulativeProbability(dist.inverseCumulativeProbability(0.1 * (double)i)), (double)0.001);
        }
    }

    @Test
    public void testInclusiveExclusive() {
        double ndvs = this.getDistinctValues();
        ConnectorHistogram hist = this.createHistogram();
        Assert.assertEquals((double)hist.cumulativeProbability(hist.inverseCumulativeProbability(1.0).getValue(), false).getValue(), (double)(1.0 - 1.0 / ndvs), (double)1.0E-4);
        Assert.assertEquals((double)hist.cumulativeProbability(hist.inverseCumulativeProbability(1.0).getValue(), true).getValue(), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)hist.cumulativeProbability(hist.inverseCumulativeProbability(0.0).getValue(), false).getValue(), (double)0.0, (double)1.0E-4);
        Assert.assertEquals((double)hist.cumulativeProbability(hist.inverseCumulativeProbability(0.0).getValue(), true).getValue(), (double)0.0, (double)1.0E-4);
        double midPercent = hist.inverseCumulativeProbability(0.5).getValue();
        Assert.assertEquals((double)(hist.cumulativeProbability(midPercent, true).getValue() - hist.cumulativeProbability(midPercent, false).getValue()), (double)(1.0 / ndvs), (double)1.0E-4);
    }
}

