/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.DisjointRangeDomainHistogram;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimateMath;
import com.facebook.presto.cost.StatisticRange;
import com.facebook.presto.cost.UniformDistributionHistogram;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.ConnectorHistogram;
import com.facebook.presto.testing.assertions.Assert;
import java.util.Optional;
import java.util.function.BiFunction;
import org.testng.annotations.Test;

public class TestPlanNodeStatsEstimateMath {
    private static final VariableReferenceExpression VARIABLE = new VariableReferenceExpression(Optional.empty(), "variable", (Type)BigintType.BIGINT);
    private static final StatisticRange NON_EMPTY_RANGE = TestPlanNodeStatsEstimateMath.openRange(1.0);

    @Test
    public void testAddRowCount() {
        PlanNodeStatsEstimate unknownStats = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        Assert.assertEquals((Object)PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues((PlanNodeStatsEstimate)unknownStats, (PlanNodeStatsEstimate)unknownStats), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((Object)PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)unknownStats), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((Object)PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues((PlanNodeStatsEstimate)unknownStats, (PlanNodeStatsEstimate)second), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((double)PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getOutputRowCount(), (double)30.0);
    }

    @Test
    public void testAddTotalSize() {
        PlanNodeStatsEstimate unknownStats = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, 10.0, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, 20.0, Double.NaN, Double.NaN, StatisticRange.empty());
        Assert.assertEquals((Object)PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues((PlanNodeStatsEstimate)unknownStats, (PlanNodeStatsEstimate)unknownStats), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((Object)PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)unknownStats), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((Object)PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues((PlanNodeStatsEstimate)unknownStats, (PlanNodeStatsEstimate)second), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((double)PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getTotalSize(), (double)30.0);
    }

    @Test
    public void testAddNullsFraction() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownNullsFraction = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, 0.2, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate fractionalRowCountFirst = TestPlanNodeStatsEstimateMath.statistics(0.1, Double.NaN, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate fractionalRowCountSecond = TestPlanNodeStatsEstimateMath.statistics(0.2, Double.NaN, 0.3, Double.NaN, NON_EMPTY_RANGE);
        TestPlanNodeStatsEstimateMath.assertAddNullsFraction(unknownRowCount, unknownRowCount, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertAddNullsFraction(unknownNullsFraction, unknownNullsFraction, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertAddNullsFraction(unknownRowCount, unknownNullsFraction, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertAddNullsFraction(first, unknownNullsFraction, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertAddNullsFraction(unknownRowCount, second, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertAddNullsFraction(first, second, 0.16666666666666666);
        TestPlanNodeStatsEstimateMath.assertAddNullsFraction(fractionalRowCountFirst, fractionalRowCountSecond, 0.2333333333333333);
    }

    private static void assertAddNullsFraction(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second, double expected) {
        Assert.assertEquals((double)PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getVariableStatistics(VARIABLE).getNullsFraction(), (double)expected);
    }

    @Test
    public void testAddAverageRowSize() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, 0.1, 10.0, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownNullsFraction = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, 10.0, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownAverageRowSize = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, 0.1, 15.0, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, 0.2, 20.0, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate fractionalRowCountFirst = TestPlanNodeStatsEstimateMath.statistics(0.1, Double.NaN, 0.1, 0.3, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate fractionalRowCountSecond = TestPlanNodeStatsEstimateMath.statistics(0.2, Double.NaN, 0.3, 0.4, NON_EMPTY_RANGE);
        TestPlanNodeStatsEstimateMath.assertAddAverageRowSize(unknownRowCount, unknownRowCount, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertAddAverageRowSize(unknownNullsFraction, unknownNullsFraction, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertAddAverageRowSize(unknownAverageRowSize, unknownAverageRowSize, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertAddAverageRowSize(first, unknownRowCount, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertAddAverageRowSize(unknownNullsFraction, second, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertAddAverageRowSize(first, unknownAverageRowSize, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertAddAverageRowSize(first, second, 18.2);
        TestPlanNodeStatsEstimateMath.assertAddAverageRowSize(fractionalRowCountFirst, fractionalRowCountSecond, 0.3608695652173913);
    }

    private static void assertAddAverageRowSize(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second, double expected) {
        Assert.assertEquals((double)PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getVariableStatistics(VARIABLE).getAverageRowSize(), (double)expected);
    }

    @Test
    public void testSumNumberOfDistinctValues() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate emptyRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate unknownRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(Double.NaN));
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(2.0));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(3.0));
        TestPlanNodeStatsEstimateMath.assertSumNumberOfDistinctValues(unknownRowCount, unknownRowCount, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertSumNumberOfDistinctValues(unknownRowCount, second, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertSumNumberOfDistinctValues(first, emptyRange, 2.0);
        TestPlanNodeStatsEstimateMath.assertSumNumberOfDistinctValues(first, unknownRange, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertSumNumberOfDistinctValues(first, second, 5.0);
    }

    private static void assertSumNumberOfDistinctValues(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second, double expected) {
        Assert.assertEquals((double)PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getVariableStatistics(VARIABLE).getDistinctValuesCount(), (double)expected);
    }

    @Test
    public void testMaxNumberOfDistinctValues() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate emptyRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate unknownRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(Double.NaN));
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(2.0));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(3.0));
        TestPlanNodeStatsEstimateMath.assertMaxNumberOfDistinctValues(unknownRowCount, unknownRowCount, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertMaxNumberOfDistinctValues(unknownRowCount, second, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertMaxNumberOfDistinctValues(first, emptyRange, 2.0);
        TestPlanNodeStatsEstimateMath.assertMaxNumberOfDistinctValues(first, unknownRange, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertMaxNumberOfDistinctValues(first, second, 3.0);
    }

    private static void assertMaxNumberOfDistinctValues(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second, double expected) {
        Assert.assertEquals((double)PlanNodeStatsEstimateMath.addStatsAndMaxDistinctValues((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getVariableStatistics(VARIABLE).getDistinctValuesCount(), (double)expected);
    }

    @Test
    public void testAddRange() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate emptyRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate unknownRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(Double.NaN));
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, new StatisticRange(12.0, 100.0, 2.0));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, new StatisticRange(101.0, 200.0, 3.0));
        TestPlanNodeStatsEstimateMath.assertAddRange(unknownRange, unknownRange, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        TestPlanNodeStatsEstimateMath.assertAddRange(unknownRowCount, second, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        TestPlanNodeStatsEstimateMath.assertAddRange(unknownRange, second, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        TestPlanNodeStatsEstimateMath.assertAddRange(emptyRange, second, 101.0, 200.0);
        TestPlanNodeStatsEstimateMath.assertAddRange(first, second, 12.0, 200.0);
    }

    private static void assertAddRange(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second, double expectedLow, double expectedHigh) {
        VariableStatsEstimate statistics = PlanNodeStatsEstimateMath.addStatsAndMaxDistinctValues((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getVariableStatistics(VARIABLE);
        Assert.assertEquals((double)statistics.getLowValue(), (double)expectedLow);
        Assert.assertEquals((double)statistics.getHighValue(), (double)expectedHigh);
    }

    @Test
    public void testSubtractRowCount() {
        PlanNodeStatsEstimate unknownStats = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(40.0, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        Assert.assertEquals((Object)PlanNodeStatsEstimateMath.subtractSubsetStats((PlanNodeStatsEstimate)unknownStats, (PlanNodeStatsEstimate)unknownStats), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((Object)PlanNodeStatsEstimateMath.subtractSubsetStats((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)unknownStats), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((Object)PlanNodeStatsEstimateMath.subtractSubsetStats((PlanNodeStatsEstimate)unknownStats, (PlanNodeStatsEstimate)second), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((double)PlanNodeStatsEstimateMath.subtractSubsetStats((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getOutputRowCount(), (double)30.0);
    }

    @Test
    public void testSubtractNullsFraction() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownNullsFraction = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(50.0, Double.NaN, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, 0.2, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate fractionalRowCountFirst = TestPlanNodeStatsEstimateMath.statistics(0.7, Double.NaN, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate fractionalRowCountSecond = TestPlanNodeStatsEstimateMath.statistics(0.2, Double.NaN, 0.3, Double.NaN, NON_EMPTY_RANGE);
        TestPlanNodeStatsEstimateMath.assertSubtractNullsFraction(unknownRowCount, unknownRowCount, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertSubtractNullsFraction(unknownRowCount, unknownNullsFraction, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertSubtractNullsFraction(first, unknownNullsFraction, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertSubtractNullsFraction(unknownRowCount, second, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertSubtractNullsFraction(first, second, 0.03333333333333333);
        TestPlanNodeStatsEstimateMath.assertSubtractNullsFraction(fractionalRowCountFirst, fractionalRowCountSecond, 0.019999999999999993);
    }

    private static void assertSubtractNullsFraction(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second, double expected) {
        Assert.assertEquals((double)PlanNodeStatsEstimateMath.subtractSubsetStats((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getVariableStatistics(VARIABLE).getNullsFraction(), (double)expected);
    }

    @Test
    public void testSubtractNumberOfDistinctValues() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownDistinctValues = TestPlanNodeStatsEstimateMath.statistics(100.0, Double.NaN, 0.1, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(Double.NaN));
        PlanNodeStatsEstimate zero = TestPlanNodeStatsEstimateMath.statistics(0.0, Double.NaN, 0.1, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(0.0));
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(30.0, Double.NaN, 0.1, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(10.0));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, 0.1, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(5.0));
        PlanNodeStatsEstimate third = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, 0.1, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(3.0));
        TestPlanNodeStatsEstimateMath.assertSubtractNumberOfDistinctValues(unknownRowCount, unknownRowCount, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertSubtractNumberOfDistinctValues(unknownRowCount, second, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertSubtractNumberOfDistinctValues(unknownDistinctValues, second, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertSubtractNumberOfDistinctValues(first, zero, 10.0);
        TestPlanNodeStatsEstimateMath.assertSubtractNumberOfDistinctValues(zero, zero, 0.0);
        TestPlanNodeStatsEstimateMath.assertSubtractNumberOfDistinctValues(first, second, 5.0);
        TestPlanNodeStatsEstimateMath.assertSubtractNumberOfDistinctValues(second, third, 5.0);
    }

    private static void assertSubtractNumberOfDistinctValues(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second, double expected) {
        Assert.assertEquals((double)PlanNodeStatsEstimateMath.subtractSubsetStats((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getVariableStatistics(VARIABLE).getDistinctValuesCount(), (double)expected);
    }

    @Test
    public void testSubtractRange() {
        TestPlanNodeStatsEstimateMath.assertSubtractRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        TestPlanNodeStatsEstimateMath.assertSubtractRange(0.0, 1.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, 1.0);
        TestPlanNodeStatsEstimateMath.assertSubtractRange(Double.NaN, Double.NaN, 0.0, 1.0, Double.NaN, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertSubtractRange(0.0, 1.0, Double.NaN, Double.NaN, 0.0, 1.0);
        TestPlanNodeStatsEstimateMath.assertSubtractRange(0.0, 2.0, 0.0, 1.0, 0.0, 2.0);
        TestPlanNodeStatsEstimateMath.assertSubtractRange(0.0, 2.0, 1.0, 2.0, 0.0, 2.0);
        TestPlanNodeStatsEstimateMath.assertSubtractRange(0.0, 2.0, 0.5, 1.0, 0.0, 2.0);
    }

    private static void assertSubtractRange(double supersetLow, double supersetHigh, double subsetLow, double subsetHigh, double expectedLow, double expectedHigh) {
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(30.0, Double.NaN, Double.NaN, Double.NaN, new StatisticRange(supersetLow, supersetHigh, 10.0));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, Double.NaN, new StatisticRange(subsetLow, subsetHigh, 5.0));
        VariableStatsEstimate statistics = PlanNodeStatsEstimateMath.subtractSubsetStats((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getVariableStatistics(VARIABLE);
        Assert.assertEquals((double)statistics.getLowValue(), (double)expectedLow);
        Assert.assertEquals((double)statistics.getHighValue(), (double)expectedHigh);
    }

    @Test
    public void testCapRowCount() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        Assert.assertEquals((double)PlanNodeStatsEstimateMath.capStats((PlanNodeStatsEstimate)unknownRowCount, (PlanNodeStatsEstimate)unknownRowCount).getOutputRowCount(), (double)Double.NaN);
        Assert.assertEquals((double)PlanNodeStatsEstimateMath.capStats((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)unknownRowCount).getOutputRowCount(), (double)Double.NaN);
        Assert.assertEquals((double)PlanNodeStatsEstimateMath.capStats((PlanNodeStatsEstimate)unknownRowCount, (PlanNodeStatsEstimate)second).getOutputRowCount(), (double)Double.NaN);
        Assert.assertEquals((double)PlanNodeStatsEstimateMath.capStats((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getOutputRowCount(), (double)10.0);
        Assert.assertEquals((double)PlanNodeStatsEstimateMath.capStats((PlanNodeStatsEstimate)second, (PlanNodeStatsEstimate)first).getOutputRowCount(), (double)10.0);
    }

    @Test
    public void testCapAverageRowSize() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownAverageRowSize = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, 10.0, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, 5.0, NON_EMPTY_RANGE);
        TestPlanNodeStatsEstimateMath.assertCapAverageRowSize(unknownRowCount, unknownRowCount, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertCapAverageRowSize(unknownAverageRowSize, unknownAverageRowSize, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertCapAverageRowSize(first, unknownAverageRowSize, 10.0);
        TestPlanNodeStatsEstimateMath.assertCapAverageRowSize(unknownAverageRowSize, second, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertCapAverageRowSize(first, second, 10.0);
    }

    private static void assertCapAverageRowSize(PlanNodeStatsEstimate stats, PlanNodeStatsEstimate cap, double expected) {
        Assert.assertEquals((double)PlanNodeStatsEstimateMath.capStats((PlanNodeStatsEstimate)stats, (PlanNodeStatsEstimate)cap).getVariableStatistics(VARIABLE).getAverageRowSize(), (double)expected);
    }

    @Test
    public void testCapNumberOfDistinctValues() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownNumberOfDistinctValues = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(Double.NaN));
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(10.0));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(5.0));
        TestPlanNodeStatsEstimateMath.assertCapNumberOfDistinctValues(unknownRowCount, unknownRowCount, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertCapNumberOfDistinctValues(unknownNumberOfDistinctValues, unknownNumberOfDistinctValues, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertCapNumberOfDistinctValues(first, unknownRowCount, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertCapNumberOfDistinctValues(unknownNumberOfDistinctValues, second, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertCapNumberOfDistinctValues(first, second, 5.0);
    }

    private static void assertCapNumberOfDistinctValues(PlanNodeStatsEstimate stats, PlanNodeStatsEstimate cap, double expected) {
        Assert.assertEquals((double)PlanNodeStatsEstimateMath.capStats((PlanNodeStatsEstimate)stats, (PlanNodeStatsEstimate)cap).getVariableStatistics(VARIABLE).getDistinctValuesCount(), (double)expected);
    }

    @Test
    public void testCapRange() {
        PlanNodeStatsEstimate emptyRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate openRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(Double.NaN));
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, new StatisticRange(12.0, 100.0, Double.NaN));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, new StatisticRange(13.0, 99.0, Double.NaN));
        TestPlanNodeStatsEstimateMath.assertCapRange(emptyRange, emptyRange, Double.NaN, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertCapRange(emptyRange, openRange, Double.NaN, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertCapRange(openRange, emptyRange, Double.NaN, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertCapRange(first, openRange, 12.0, 100.0);
        TestPlanNodeStatsEstimateMath.assertCapRange(openRange, second, 13.0, 99.0);
        TestPlanNodeStatsEstimateMath.assertCapRange(first, second, 13.0, 99.0);
    }

    private static void assertCapRange(PlanNodeStatsEstimate stats, PlanNodeStatsEstimate cap, double expectedLow, double expectedHigh) {
        VariableStatsEstimate symbolStats = PlanNodeStatsEstimateMath.capStats((PlanNodeStatsEstimate)stats, (PlanNodeStatsEstimate)cap).getVariableStatistics(VARIABLE);
        Assert.assertEquals((double)symbolStats.getLowValue(), (double)expectedLow);
        Assert.assertEquals((double)symbolStats.getHighValue(), (double)expectedHigh);
    }

    @Test
    public void testCapNullsFraction() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownNullsFraction = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, 0.25, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, 0.6, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate third = TestPlanNodeStatsEstimateMath.statistics(0.0, Double.NaN, 0.6, Double.NaN, NON_EMPTY_RANGE);
        TestPlanNodeStatsEstimateMath.assertCapNullsFraction(unknownRowCount, unknownRowCount, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertCapNullsFraction(unknownNullsFraction, unknownNullsFraction, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertCapNullsFraction(first, unknownNullsFraction, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertCapNullsFraction(unknownNullsFraction, second, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertCapNullsFraction(first, second, 0.5);
        TestPlanNodeStatsEstimateMath.assertCapNullsFraction(first, third, 1.0);
    }

    private static void assertCapNullsFraction(PlanNodeStatsEstimate stats, PlanNodeStatsEstimate cap, double expected) {
        Assert.assertEquals((double)PlanNodeStatsEstimateMath.capStats((PlanNodeStatsEstimate)stats, (PlanNodeStatsEstimate)cap).getVariableStatistics(VARIABLE).getNullsFraction(), (double)expected);
    }

    @Test
    public void testAddHistograms() {
        StatisticRange zeroToTen = new StatisticRange(0.0, 10.0, 1.0);
        StatisticRange zeroToFive = new StatisticRange(0.0, 5.0, 1.0);
        StatisticRange fiveToTen = new StatisticRange(5.0, 10.0, 1.0);
        StatisticRange threeToSeven = new StatisticRange(3.0, 7.0, 1.0);
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, zeroToTen);
        PlanNodeStatsEstimate unknownNullsFraction = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, zeroToTen);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(50.0, Double.NaN, 0.25, Double.NaN, zeroToTen);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(25.0, Double.NaN, 0.6, Double.NaN, zeroToFive);
        PlanNodeStatsEstimate third = TestPlanNodeStatsEstimateMath.statistics(25.0, Double.NaN, 0.6, Double.NaN, fiveToTen);
        PlanNodeStatsEstimate fourth = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, 0.6, Double.NaN, threeToSeven);
        ConnectorHistogram nanHistogram = VariableStatsEstimate.unknown().getHistogram();
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(unknownRowCount, unknownRowCount, PlanNodeStatsEstimateMath::addStatsAndCollapseDistinctValues, nanHistogram);
        ConnectorHistogram addedSameRange = DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)unknownNullsFraction.getVariableStatistics(VARIABLE).getHistogram(), (StatisticRange)zeroToTen);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(unknownNullsFraction, unknownNullsFraction, PlanNodeStatsEstimateMath::addStatsAndSumDistinctValues, addedSameRange);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(unknownNullsFraction, unknownNullsFraction, PlanNodeStatsEstimateMath::addStatsAndCollapseDistinctValues, addedSameRange);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(unknownNullsFraction, unknownNullsFraction, PlanNodeStatsEstimateMath::addStatsAndMaxDistinctValues, addedSameRange);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(unknownNullsFraction, unknownNullsFraction, PlanNodeStatsEstimateMath::addStatsAndIntersect, addedSameRange);
        ConnectorHistogram fullRangeFirst = DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)first.getVariableStatistics(VARIABLE).getHistogram(), (StatisticRange)zeroToTen);
        ConnectorHistogram intersectedRangeSecond = DisjointRangeDomainHistogram.addConjunction((ConnectorHistogram)first.getVariableStatistics(VARIABLE).getHistogram(), (StatisticRange)zeroToFive);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(first, second, PlanNodeStatsEstimateMath::addStatsAndSumDistinctValues, fullRangeFirst);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(first, second, PlanNodeStatsEstimateMath::addStatsAndCollapseDistinctValues, fullRangeFirst);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(first, second, PlanNodeStatsEstimateMath::addStatsAndMaxDistinctValues, fullRangeFirst);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(first, second, PlanNodeStatsEstimateMath::addStatsAndIntersect, intersectedRangeSecond);
        ConnectorHistogram fullRangeSecondThird = DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)second.getVariableStatistics(VARIABLE).getHistogram(), (StatisticRange)fiveToTen);
        ConnectorHistogram intersectedRangeSecondThird = DisjointRangeDomainHistogram.addConjunction((ConnectorHistogram)second.getVariableStatistics(VARIABLE).getHistogram(), (StatisticRange)fiveToTen);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(second, third, PlanNodeStatsEstimateMath::addStatsAndSumDistinctValues, fullRangeSecondThird);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(second, third, PlanNodeStatsEstimateMath::addStatsAndCollapseDistinctValues, fullRangeSecondThird);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(second, third, PlanNodeStatsEstimateMath::addStatsAndMaxDistinctValues, fullRangeSecondThird);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(second, third, PlanNodeStatsEstimateMath::addStatsAndIntersect, intersectedRangeSecondThird);
        ConnectorHistogram fullRangeThirdFourth = DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)third.getVariableStatistics(VARIABLE).getHistogram(), (StatisticRange)threeToSeven);
        ConnectorHistogram intersectedRangeThirdFourth = DisjointRangeDomainHistogram.addConjunction((ConnectorHistogram)third.getVariableStatistics(VARIABLE).getHistogram(), (StatisticRange)threeToSeven);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(third, fourth, PlanNodeStatsEstimateMath::addStatsAndSumDistinctValues, fullRangeThirdFourth);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(third, fourth, PlanNodeStatsEstimateMath::addStatsAndCollapseDistinctValues, fullRangeThirdFourth);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(third, fourth, PlanNodeStatsEstimateMath::addStatsAndMaxDistinctValues, fullRangeThirdFourth);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(third, fourth, PlanNodeStatsEstimateMath::addStatsAndIntersect, intersectedRangeThirdFourth);
    }

    private static void assertAddStatsHistogram(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second, BiFunction<PlanNodeStatsEstimate, PlanNodeStatsEstimate, PlanNodeStatsEstimate> function, ConnectorHistogram expected) {
        Assert.assertEquals((Object)function.apply(first, second).getVariableStatistics(VARIABLE).getHistogram(), (Object)expected);
    }

    private static PlanNodeStatsEstimate statistics(double rowCount, double totalSize, double nullsFraction, double averageRowSize, StatisticRange range) {
        return PlanNodeStatsEstimate.builder().setOutputRowCount(rowCount).setTotalSize(totalSize).addVariableStatistics(VARIABLE, VariableStatsEstimate.builder().setNullsFraction(nullsFraction).setAverageRowSize(averageRowSize).setStatisticsRange(range).setHistogram(DisjointRangeDomainHistogram.addConjunction((ConnectorHistogram)new UniformDistributionHistogram(range.getLow(), range.getHigh()), (StatisticRange)range)).build()).build();
    }

    private static StatisticRange openRange(double distinctValues) {
        return new StatisticRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, distinctValues);
    }
}

