/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.scheduler.ResettableRandomizedIterator;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestResettableRandomizedIterator {
    @Test
    public void testResetting() {
        ImmutableSet expected = new HashSet();
        for (int i = 0; i < 100; ++i) {
            expected.add(i);
        }
        expected = ImmutableSet.copyOf(expected);
        ResettableRandomizedIterator randomizedIterator = new ResettableRandomizedIterator((Collection)expected);
        HashSet<Object> actual = new HashSet<Object>();
        while (randomizedIterator.hasNext()) {
            actual.add(randomizedIterator.next());
        }
        Assert.assertEquals(actual, (Set)expected);
        actual.clear();
        randomizedIterator.reset();
        while (randomizedIterator.hasNext()) {
            actual.add(randomizedIterator.next());
        }
        Assert.assertEquals(actual, (Set)expected);
    }

    @Test
    public void testRandom() {
        int i;
        ImmutableSet values = new HashSet();
        for (int i2 = 0; i2 < 100; ++i2) {
            values.add(i2);
        }
        values = ImmutableSet.copyOf(values);
        ResettableRandomizedIterator randomizedIterator = new ResettableRandomizedIterator((Collection)values);
        ArrayList<Object> list1 = new ArrayList<Object>();
        ArrayList<Object> list2 = new ArrayList<Object>();
        randomizedIterator.reset();
        for (i = 0; i < 99; ++i) {
            list1.add(randomizedIterator.next());
        }
        randomizedIterator.reset();
        for (i = 0; i < 99; ++i) {
            list2.add(randomizedIterator.next());
        }
        Assert.assertNotEquals(list1, list2);
    }
}

