/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.execution.QueryIdGenerator;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.BufferTestUtils;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.buffer.SpoolingOutputBuffer;
import com.facebook.presto.execution.buffer.SpoolingOutputBufferFactory;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSpoolingOutputBuffer {
    private static final String TASK_INSTANCE_ID = "task-instance-id";
    private static final DataSize THRESHOLD = BufferTestUtils.sizeOfPages(3);
    private static final List<BigintType> TYPES = ImmutableList.of((Object)BigintType.BIGINT);
    private static final OutputBuffers.OutputBufferId BUFFER_ID = new OutputBuffers.OutputBufferId(0);
    private static final OutputBuffers.OutputBufferId INVALID_BUFFER_ID = new OutputBuffers.OutputBufferId(1);
    private static final OutputBuffers OUTPUT_BUFFERS = OutputBuffers.createSpoolingOutputBuffers();
    private static final QueryIdGenerator queryIdGenerator = new QueryIdGenerator();
    private static SpoolingOutputBufferFactory spoolingOutputBufferFactory;
    private ScheduledExecutorService stateNotificationExecutor;

    @BeforeClass
    public void setUp() {
        this.stateNotificationExecutor = Executors.newScheduledThreadPool(5, Threads.daemonThreadsNamed((String)"test-%s"));
        FeaturesConfig featuresConfig = new FeaturesConfig();
        featuresConfig.setSpoolingOutputBufferThreshold(THRESHOLD);
        spoolingOutputBufferFactory = new SpoolingOutputBufferFactory(featuresConfig);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws IOException {
        if (this.stateNotificationExecutor != null) {
            this.stateNotificationExecutor.shutdownNow();
            this.stateNotificationExecutor = null;
        }
        spoolingOutputBufferFactory.shutdown();
    }

    @Test
    public void testSimpleInMemory() {
        SpoolingOutputBuffer buffer = this.createSpoolingOutputBuffer();
        for (int i = 0; i < 2; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        this.compareTotalBuffered((OutputBuffer)buffer, 2);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.MAX_WAIT), TestSpoolingOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        this.compareTotalBuffered((OutputBuffer)buffer, 2);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 1L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.MAX_WAIT), TestSpoolingOutputBuffer.bufferResult(1L, BufferTestUtils.createPage(1), new Page[0]));
        this.compareTotalBuffered((OutputBuffer)buffer, 1);
        buffer.setNoMorePages();
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 2L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)2L, (boolean)true));
        this.compareTotalBuffered((OutputBuffer)buffer, 0);
    }

    @Test
    public void testSimple() {
        int i;
        SpoolingOutputBuffer buffer = this.createSpoolingOutputBuffer();
        LinkedList<Object> pages = new LinkedList<Page>();
        for (i = 0; i < 5; ++i) {
            pages.add(BufferTestUtils.createPage(i));
        }
        BufferTestUtils.addPages((OutputBuffer)buffer, pages);
        this.compareTotalBuffered((OutputBuffer)buffer, 5);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.MAX_WAIT), TestSpoolingOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        this.compareTotalBuffered((OutputBuffer)buffer, 5);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 1L, BufferTestUtils.sizeOfPages(2), BufferTestUtils.MAX_WAIT), TestSpoolingOutputBuffer.bufferResult(1L, BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        this.compareTotalBuffered((OutputBuffer)buffer, 5);
        pages = new LinkedList();
        for (i = 5; i < 8; ++i) {
            pages.add(BufferTestUtils.createPage(i));
        }
        BufferTestUtils.addPages((OutputBuffer)buffer, pages);
        this.compareTotalBuffered((OutputBuffer)buffer, 8);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 3L, BufferTestUtils.sizeOfPages(3), BufferTestUtils.MAX_WAIT), TestSpoolingOutputBuffer.bufferResult(3L, BufferTestUtils.createPage(3), BufferTestUtils.createPage(4), BufferTestUtils.createPage(5)));
        this.compareTotalBuffered((OutputBuffer)buffer, 8);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 6L, BufferTestUtils.sizeOfPages(2), BufferTestUtils.MAX_WAIT), TestSpoolingOutputBuffer.bufferResult(6L, BufferTestUtils.createPage(6), BufferTestUtils.createPage(7)));
        this.compareTotalBuffered((OutputBuffer)buffer, 3);
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(8));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 8L, BufferTestUtils.sizeOfPages(2), BufferTestUtils.MAX_WAIT), TestSpoolingOutputBuffer.bufferResult(8L, BufferTestUtils.createPage(8), new Page[0]));
        this.compareTotalBuffered((OutputBuffer)buffer, 1);
        ListenableFuture pendingRead = buffer.get(BUFFER_ID, 9L, BufferTestUtils.sizeOfPages(1));
        Assert.assertFalse((boolean)pendingRead.isDone());
        this.compareTotalBuffered((OutputBuffer)buffer, 0);
        buffer.setNoMorePages();
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 9L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)9L, (boolean)true));
        Assert.assertEquals((long)buffer.getInfo().getTotalPagesSent(), (long)9L);
    }

    @Test
    void testUnevenMaxSize() {
        int i;
        SpoolingOutputBuffer buffer = this.createSpoolingOutputBuffer();
        LinkedList<Page> pages = new LinkedList<Page>();
        for (i = 0; i < 5; ++i) {
            pages.add(BufferTestUtils.createPage(i));
        }
        BufferTestUtils.addPages((OutputBuffer)buffer, pages);
        for (i = 5; i < 8; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        DataSize unevenMaxSize = new DataSize((double)(BufferTestUtils.sizeOfPages(3).toBytes() + 5L), DataSize.Unit.BYTE);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 0L, unevenMaxSize, BufferTestUtils.MAX_WAIT), TestSpoolingOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        this.compareTotalBuffered((OutputBuffer)buffer, 8);
    }

    @Test
    void testGetOutOfOrder() {
        SpoolingOutputBuffer buffer = this.createSpoolingOutputBuffer();
        LinkedList<Page> pages = new LinkedList<Page>();
        for (int i = 0; i < 5; ++i) {
            pages.add(BufferTestUtils.createPage(i));
        }
        BufferTestUtils.addPages((OutputBuffer)buffer, pages);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 0L, BufferTestUtils.sizeOfPages(3), BufferTestUtils.MAX_WAIT), TestSpoolingOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        this.compareTotalBuffered((OutputBuffer)buffer, 5);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 3L, BufferTestUtils.sizeOfPages(3), BufferTestUtils.MAX_WAIT), TestSpoolingOutputBuffer.bufferResult(3L, BufferTestUtils.createPage(3), BufferTestUtils.createPage(4)));
        this.compareTotalBuffered((OutputBuffer)buffer, 5);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 2L, BufferTestUtils.sizeOfPages(3), BufferTestUtils.MAX_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)2L, (boolean)false));
        this.compareTotalBuffered((OutputBuffer)buffer, 5);
    }

    @Test
    public void testSimplePendingRead() {
        SpoolingOutputBuffer buffer = this.createSpoolingOutputBuffer();
        ListenableFuture future = buffer.get(BUFFER_ID, 0L, BufferTestUtils.sizeOfPages(2));
        Assert.assertFalse((boolean)future.isDone());
        LinkedList<Page> pages = new LinkedList<Page>();
        for (int i = 0; i < 3; ++i) {
            pages.add(BufferTestUtils.createPage(i));
        }
        BufferTestUtils.addPages((OutputBuffer)buffer, pages);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.MAX_WAIT), TestSpoolingOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1)));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 0L, BufferTestUtils.sizeOfPages(3), BufferTestUtils.MAX_WAIT), BufferTestUtils.createBufferResult(TASK_INSTANCE_ID, 0L, pages));
        BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, BUFFER_ID, 2L);
        this.compareTotalBuffered((OutputBuffer)buffer, 3);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 2L, BufferTestUtils.sizeOfPages(3), BufferTestUtils.MAX_WAIT), TestSpoolingOutputBuffer.bufferResult(2L, BufferTestUtils.createPage(2), new Page[0]));
        BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, BUFFER_ID, 3L);
        this.compareTotalBuffered((OutputBuffer)buffer, 0);
        future = buffer.get(BUFFER_ID, 3L, BufferTestUtils.sizeOfPages(3));
        Assert.assertFalse((boolean)future.isDone());
    }

    @Test
    public void testMultiplePendingReads() {
        SpoolingOutputBuffer buffer = this.createSpoolingOutputBuffer();
        ListenableFuture oldPendingRead = buffer.get(BUFFER_ID, 0L, BufferTestUtils.sizeOfPages(3));
        Assert.assertFalse((boolean)oldPendingRead.isDone());
        ListenableFuture newPendingRead = buffer.get(BUFFER_ID, 0L, BufferTestUtils.sizeOfPages(3));
        Assert.assertFalse((boolean)newPendingRead.isDone());
        Assert.assertTrue((boolean)oldPendingRead.isDone());
        LinkedList<Page> pages = new LinkedList<Page>();
        for (int i = 0; i < 3; ++i) {
            pages.add(BufferTestUtils.createPage(i));
        }
        BufferTestUtils.addPages((OutputBuffer)buffer, pages);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)oldPendingRead, BufferTestUtils.MAX_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)false));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)newPendingRead, BufferTestUtils.MAX_WAIT), BufferTestUtils.createBufferResult(TASK_INSTANCE_ID, 0L, pages));
    }

    @Test
    public void testAddAfterPendingRead() {
        SpoolingOutputBuffer buffer = this.createSpoolingOutputBuffer();
        ListenableFuture pendingRead = buffer.get(BUFFER_ID, 0L, BufferTestUtils.sizeOfPages(5));
        Assert.assertFalse((boolean)pendingRead.isDone());
        LinkedList<Page> pages = new LinkedList<Page>();
        for (int i = 0; i < 5; ++i) {
            pages.add(BufferTestUtils.createPage(i));
        }
        BufferTestUtils.addPages((OutputBuffer)buffer, pages);
        this.compareTotalBuffered((OutputBuffer)buffer, 5);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)pendingRead, BufferTestUtils.MAX_WAIT), BufferTestUtils.createBufferResult(TASK_INSTANCE_ID, 0L, pages));
        this.compareTotalBuffered((OutputBuffer)buffer, 5);
        BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, BUFFER_ID, 5L);
        buffer.setNoMorePages();
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 5L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)5L, (boolean)true));
    }

    @Test
    public void testNoMorePagesAfterPendingRead() {
        SpoolingOutputBuffer buffer = this.createSpoolingOutputBuffer();
        ListenableFuture pendingRead = buffer.get(BUFFER_ID, 0L, BufferTestUtils.sizeOfPages(5));
        Assert.assertFalse((boolean)pendingRead.isDone());
        buffer.setNoMorePages();
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)pendingRead, BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)true));
    }

    @Test
    public void testDestroyAfterPendingRead() {
        SpoolingOutputBuffer buffer = this.createSpoolingOutputBuffer();
        ListenableFuture pendingRead = buffer.get(BUFFER_ID, 0L, BufferTestUtils.sizeOfPages(5));
        Assert.assertFalse((boolean)pendingRead.isDone());
        buffer.destroy();
        Assert.assertTrue((boolean)pendingRead.isDone());
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)pendingRead, BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)false));
    }

    @Test
    public void testAcknowledgeSimple() {
        SpoolingOutputBuffer buffer = this.createSpoolingOutputBuffer();
        for (int i = 0; i < 3; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.MAX_WAIT), TestSpoolingOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, BUFFER_ID, 2L);
        this.compareTotalBuffered((OutputBuffer)buffer, 3);
        BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, BUFFER_ID, 3L);
        this.compareTotalBuffered((OutputBuffer)buffer, 0);
        try {
            BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, BUFFER_ID, 4L);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid sequenceId");
        }
        this.compareTotalBuffered((OutputBuffer)buffer, 0);
        for (int i = 3; i < 6; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, BUFFER_ID, 3L);
        this.compareTotalBuffered((OutputBuffer)buffer, 3);
    }

    @Test
    public void testAcknowledgeStorageAndMemory() {
        int i;
        SpoolingOutputBuffer buffer = this.createSpoolingOutputBuffer();
        for (i = 0; i < 3; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        for (i = 3; i < 5; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, BUFFER_ID, 4L);
        this.compareTotalBuffered((OutputBuffer)buffer, 1);
    }

    @Test
    public void testDuplicateGet() {
        SpoolingOutputBuffer buffer = this.createSpoolingOutputBuffer();
        for (int i = 0; i < 3; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.MAX_WAIT), TestSpoolingOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        this.compareTotalBuffered((OutputBuffer)buffer, 3);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.MAX_WAIT), TestSpoolingOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        this.compareTotalBuffered((OutputBuffer)buffer, 3);
        BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, BUFFER_ID, 3L);
        this.compareTotalBuffered((OutputBuffer)buffer, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)false));
        this.compareTotalBuffered((OutputBuffer)buffer, 0);
    }

    @Test
    public void testAddAfterNoMorePages() {
        SpoolingOutputBuffer buffer = this.createSpoolingOutputBuffer();
        for (int i = 0; i < 2; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        this.compareTotalBuffered((OutputBuffer)buffer, 2);
        buffer.setNoMorePages();
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(2));
        this.compareTotalBuffered((OutputBuffer)buffer, 2);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 0L, BufferTestUtils.sizeOfPages(3), BufferTestUtils.MAX_WAIT), TestSpoolingOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1)));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 2L, BufferTestUtils.sizeOfPages(3), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)2L, (boolean)true));
    }

    @Test
    public void testAddAfterDestroy() {
        SpoolingOutputBuffer buffer = this.createSpoolingOutputBuffer();
        for (int i = 0; i < 2; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        this.compareTotalBuffered((OutputBuffer)buffer, 2);
        buffer.destroy();
        this.compareTotalBuffered((OutputBuffer)buffer, 0);
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(2));
        this.compareTotalBuffered((OutputBuffer)buffer, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 0L, BufferTestUtils.sizeOfPages(3), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)true));
    }

    @Test
    public void testAbort() {
        int i;
        SpoolingOutputBuffer buffer = this.createSpoolingOutputBuffer();
        for (i = 0; i < 3; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        for (i = 3; i < 5; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        try {
            buffer.abort(INVALID_BUFFER_ID);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid bufferId");
        }
        this.compareTotalBuffered((OutputBuffer)buffer, 5);
        buffer.abort(BUFFER_ID);
        this.compareTotalBuffered((OutputBuffer)buffer, 0);
    }

    @Test
    public void testSetOutputBuffers() {
        SpoolingOutputBuffer buffer = this.createSpoolingOutputBuffer();
        OutputBuffers newBuffers = new OutputBuffers(OutputBuffers.BufferType.SPOOLING, 1L, true, (Map)ImmutableMap.of());
        buffer.setOutputBuffers(newBuffers);
        OutputBuffers invalidBuffers = new OutputBuffers(OutputBuffers.BufferType.PARTITIONED, 1L, true, (Map)ImmutableMap.of());
        try {
            buffer.setOutputBuffers(invalidBuffers);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid output buffers type");
        }
    }

    @Test
    public void testBufferCompletion() {
        Page page;
        int i;
        SpoolingOutputBuffer buffer = this.createSpoolingOutputBuffer();
        Assert.assertFalse((boolean)buffer.isFinished());
        ArrayList<Page> pages = new ArrayList<Page>();
        for (i = 0; i < 3; ++i) {
            page = BufferTestUtils.createPage(i);
            BufferTestUtils.addPage((OutputBuffer)buffer, page);
            pages.add(BufferTestUtils.createPage(i));
        }
        for (i = 3; i < 5; ++i) {
            page = BufferTestUtils.createPage(i);
            BufferTestUtils.addPage((OutputBuffer)buffer, page);
            pages.add(BufferTestUtils.createPage(i));
        }
        this.compareTotalBuffered((OutputBuffer)buffer, 5);
        buffer.setNoMorePages();
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, BUFFER_ID, 0L, BufferTestUtils.sizeOfPages(5), BufferTestUtils.MAX_WAIT), BufferTestUtils.createBufferResult(TASK_INSTANCE_ID, 0L, pages));
        Assert.assertFalse((boolean)buffer.isFinished());
        buffer.destroy();
        Assert.assertTrue((boolean)buffer.isFinished());
    }

    private SpoolingOutputBuffer createSpoolingOutputBuffer() {
        TaskId taskId = new TaskId(queryIdGenerator.createNextQueryId().toString(), 0, 0, 0, 0);
        return spoolingOutputBufferFactory.createSpoolingOutputBuffer(taskId, TASK_INSTANCE_ID, OUTPUT_BUFFERS, new StateMachine("bufferState", (Executor)this.stateNotificationExecutor, (Object)BufferState.OPEN, (Iterable)BufferState.TERMINAL_BUFFER_STATES));
    }

    private static BufferResult bufferResult(long token, Page firstPage, Page ... otherPages) {
        ImmutableList pages = ImmutableList.builder().add((Object)firstPage).add((Object[])otherPages).build();
        return BufferTestUtils.createBufferResult(TASK_INSTANCE_ID, token, (List<Page>)pages);
    }

    private void compareTotalBuffered(OutputBuffer buffer, int expectedBufferedPages) {
        Assert.assertEquals((long)buffer.getInfo().getTotalBufferedBytes(), (long)((int)BufferTestUtils.sizeOfPages(expectedBufferedPages).getValue()));
        Assert.assertEquals((long)buffer.getInfo().getTotalBufferedPages(), (long)expectedBufferedPages);
    }
}

