/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.geospatial.SphericalGeographyType;
import com.facebook.presto.geospatial.type.GeometryType;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.ExtractSpatialJoins;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleAssert;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestExtractSpatialLeftJoin
extends BaseRuleTest {
    private TestingRowExpressionTranslator sqlToRowExpressionTranslator;

    public TestExtractSpatialLeftJoin() {
        super(new Plugin[0]);
    }

    @BeforeClass
    public void setupTranslator() {
        this.sqlToRowExpressionTranslator = new TestingRowExpressionTranslator(this.tester().getMetadata());
    }

    @Test
    public void testDoesNotFire() {
        this.assertRuleApplication().on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(), (PlanNode)p.values(p.variable("b", (Type)GeometryType.GEOMETRY)), this.sqlToRowExpression("ST_Contains(ST_GeometryFromText('POLYGON ((0 0, 0 0, 0 0, 0 0))'), b)", (Map<String, Type>)ImmutableMap.of((Object)"b", (Object)GeometryType.GEOMETRY)), new EquiJoinClause[0])).doesNotFire();
        this.assertRuleApplication().on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("wkt", (Type)VarcharType.VARCHAR), p.variable("name_1")), (PlanNode)p.values(p.variable("point", (Type)GeometryType.GEOMETRY), p.variable("name_2")), this.sqlToRowExpression("ST_Contains(ST_GeometryFromText(wkt), point) OR name_1 != name_2", (Map<String, Type>)ImmutableMap.of((Object)"wkt", (Object)VarcharType.VARCHAR, (Object)"point", (Object)GeometryType.GEOMETRY, (Object)"name_1", (Object)BigintType.BIGINT, (Object)"name_2", (Object)BigintType.BIGINT)), new EquiJoinClause[0])).doesNotFire();
        this.assertRuleApplication().on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("wkt", (Type)VarcharType.VARCHAR), p.variable("name_1")), (PlanNode)p.values(p.variable("point", (Type)GeometryType.GEOMETRY), p.variable("name_2")), this.sqlToRowExpression("NOT ST_Contains(ST_GeometryFromText(wkt), point)", (Map<String, Type>)ImmutableMap.of((Object)"wkt", (Object)VarcharType.VARCHAR, (Object)"point", (Object)GeometryType.GEOMETRY, (Object)"name_1", (Object)BigintType.BIGINT, (Object)"name_2", (Object)BigintType.BIGINT)), new EquiJoinClause[0])).doesNotFire();
        this.assertRuleApplication().on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("a", (Type)GeometryType.GEOMETRY)), (PlanNode)p.values(p.variable("b", (Type)GeometryType.GEOMETRY)), this.sqlToRowExpression("ST_Distance(a, b) > 5", (Map<String, Type>)ImmutableMap.of((Object)"a", (Object)GeometryType.GEOMETRY, (Object)"b", (Object)GeometryType.GEOMETRY)), new EquiJoinClause[0])).doesNotFire();
        this.assertRuleApplication().on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("a", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)), (PlanNode)p.values(p.variable("b", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)), this.sqlToRowExpression("ST_Distance(a, b) < 5", (Map<String, Type>)ImmutableMap.of((Object)"a", (Object)SphericalGeographyType.SPHERICAL_GEOGRAPHY, (Object)"b", (Object)SphericalGeographyType.SPHERICAL_GEOGRAPHY)), new EquiJoinClause[0])).doesNotFire();
        this.assertRuleApplication().on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("wkt", (Type)VarcharType.VARCHAR)), (PlanNode)p.values(p.variable("point", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)), this.sqlToRowExpression("ST_Distance(to_spherical_geography(ST_GeometryFromText(wkt)), point) < 5", (Map<String, Type>)ImmutableMap.of((Object)"wkt", (Object)VarcharType.VARCHAR, (Object)"point", (Object)SphericalGeographyType.SPHERICAL_GEOGRAPHY)), new EquiJoinClause[0])).doesNotFire();
    }

    @Test(enabled=false)
    public void testSphericalGeographiesDoesNotFire() {
        this.assertRuleApplication().on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("polygon", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)), (PlanNode)p.values(p.variable("point", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)), this.sqlToRowExpression("ST_Contains(polygon, point)", (Map<String, Type>)ImmutableMap.of((Object)"polygon", (Object)SphericalGeographyType.SPHERICAL_GEOGRAPHY, (Object)"point", (Object)SphericalGeographyType.SPHERICAL_GEOGRAPHY)), new EquiJoinClause[0])).doesNotFire();
        this.assertRuleApplication().on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("wkt", (Type)VarcharType.VARCHAR)), (PlanNode)p.values(p.variable("point", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)), this.sqlToRowExpression("ST_Contains(to_spherical_geography(ST_GeometryFromText(wkt)), point)", (Map<String, Type>)ImmutableMap.of((Object)"wkt", (Object)VarcharType.VARCHAR, (Object)"point", (Object)SphericalGeographyType.SPHERICAL_GEOGRAPHY)), new EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testConvertToSpatialJoin() {
        this.assertRuleApplication().on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("a", (Type)GeometryType.GEOMETRY)), (PlanNode)p.values(p.variable("b", (Type)GeometryType.GEOMETRY)), this.sqlToRowExpression("ST_Contains(a, b)", (Map<String, Type>)ImmutableMap.of((Object)"a", (Object)GeometryType.GEOMETRY, (Object)"b", (Object)GeometryType.GEOMETRY)), new EquiJoinClause[0])).matches(PlanMatchPattern.spatialLeftJoin("ST_Contains(a, b)", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"b", (Object)0))));
        this.assertRuleApplication().on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("a", (Type)GeometryType.GEOMETRY), p.variable("name_1")), (PlanNode)p.values(p.variable("b", (Type)GeometryType.GEOMETRY), p.variable("name_2")), this.sqlToRowExpression("name_1 != name_2 AND ST_Contains(a, b)", (Map<String, Type>)ImmutableMap.of((Object)"a", (Object)GeometryType.GEOMETRY, (Object)"b", (Object)GeometryType.GEOMETRY, (Object)"name_1", (Object)BigintType.BIGINT, (Object)"name_2", (Object)BigintType.BIGINT)), new EquiJoinClause[0])).matches(PlanMatchPattern.spatialLeftJoin("name_1 != name_2 AND ST_Contains(a, b)", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0, (Object)"name_1", (Object)1)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"b", (Object)0, (Object)"name_2", (Object)1))));
        this.assertRuleApplication().on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("a1", (Type)GeometryType.GEOMETRY), p.variable("a2", (Type)GeometryType.GEOMETRY)), (PlanNode)p.values(p.variable("b1", (Type)GeometryType.GEOMETRY), p.variable("b2", (Type)GeometryType.GEOMETRY)), this.sqlToRowExpression("ST_Contains(a1, b1) AND ST_Contains(a2, b2)", (Map<String, Type>)ImmutableMap.of((Object)"a1", (Object)GeometryType.GEOMETRY, (Object)"b1", (Object)GeometryType.GEOMETRY, (Object)"a2", (Object)GeometryType.GEOMETRY, (Object)"b2", (Object)GeometryType.GEOMETRY)), new EquiJoinClause[0])).matches(PlanMatchPattern.spatialLeftJoin("ST_Contains(a1, b1) AND ST_Contains(a2, b2)", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a1", (Object)0, (Object)"a2", (Object)1)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"b1", (Object)0, (Object)"b2", (Object)1))));
    }

    @Test
    public void testPushDownFirstArgument() {
        this.assertRuleApplication().on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("wkt", (Type)VarcharType.VARCHAR)), (PlanNode)p.values(p.variable("point", (Type)GeometryType.GEOMETRY)), this.sqlToRowExpression("ST_Contains(ST_GeometryFromText(wkt), point)", (Map<String, Type>)ImmutableMap.of((Object)"wkt", (Object)VarcharType.VARCHAR, (Object)"point", (Object)GeometryType.GEOMETRY)), new EquiJoinClause[0])).matches(PlanMatchPattern.spatialLeftJoin("ST_Contains(st_geometryfromtext, point)", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression("ST_GeometryFromText(wkt)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"wkt", (Object)0))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"point", (Object)0))));
        this.assertRuleApplication().on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("wkt", (Type)VarcharType.VARCHAR)), (PlanNode)p.values(), this.sqlToRowExpression("ST_Contains(ST_GeometryFromText(wkt), ST_Point(0, 0))", (Map<String, Type>)ImmutableMap.of((Object)"wkt", (Object)VarcharType.VARCHAR)), new EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testPushDownSecondArgument() {
        this.assertRuleApplication().on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("polygon", (Type)GeometryType.GEOMETRY)), (PlanNode)p.values(p.variable("lat"), p.variable("lng")), this.sqlToRowExpression("ST_Contains(polygon, ST_Point(lng, lat))", (Map<String, Type>)ImmutableMap.of((Object)"polygon", (Object)GeometryType.GEOMETRY, (Object)"lat", (Object)BigintType.BIGINT, (Object)"lng", (Object)BigintType.BIGINT)), new EquiJoinClause[0])).matches(PlanMatchPattern.spatialLeftJoin("ST_Contains(polygon, st_point)", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"polygon", (Object)0)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression("ST_Point(lng, lat)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"lat", (Object)0, (Object)"lng", (Object)1)))));
        this.assertRuleApplication().on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(), (PlanNode)p.values(p.variable("lat"), p.variable("lng")), this.sqlToRowExpression("ST_Contains(ST_GeometryFromText('POLYGON ((0 0, 0 0, 0 0, 0 0))'), ST_Point(lng, lat))", (Map<String, Type>)ImmutableMap.of((Object)"polygon", (Object)GeometryType.GEOMETRY, (Object)"lat", (Object)BigintType.BIGINT, (Object)"lng", (Object)BigintType.BIGINT)), new EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testPushDownBothArguments() {
        this.assertRuleApplication().on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("wkt", (Type)VarcharType.VARCHAR)), (PlanNode)p.values(p.variable("lat"), p.variable("lng")), this.sqlToRowExpression("ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))", (Map<String, Type>)ImmutableMap.of((Object)"wkt", (Object)VarcharType.VARCHAR, (Object)"lat", (Object)BigintType.BIGINT, (Object)"lng", (Object)BigintType.BIGINT)), new EquiJoinClause[0])).matches(PlanMatchPattern.spatialLeftJoin("ST_Contains(st_geometryfromtext, st_point)", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression("ST_GeometryFromText(wkt)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"wkt", (Object)0))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression("ST_Point(lng, lat)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"lat", (Object)0, (Object)"lng", (Object)1)))));
    }

    @Test
    public void testPushDownOppositeOrder() {
        this.assertRuleApplication().on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("lat"), p.variable("lng")), (PlanNode)p.values(p.variable("wkt", (Type)VarcharType.VARCHAR)), this.sqlToRowExpression("ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))", (Map<String, Type>)ImmutableMap.of((Object)"wkt", (Object)VarcharType.VARCHAR, (Object)"lat", (Object)BigintType.BIGINT, (Object)"lng", (Object)BigintType.BIGINT)), new EquiJoinClause[0])).matches(PlanMatchPattern.spatialLeftJoin("ST_Contains(st_geometryfromtext, st_point)", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression("ST_Point(lng, lat)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"lat", (Object)0, (Object)"lng", (Object)1))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression("ST_GeometryFromText(wkt)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"wkt", (Object)0)))));
    }

    @Test
    public void testPushDownAnd() {
        this.assertRuleApplication().on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("wkt", (Type)VarcharType.VARCHAR), p.variable("name_1")), (PlanNode)p.values(p.variable("lat"), p.variable("lng"), p.variable("name_2")), this.sqlToRowExpression("name_1 != name_2 AND ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))", (Map<String, Type>)ImmutableMap.of((Object)"wkt", (Object)VarcharType.VARCHAR, (Object)"name_1", (Object)BigintType.BIGINT, (Object)"name_2", (Object)BigintType.BIGINT, (Object)"lat", (Object)BigintType.BIGINT, (Object)"lng", (Object)BigintType.BIGINT)), new EquiJoinClause[0])).matches(PlanMatchPattern.spatialLeftJoin("name_1 != name_2 AND ST_Contains(st_geometryfromtext, st_point)", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression("ST_GeometryFromText(wkt)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"wkt", (Object)0, (Object)"name_1", (Object)1))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression("ST_Point(lng, lat)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"lat", (Object)0, (Object)"lng", (Object)1, (Object)"name_2", (Object)2)))));
        this.assertRuleApplication().on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("wkt1", (Type)VarcharType.VARCHAR), p.variable("wkt2", (Type)VarcharType.VARCHAR)), (PlanNode)p.values(p.variable("geometry1", (Type)GeometryType.GEOMETRY), p.variable("geometry2", (Type)GeometryType.GEOMETRY)), this.sqlToRowExpression("ST_Contains(ST_GeometryFromText(wkt1), geometry1) AND ST_Contains(ST_GeometryFromText(wkt2), geometry2)", (Map<String, Type>)ImmutableMap.of((Object)"wkt1", (Object)VarcharType.VARCHAR, (Object)"wkt2", (Object)VarcharType.VARCHAR, (Object)"geometry1", (Object)GeometryType.GEOMETRY, (Object)"geometry2", (Object)GeometryType.GEOMETRY)), new EquiJoinClause[0])).matches(PlanMatchPattern.spatialLeftJoin("ST_Contains(st_geometryfromtext, geometry1) AND ST_Contains(ST_GeometryFromText(wkt2), geometry2)", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression("ST_GeometryFromText(wkt1)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"wkt1", (Object)0, (Object)"wkt2", (Object)1))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"geometry1", (Object)0, (Object)"geometry2", (Object)1))));
    }

    private RuleAssert assertRuleApplication() {
        RuleTester tester = this.tester();
        return this.tester().assertThat((Rule)new ExtractSpatialJoins.ExtractSpatialLeftJoin(tester.getMetadata(), tester.getSplitManager(), tester.getPageSourceManager()));
    }

    private RowExpression sqlToRowExpression(String sql, Map<String, Type> typeMap) {
        return this.sqlToRowExpressionTranslator.translateAndOptimize(PlanBuilder.expression(sql), TypeProvider.copyOf(typeMap));
    }
}

