/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.connector.MockConnectorFactory;
import com.facebook.presto.connector.informationSchema.InformationSchemaColumnHandle;
import com.facebook.presto.connector.informationSchema.InformationSchemaMetadata;
import com.facebook.presto.connector.informationSchema.InformationSchemaTableHandle;
import com.facebook.presto.connector.informationSchema.InformationSchemaTableLayoutHandle;
import com.facebook.presto.metadata.Catalog;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.analyzer.ViewDefinition;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.testing.TestingConnectorContext;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInformationSchemaMetadata {
    private static final JsonCodec<ViewDefinition> VIEW_DEFINITION_JSON_CODEC = JsonCodec.jsonCodec(ViewDefinition.class);
    private final TransactionManager transactionManager;
    private final Metadata metadata;

    public TestInformationSchemaMetadata() {
        MockConnectorFactory.Builder builder = MockConnectorFactory.builder();
        MockConnectorFactory mockConnectorFactory = builder.withListSchemaNames(connectorSession -> ImmutableList.of((Object)"test_schema")).withListTables((connectorSession, schemaNameOrNull) -> ImmutableList.of((Object)new SchemaTableName("test_schema", "test_view"), (Object)new SchemaTableName("test_schema", "another_table"))).withGetViews((connectorSession, prefix) -> {
            String viewJson = VIEW_DEFINITION_JSON_CODEC.toJson((Object)new ViewDefinition("select 1", Optional.of("test_catalog"), Optional.of("test_schema"), (List)ImmutableList.of(), Optional.empty(), false));
            SchemaTableName viewName = new SchemaTableName("test_schema", "test_view");
            return ImmutableMap.of((Object)viewName, (Object)new ConnectorViewDefinition(viewName, Optional.empty(), viewJson));
        }).build();
        Connector testConnector = mockConnectorFactory.create("test", (Map<String, String>)ImmutableMap.of(), (ConnectorContext)new TestingConnectorContext());
        CatalogManager catalogManager = new CatalogManager();
        String catalogName = "test_catalog";
        ConnectorId connectorId = new ConnectorId(catalogName);
        catalogManager.registerCatalog(new Catalog(catalogName, connectorId, testConnector, ConnectorId.createInformationSchemaConnectorId((ConnectorId)connectorId), testConnector, ConnectorId.createSystemTablesConnectorId((ConnectorId)connectorId), testConnector));
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.metadata = MetadataManager.createTestMetadataManager((TransactionManager)this.transactionManager, (FeaturesConfig)new FeaturesConfig());
    }

    @Test
    public void testInformationSchemaPredicatePushdown() {
        TransactionId transactionId = this.transactionManager.beginTransaction(false);
        ImmutableMap.Builder domains = new ImmutableMap.Builder();
        domains.put((Object)new InformationSchemaColumnHandle("table_schema"), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test_schema")));
        domains.put((Object)new InformationSchemaColumnHandle("table_name"), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test_view")));
        Constraint constraint = new Constraint(TupleDomain.withColumnDomains((Map)domains.build()));
        InformationSchemaMetadata informationSchemaMetadata = new InformationSchemaMetadata("test_catalog", this.metadata);
        ConnectorTableLayoutResult layoutResult = informationSchemaMetadata.getTableLayoutForConstraint(this.createNewSession(transactionId), (ConnectorTableHandle)new InformationSchemaTableHandle("test_catalog", "information_schema", "views"), constraint, Optional.empty());
        ConnectorTableLayoutHandle handle = layoutResult.getTableLayout().getHandle();
        Assert.assertTrue((boolean)(handle instanceof InformationSchemaTableLayoutHandle));
        InformationSchemaTableLayoutHandle tableHandle = (InformationSchemaTableLayoutHandle)handle;
        Assert.assertEquals((Set)tableHandle.getPrefixes(), (Set)ImmutableSet.of((Object)new QualifiedTablePrefix("test_catalog", "test_schema", "test_view")));
    }

    @Test
    public void testInformationSchemaPredicatePushdownWithConstraintPredicate() {
        TransactionId transactionId = this.transactionManager.beginTransaction(false);
        Constraint constraint = new Constraint(TupleDomain.all(), bindings -> {
            NullableValue catalog = (NullableValue)bindings.get(new InformationSchemaColumnHandle("table_catalog"));
            NullableValue schema = (NullableValue)bindings.get(new InformationSchemaColumnHandle("table_schema"));
            NullableValue table = (NullableValue)bindings.get(new InformationSchemaColumnHandle("table_name"));
            boolean isValid = true;
            if (catalog != null) {
                isValid = ((Slice)catalog.getValue()).toStringUtf8().equals("test_catalog");
            }
            if (schema != null) {
                isValid &= ((Slice)schema.getValue()).toStringUtf8().equals("test_schema");
            }
            if (table != null) {
                isValid &= ((Slice)table.getValue()).toStringUtf8().equals("test_view");
            }
            return isValid;
        });
        InformationSchemaMetadata informationSchemaMetadata = new InformationSchemaMetadata("test_catalog", this.metadata);
        ConnectorTableLayoutResult layoutResult = informationSchemaMetadata.getTableLayoutForConstraint(this.createNewSession(transactionId), (ConnectorTableHandle)new InformationSchemaTableHandle("test_catalog", "information_schema", "views"), constraint, Optional.empty());
        ConnectorTableLayoutHandle handle = layoutResult.getTableLayout().getHandle();
        Assert.assertTrue((boolean)(handle instanceof InformationSchemaTableLayoutHandle));
        InformationSchemaTableLayoutHandle tableHandle = (InformationSchemaTableLayoutHandle)handle;
        Assert.assertEquals((Set)tableHandle.getPrefixes(), (Set)ImmutableSet.of((Object)new QualifiedTablePrefix("test_catalog", "test_schema", "test_view")));
    }

    private ConnectorSession createNewSession(TransactionId transactionId) {
        return TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("information_schema").setTransactionId(transactionId).build().toConnectorSession();
    }
}

