/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.TestingMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.BigintGroupByHash;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.InMemoryGroupedTopNBuilder;
import com.facebook.presto.operator.NoChannelGroupByHash;
import com.facebook.presto.operator.PageWithPositionComparator;
import com.facebook.presto.operator.SimplePageWithPositionComparator;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.Work;
import com.google.common.collect.ImmutableList;
import io.airlift.tpch.LineItem;
import io.airlift.tpch.LineItemGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.CommandLineOptionException;
import org.openjdk.jmh.runner.options.CommandLineOptions;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=4)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkInMemoryGroupedTopNBuilder {
    private static final int HASH_GROUP = 0;
    private static final int EXTENDED_PRICE = 1;
    private static final int DISCOUNT = 2;
    private static final int SHIP_DATE = 3;
    private static final int QUANTITY = 4;

    @Benchmark
    public void topN(BenchmarkData data, Blackhole blackhole) {
        InMemoryGroupedTopNBuilder topNBuilder = data.getTopNBuilder();
        for (Page page : data.getPages()) {
            boolean finished;
            Work work = topNBuilder.processPage(page);
            while (!(finished = work.process())) {
            }
        }
        Iterator results = topNBuilder.buildResult().iterator();
        while (results.hasNext()) {
            blackhole.consume(results.next());
        }
    }

    public List<Page> topNToList(BenchmarkData data) {
        InMemoryGroupedTopNBuilder topNBuilder = data.getTopNBuilder();
        for (Page page : data.getPages()) {
            boolean finished;
            Work work = topNBuilder.processPage(page);
            while (!(finished = work.process())) {
            }
        }
        return ImmutableList.copyOf((Iterator)topNBuilder.buildResult().iterator());
    }

    @Test
    public void testTopNBenchmark() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        Assert.assertFalse((boolean)this.topNToList(data).isEmpty());
    }

    public static void main(String[] args) throws RunnerException, CommandLineOptionException {
        Options options = new OptionsBuilder().parent((Options)new CommandLineOptions(args)).include(".*" + BenchmarkInMemoryGroupedTopNBuilder.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    private static List<Page> createInputPages(int positions, List<Type> types, int positionsPerPage, int groupCount, int seed) {
        Random random = new Random(seed);
        ArrayList<Page> pages = new ArrayList<Page>();
        PageBuilder pageBuilder = new PageBuilder(types);
        LineItemGenerator lineItemGenerator = new LineItemGenerator(1.0, 1, 1);
        Iterator iterator = lineItemGenerator.iterator();
        for (int i = 0; i < positions; ++i) {
            pageBuilder.declarePosition();
            LineItem lineItem = (LineItem)iterator.next();
            BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(0), groupCount > 1 ? (long)random.nextInt(groupCount) : 1L);
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(1), lineItem.getExtendedPrice());
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(2), lineItem.getDiscount());
            DateType.DATE.writeLong(pageBuilder.getBlockBuilder(3), (long)lineItem.getShipDate());
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(4), (double)lineItem.getQuantity());
            if (pageBuilder.getPositionCount() < positionsPerPage) continue;
            pages.add(pageBuilder.build());
            pageBuilder.reset();
        }
        if (!pageBuilder.isEmpty()) {
            pages.add(pageBuilder.build());
        }
        return pages;
    }

    public static List<Page> createSequentialInputPages(int positions, List<Type> types, int positionsPerPage, int groupCount, int seed) {
        ArrayList<Page> pages = new ArrayList<Page>();
        PageBuilder pageBuilder = new PageBuilder(types);
        LineItemGenerator lineItemGenerator = new LineItemGenerator(1.0, 1, 1);
        Iterator iterator = lineItemGenerator.iterator();
        long mod = positions / groupCount;
        long groupNumber = 0L;
        for (int i = 0; i < positions; ++i) {
            pageBuilder.declarePosition();
            if ((long)i % mod == 0L) {
                ++groupNumber;
            }
            LineItem lineItem = (LineItem)iterator.next();
            BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(0), groupNumber);
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(1), (double)((long)i % mod) * 2.0);
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(2), lineItem.getDiscount());
            DateType.DATE.writeLong(pageBuilder.getBlockBuilder(3), (long)lineItem.getShipDate());
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(4), (double)lineItem.getQuantity());
            if (pageBuilder.getPositionCount() < positionsPerPage) continue;
            pages.add(pageBuilder.build());
            pageBuilder.reset();
        }
        if (!pageBuilder.isEmpty()) {
            pages.add(pageBuilder.build());
        }
        return pages;
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private final List<Type> types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE);
        private final PageWithPositionComparator comparator = new SimplePageWithPositionComparator(this.types, (List)ImmutableList.of((Object)1, (Object)3), (List)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST, (Object)SortOrder.ASC_NULLS_FIRST));
        private int seed = 42;
        @Param(value={"1", "100", "10000", "1000000"})
        private int topN = 1;
        @Param(value={"1", "100", "10000", "1000000"})
        private int positions = 1;
        @Param(value={"1000"})
        private int positionsPerPage = 1000;
        @Param(value={"1", "10", "1000"})
        private int groupCount = 10;
        private List<Page> page;
        private InMemoryGroupedTopNBuilder topNBuilder;

        @Setup
        public void setup() {
            this.page = BenchmarkInMemoryGroupedTopNBuilder.createInputPages(this.positions, this.types, this.positionsPerPage, this.groupCount, this.seed);
            Object groupByHash = this.groupCount > 1 ? new BigintGroupByHash(0, true, this.groupCount, UpdateMemory.NOOP) : new NoChannelGroupByHash();
            this.topNBuilder = new InMemoryGroupedTopNBuilder(this.types, this.comparator, this.topN, false, (LocalMemoryContext)new TestingMemoryContext(0L), (GroupByHash)groupByHash);
        }

        public InMemoryGroupedTopNBuilder getTopNBuilder() {
            return this.topNBuilder;
        }

        public List<Page> getPages() {
            return this.page;
        }
    }
}

