/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.Response;
import com.facebook.airlift.http.client.testing.TestingHttpClient;
import com.facebook.airlift.http.client.testing.TestingResponse;
import com.facebook.presto.common.Page;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.TestingPagesSerdeFactory;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.PagesSerdeUtil;
import com.facebook.presto.spi.page.SerializedPage;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceOutput;
import io.airlift.units.DataSize;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.testng.Assert;

public class MockExchangeRequestProcessor
implements TestingHttpClient.Processor {
    private static final String TASK_INSTANCE_ID = "task-instance-id";
    private final LoadingCache<URI, MockBuffer> buffers = CacheBuilder.newBuilder().build(CacheLoader.from(x$0 -> new MockBuffer((URI)x$0)));
    private final DataSize expectedMaxSize;
    private final PagesSerde pagesSerde;
    private final Function<byte[], byte[]> dataChanger;
    private final List<DataSize> requestMaxSizes = Collections.synchronizedList(new ArrayList());

    public MockExchangeRequestProcessor(DataSize expectedMaxSize) {
        this(expectedMaxSize, TestingPagesSerdeFactory.testingPagesSerde(), in -> in);
    }

    public MockExchangeRequestProcessor(DataSize expectedMaxSize, PagesSerde pagesSerde, Function<byte[], byte[]> dataChanger) {
        this.expectedMaxSize = expectedMaxSize;
        this.pagesSerde = pagesSerde;
        this.dataChanger = dataChanger;
    }

    public void addPage(URI location, Page page) {
        ((MockBuffer)this.buffers.getUnchecked((Object)location)).addPage(page, this.pagesSerde);
    }

    public void setComplete(URI location) {
        ((MockBuffer)this.buffers.getUnchecked((Object)location)).setCompleted();
    }

    public Response handle(Request request) {
        HttpStatus status;
        if (request.getMethod().equalsIgnoreCase("DELETE")) {
            return new TestingResponse(HttpStatus.NO_CONTENT, (ListMultimap)ImmutableListMultimap.of(), new byte[0]);
        }
        Assert.assertTrue((!request.getHeaders().get((Object)"X-Presto-Max-Size").isEmpty() ? 1 : 0) != 0);
        DataSize maxSize = DataSize.valueOf((String)request.getHeader("X-Presto-Max-Size"));
        Assert.assertTrue((maxSize.compareTo(this.expectedMaxSize) <= 0 ? 1 : 0) != 0);
        this.requestMaxSizes.add(maxSize);
        RequestLocation requestLocation = new RequestLocation(request.getUri());
        URI location = requestLocation.getLocation();
        BufferResult result = ((MockBuffer)this.buffers.getUnchecked((Object)location)).getPages(requestLocation.getSequenceId(), maxSize);
        byte[] bytes = new byte[]{};
        if (!result.getSerializedPages().isEmpty()) {
            DynamicSliceOutput sliceOutput = new DynamicSliceOutput(64);
            PagesSerdeUtil.writeSerializedPages((SliceOutput)sliceOutput, (Iterable)result.getSerializedPages());
            bytes = this.dataChanger.apply(sliceOutput.slice().getBytes());
            status = HttpStatus.OK;
        } else {
            status = HttpStatus.NO_CONTENT;
        }
        return new TestingResponse(status, (ListMultimap)ImmutableListMultimap.of((Object)"Content-Type", (Object)"application/X-presto-pages", (Object)"X-Presto-Task-Instance-Id", (Object)String.valueOf(result.getTaskInstanceId()), (Object)"X-Presto-Page-Sequence-Id", (Object)String.valueOf(result.getToken()), (Object)"X-Presto-Page-End-Sequence-Id", (Object)String.valueOf(result.getNextToken()), (Object)"X-Presto-Buffer-Complete", (Object)String.valueOf(result.isBufferComplete())), bytes);
    }

    public List<DataSize> getRequestMaxSizes() {
        return this.requestMaxSizes;
    }

    private static class MockBuffer {
        private final URI location;
        private final AtomicBoolean completed = new AtomicBoolean();
        private final AtomicLong token = new AtomicLong();
        private final BlockingQueue<SerializedPage> serializedPages = new LinkedBlockingQueue<SerializedPage>();

        private MockBuffer(URI location) {
            this.location = location;
        }

        public void setCompleted() {
            this.completed.set(true);
        }

        public synchronized void addPage(Page page, PagesSerde pagesSerde) {
            Preconditions.checkState((this.completed.get() != Boolean.TRUE.booleanValue() ? 1 : 0) != 0, (String)"Location %s is complete", (Object)this.location);
            this.serializedPages.add(pagesSerde.serialize(page));
        }

        public BufferResult getPages(long sequenceId, DataSize maxSize) {
            if (this.completed.get() && this.serializedPages.isEmpty()) {
                return BufferResult.emptyResults((String)MockExchangeRequestProcessor.TASK_INSTANCE_ID, (long)this.token.get(), (boolean)true);
            }
            Assert.assertEquals((long)sequenceId, (long)this.token.get(), (String)"token");
            SerializedPage serializedPage = null;
            try {
                serializedPage = this.serializedPages.poll(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (serializedPage == null) {
                return BufferResult.emptyResults((String)MockExchangeRequestProcessor.TASK_INSTANCE_ID, (long)this.token.get(), (boolean)false);
            }
            ArrayList<SerializedPage> responsePages = new ArrayList<SerializedPage>();
            responsePages.add(serializedPage);
            for (long responseSize = (long)serializedPage.getSizeInBytes(); responseSize < maxSize.toBytes() && (serializedPage = (SerializedPage)this.serializedPages.poll()) != null; responseSize += (long)serializedPage.getSizeInBytes()) {
                responsePages.add(serializedPage);
            }
            long nextToken = this.token.get() + (long)responsePages.size();
            BufferResult bufferResult = new BufferResult(MockExchangeRequestProcessor.TASK_INSTANCE_ID, this.token.get(), nextToken, false, 0L, responsePages);
            this.token.set(nextToken);
            return bufferResult;
        }
    }

    private class RequestLocation {
        private final URI location;
        private final long sequenceId;

        public RequestLocation(URI uri) {
            String string = uri.toString();
            int index = string.lastIndexOf(47);
            this.location = URI.create(string.substring(0, index));
            this.sequenceId = Long.parseLong(string.substring(index + 1));
        }

        public URI getLocation() {
            return this.location;
        }

        public long getSequenceId() {
            return this.sequenceId;
        }
    }
}

