/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.Assert;

public final class PageAssertions {
    private PageAssertions() {
    }

    public static void assertPageEquals(List<? extends Type> types, Page actualPage, Page expectedPage) {
        Assert.assertEquals((int)types.size(), (int)actualPage.getChannelCount());
        Assert.assertEquals((int)actualPage.getChannelCount(), (int)expectedPage.getChannelCount());
        Assert.assertEquals((int)actualPage.getPositionCount(), (int)expectedPage.getPositionCount());
        for (int i = 0; i < actualPage.getChannelCount(); ++i) {
            BlockAssertions.assertBlockEquals(types.get(i), actualPage.getBlock(i), expectedPage.getBlock(i));
        }
    }

    public static Page createPageWithRandomData(List<Type> types, int positionCount, float primitiveNullRate, float nestedNullRate) {
        return PageAssertions.createPageWithRandomData(types, positionCount, true, false, primitiveNullRate, nestedNullRate, false, (List<BlockAssertions.Encoding>)ImmutableList.of());
    }

    public static Page createDictionaryPageWithRandomData(List<Type> types, int positionCount, float primitiveNullRate, float nestedNullRate) {
        return PageAssertions.createPageWithRandomData(types, positionCount, true, false, primitiveNullRate, nestedNullRate, false, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY)));
    }

    public static Page createRlePageWithRandomData(List<Type> types, int positionCount, float primitiveNullRate, float nestedNullRate) {
        return PageAssertions.createPageWithRandomData(types, positionCount, true, false, primitiveNullRate, nestedNullRate, false, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH)));
    }

    public static Page createPageWithRandomData(List<Type> types, int positionCount, boolean addPreComputedHashBlock, boolean addNullBlock, float primitiveNullRate, float nestedNullRate, boolean useBlockView, List<BlockAssertions.Encoding> wrappings) {
        int channelCount = types.size();
        int preComputedChannelCount = addPreComputedHashBlock ? 1 : 0;
        int nullChannelCount = addNullBlock ? 1 : 0;
        Block[] blocks = new Block[channelCount + preComputedChannelCount + nullChannelCount];
        if (addPreComputedHashBlock) {
            blocks[0] = BlockAssertions.createRandomLongsBlock(positionCount, 0.0f);
        }
        for (int i = 0; i < channelCount; ++i) {
            blocks[i + preComputedChannelCount] = BlockAssertions.createRandomBlockForType(types.get(i), positionCount, primitiveNullRate, nestedNullRate, useBlockView, wrappings);
        }
        if (addNullBlock) {
            blocks[channelCount + preComputedChannelCount] = BlockAssertions.createAllNullsBlock((Type)BigintType.BIGINT, positionCount);
        }
        return new Page(positionCount, blocks);
    }

    public static Page mergePages(List<Type> types, List<Page> pages) {
        PageBuilder pageBuilder = new PageBuilder(types);
        int totalPositionCount = 0;
        for (Page page : pages) {
            Verify.verify((page.getChannelCount() == types.size() ? 1 : 0) != 0, (String)String.format("Number of channels in page %d is not equal to number of types %d", page.getChannelCount(), types.size()), (Object[])new Object[0]);
            for (int i = 0; i < types.size(); ++i) {
                BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
                Block block = page.getBlock(i);
                for (int position = 0; position < page.getPositionCount(); ++position) {
                    if (block.isNull(position)) {
                        blockBuilder.appendNull();
                        continue;
                    }
                    block.writePositionTo(position, blockBuilder);
                }
            }
            totalPositionCount += page.getPositionCount();
        }
        pageBuilder.declarePositions(totalPositionCount);
        return pageBuilder.build();
    }

    public static List<Type> updateBlockTypesWithHashBlockAndNullBlock(List<Type> types, boolean addPreComputedHashBlock, boolean addNullBlock) {
        ImmutableList.Builder newTypes = ImmutableList.builder();
        if (addPreComputedHashBlock) {
            newTypes.add((Object)BigintType.BIGINT);
        }
        newTypes.addAll(types);
        if (addNullBlock) {
            newTypes.add((Object)BigintType.BIGINT);
        }
        return newTypes.build();
    }
}

