/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.SequencePageBuilder;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestColumnarPageProcessor {
    private static final int POSITIONS = 100;
    private final List<Type> types = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR);
    private final MetadataManager metadata = MetadataManager.createTestMetadataManager();

    @Test
    public void testProcess() {
        PageProcessor processor = this.newPageProcessor();
        Page page = TestColumnarPageProcessor.createPage(this.types, false);
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        PageAssertions.assertPageEquals(this.types, outputPage, page);
    }

    @Test
    public void testProcessWithDictionary() {
        PageProcessor processor = this.newPageProcessor();
        Page page = TestColumnarPageProcessor.createPage(this.types, true);
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        PageAssertions.assertPageEquals(this.types, outputPage, page);
    }

    private static Page createPage(List<? extends Type> types, boolean dictionary) {
        return dictionary ? SequencePageBuilder.createSequencePageWithDictionaryBlocks(types, 100) : SequencePageBuilder.createSequencePage(types, 100);
    }

    private PageProcessor newPageProcessor() {
        return (PageProcessor)new ExpressionCompiler((Metadata)this.metadata, new PageFunctionCompiler((Metadata)this.metadata, 0)).compilePageProcessor(TestingConnectorSession.SESSION.getSqlFunctionProperties(), Optional.empty(), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)this.types.get(0)), (Object)Expressions.field((int)1, (Type)this.types.get(1))), false, 8192).get();
    }
}

