/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.airlift.http.client.HttpClientConfig;
import com.facebook.presto.operator.ExchangeClientConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestExchangeClientConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((ExchangeClientConfig)ConfigAssertions.recordDefaults(ExchangeClientConfig.class)).setMaxBufferSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).setConcurrentRequestMultiplier(3).setMinErrorDuration(new Duration(5.0, TimeUnit.MINUTES)).setMaxErrorDuration(new Duration(5.0, TimeUnit.MINUTES)).setAsyncPageTransportTimeout(new Duration(60.0, TimeUnit.SECONDS)).setMaxResponseSize(new HttpClientConfig().getMaxContentLength()).setPageBufferClientMaxCallbackThreads(25).setClientThreads(25).setAcknowledgePages(true).setResponseSizeExponentialMovingAverageDecayingAlpha(0.1));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"exchange.max-buffer-size", (Object)"1GB").put((Object)"exchange.concurrent-request-multiplier", (Object)"13").put((Object)"exchange.min-error-duration", (Object)"13s").put((Object)"exchange.max-error-duration", (Object)"33s").put((Object)"exchange.async-page-transport-timeout", (Object)"30s").put((Object)"exchange.max-response-size", (Object)"1MB").put((Object)"exchange.client-threads", (Object)"2").put((Object)"exchange.page-buffer-client.max-callback-threads", (Object)"16").put((Object)"exchange.acknowledge-pages", (Object)"false").put((Object)"exchange.response-size-exponential-moving-average-decaying-alpha", (Object)"0.42").build();
        ExchangeClientConfig expected = new ExchangeClientConfig().setMaxBufferSize(new DataSize(1.0, DataSize.Unit.GIGABYTE)).setConcurrentRequestMultiplier(13).setMinErrorDuration(new Duration(33.0, TimeUnit.SECONDS)).setMaxErrorDuration(new Duration(33.0, TimeUnit.SECONDS)).setAsyncPageTransportTimeout(new Duration(30.0, TimeUnit.SECONDS)).setMaxResponseSize(new DataSize(1.0, DataSize.Unit.MEGABYTE)).setClientThreads(2).setPageBufferClientMaxCallbackThreads(16).setAcknowledgePages(false).setResponseSizeExponentialMovingAverageDecayingAlpha(0.42);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

