/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.Test;

public abstract class AbstractTestDoubleRegrAggregationFunction
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        return new Block[]{BlockAssertions.createDoubleSequenceBlock(start, start + length), BlockAssertions.createDoubleSequenceBlock(start + 2, start + 2 + length)};
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"double", (Object)"double");
    }

    @Override
    @Test
    public void testSinglePosition() {
        this.testAggregation(this.getExpectedValue(0, 2), this.getSequenceBlocks(0, 2));
    }

    @Test
    public void testNonTrivialResult() {
        this.testNonTrivialAggregation(new Double[]{1.0, 2.0, 3.0, 4.0, 5.0}, new Double[]{1.0, 4.0, 9.0, 16.0, 25.0});
        this.testNonTrivialAggregation(new Double[]{1.0, 4.0, 9.0, 16.0, 25.0}, new Double[]{1.0, 2.0, 3.0, 4.0, 5.0});
    }

    protected abstract void testNonTrivialAggregation(Double[] var1, Double[] var2);
}

