/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestArbitraryAggregation {
    private static final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = metadata.getFunctionAndTypeManager();

    @Test
    public void testAllRegistered() {
        Set allTypes = (Set)metadata.getFunctionAndTypeManager().getTypes().stream().collect(ImmutableSet.toImmutableSet());
        for (Type valueType : allTypes) {
            Assert.assertNotNull((Object)this.getAggregation(valueType));
        }
    }

    @Test
    public void testNullBoolean() {
        JavaAggregationFunctionImplementation booleanAgg = this.getAggregation(new Type[]{BooleanType.BOOLEAN});
        AggregationTestUtils.assertAggregation(booleanAgg, null, BlockAssertions.createBooleansBlock(new Boolean[]{null}));
    }

    @Test
    public void testValidBoolean() {
        JavaAggregationFunctionImplementation booleanAgg = this.getAggregation(new Type[]{BooleanType.BOOLEAN});
        AggregationTestUtils.assertAggregation(booleanAgg, (Object)true, BlockAssertions.createBooleansBlock(true, true));
    }

    @Test
    public void testNullLong() {
        JavaAggregationFunctionImplementation longAgg = this.getAggregation(new Type[]{BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(longAgg, null, BlockAssertions.createLongsBlock(null, null));
    }

    @Test
    public void testValidLong() {
        JavaAggregationFunctionImplementation longAgg = this.getAggregation(new Type[]{BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(longAgg, (Object)1L, BlockAssertions.createLongsBlock(1L, null));
    }

    @Test
    public void testNullDouble() {
        JavaAggregationFunctionImplementation doubleAgg = this.getAggregation(new Type[]{DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(doubleAgg, null, BlockAssertions.createDoublesBlock(null, null));
    }

    @Test
    public void testValidDouble() {
        JavaAggregationFunctionImplementation doubleAgg = this.getAggregation(new Type[]{DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(doubleAgg, (Object)2.0, BlockAssertions.createDoublesBlock(null, 2.0));
    }

    @Test
    public void testNullString() {
        JavaAggregationFunctionImplementation stringAgg = this.getAggregation(new Type[]{VarcharType.VARCHAR});
        AggregationTestUtils.assertAggregation(stringAgg, null, BlockAssertions.createStringsBlock(null, null));
    }

    @Test
    public void testValidString() {
        JavaAggregationFunctionImplementation stringAgg = this.getAggregation(new Type[]{VarcharType.VARCHAR});
        AggregationTestUtils.assertAggregation(stringAgg, (Object)"a", BlockAssertions.createStringsBlock("a", "a"));
    }

    @Test
    public void testNullArray() {
        JavaAggregationFunctionImplementation arrayAgg = this.getAggregation(new Type[]{new ArrayType((Type)BigintType.BIGINT)});
        AggregationTestUtils.assertAggregation(arrayAgg, null, BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, null, null)));
    }

    @Test
    public void testValidArray() {
        JavaAggregationFunctionImplementation arrayAgg = this.getAggregation(new Type[]{new ArrayType((Type)BigintType.BIGINT)});
        AggregationTestUtils.assertAggregation(arrayAgg, (Object)ImmutableList.of((Object)23L, (Object)45L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)23L, (Object)45L), (Object)ImmutableList.of((Object)23L, (Object)45L), (Object)ImmutableList.of((Object)23L, (Object)45L), (Object)ImmutableList.of((Object)23L, (Object)45L))));
    }

    @Test
    public void testValidInt() {
        JavaAggregationFunctionImplementation intAgg = this.getAggregation(new Type[]{IntegerType.INTEGER});
        AggregationTestUtils.assertAggregation(intAgg, (Object)3, BlockAssertions.createIntsBlock(3, 3, null));
    }

    protected JavaAggregationFunctionImplementation getAggregation(Type ... arguments) {
        return FUNCTION_AND_TYPE_MANAGER.getJavaAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction("arbitrary", TypeSignatureProvider.fromTypes((Type[])arguments)));
    }
}

