/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.block.MapBlock;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestChecksumAggregation {
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();

    @Test
    public void testEmpty() {
        JavaAggregationFunctionImplementation booleanAgg = this.getAggregation((Type)BooleanType.BOOLEAN);
        AggregationTestUtils.assertAggregation(booleanAgg, null, BlockAssertions.createBooleansBlock(new Boolean[0]));
    }

    @Test
    public void testBoolean() {
        JavaAggregationFunctionImplementation booleanAgg = this.getAggregation((Type)BooleanType.BOOLEAN);
        Block block = BlockAssertions.createBooleansBlock(null, null, true, false, false);
        AggregationTestUtils.assertAggregation(booleanAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)BooleanType.BOOLEAN, block), block);
    }

    @Test
    public void testLong() {
        JavaAggregationFunctionImplementation longAgg = this.getAggregation((Type)BigintType.BIGINT);
        Block block = BlockAssertions.createLongsBlock(null, 1L, 2L, 100L, null, Long.MAX_VALUE, Long.MIN_VALUE);
        AggregationTestUtils.assertAggregation(longAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)BigintType.BIGINT, block), block);
    }

    @Test
    public void testDouble() {
        JavaAggregationFunctionImplementation doubleAgg = this.getAggregation((Type)DoubleType.DOUBLE);
        Block block = BlockAssertions.createDoublesBlock(null, 2.0, null, 3.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NaN);
        AggregationTestUtils.assertAggregation(doubleAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)DoubleType.DOUBLE, block), block);
    }

    @Test
    public void testString() {
        JavaAggregationFunctionImplementation stringAgg = this.getAggregation((Type)VarcharType.VARCHAR);
        Block block = BlockAssertions.createStringsBlock("a", "a", null, "b", "c");
        AggregationTestUtils.assertAggregation(stringAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)VarcharType.VARCHAR, block), block);
    }

    @Test
    public void testShortDecimal() {
        JavaAggregationFunctionImplementation decimalAgg = this.getAggregation((Type)DecimalType.createDecimalType((int)10, (int)2));
        Block block = BlockAssertions.createShortDecimalsBlock("11.11", "22.22", null, "33.33", "44.44");
        DecimalType shortDecimalType = DecimalType.createDecimalType((int)1);
        AggregationTestUtils.assertAggregation(decimalAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)shortDecimalType, block), block);
    }

    @Test
    public void testLongDecimal() {
        JavaAggregationFunctionImplementation decimalAgg = this.getAggregation((Type)DecimalType.createDecimalType((int)19, (int)2));
        Block block = BlockAssertions.createLongDecimalsBlock("11.11", "22.22", null, "33.33", "44.44");
        DecimalType longDecimalType = DecimalType.createDecimalType((int)19);
        AggregationTestUtils.assertAggregation(decimalAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)longDecimalType, block), block);
    }

    @Test
    public void testArray() {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        JavaAggregationFunctionImplementation stringAgg = this.getAggregation((Type)arrayType);
        Block block = BlockAssertions.createArrayBigintBlock(Arrays.asList(null, Arrays.asList(1L, 2L), Arrays.asList(3L, 4L), Arrays.asList(5L, 6L)));
        AggregationTestUtils.assertAggregation(stringAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)arrayType, block), block);
    }

    @Test
    public void testMap() {
        MapType mapType = BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE);
        JavaAggregationFunctionImplementation mapAgg = this.getAggregation((Type)mapType);
        ImmutableMap map = ImmutableMap.of((Object)1L, (Object)23.45, (Object)2L, (Object)345.678, (Object)3L, (Object)4567.8901);
        Block block = BlockAssertions.createMapBlock(mapType, map);
        AggregationTestUtils.assertAggregation(mapAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)mapType, block), block);
        long[] keys = new long[]{25895L, 111936L, 162115L, 304417L, 3069541L, 3159396L, 3500641L, 5097671L, 5197414L, 5404804L};
        LongArrayBlock keyBlock = new LongArrayBlock(10, Optional.empty(), keys);
        BlockBuilder builder = DoubleType.DOUBLE.createBlockBuilder(null, 10);
        double[] values = new double[]{149912.63, 264526.94, 90483.15, 150554.2, 195291.64, 328452.73, 10938.72, 12740.73, 31276.6, 119651.44};
        for (int i = 0; i < values.length; ++i) {
            DoubleType.DOUBLE.writeDouble(builder, values[i]);
        }
        Block valueBlock = builder.build();
        int[] offsets = new int[]{0, 2, 6, 10};
        MapBlock multiMapBlock = MapBlock.fromKeyValueBlock((int)3, Optional.ofNullable(null), (int[])offsets, (Block)keyBlock, (Block)valueBlock);
        AggregationTestUtils.assertAggregation(mapAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)mapType, (Block)multiMapBlock), new Block[]{multiMapBlock});
    }

    private static SqlVarbinary expectedChecksum(Type type, Block block) {
        long result = 0L;
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) {
                result += -7046029288634856825L;
                continue;
            }
            result += type.hash(block, i) * -7046029288634856825L;
        }
        return new SqlVarbinary(Slices.wrappedLongArray((long[])new long[]{result}).getBytes());
    }

    private JavaAggregationFunctionImplementation getAggregation(Type argument) {
        return FUNCTION_AND_TYPE_MANAGER.getJavaAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction("checksum", TypeSignatureProvider.fromTypes((Type[])new Type[]{argument})));
    }
}

