/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactory;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDoubleHistogramAggregation {
    private final AccumulatorFactory factory;
    private final Page input;

    public TestDoubleHistogramAggregation() {
        FunctionAndTypeManager functionAndTypeManager = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
        JavaAggregationFunctionImplementation function = functionAndTypeManager.getJavaAggregateFunctionImplementation(functionAndTypeManager.lookupFunction("numeric_histogram", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, DoubleType.DOUBLE, DoubleType.DOUBLE})));
        this.factory = GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)function, (List)ImmutableList.of((Object)0, (Object)1, (Object)2), Optional.empty());
        this.input = TestDoubleHistogramAggregation.makeInput(10);
    }

    @Test
    public void test() {
        Accumulator singleStep = this.factory.createAccumulator(UpdateMemory.NOOP);
        singleStep.addInput(this.input);
        Block expected = AggregationTestUtils.getFinalBlock(singleStep);
        Accumulator partialStep = this.factory.createAccumulator(UpdateMemory.NOOP);
        partialStep.addInput(this.input);
        Block partialBlock = AggregationTestUtils.getIntermediateBlock(partialStep);
        Accumulator finalStep = this.factory.createAccumulator(UpdateMemory.NOOP);
        finalStep.addIntermediate(partialBlock);
        Block actual = AggregationTestUtils.getFinalBlock(finalStep);
        Assert.assertEquals(TestDoubleHistogramAggregation.extractSingleValue(actual), TestDoubleHistogramAggregation.extractSingleValue(expected));
    }

    @Test
    public void testMerge() {
        Accumulator singleStep = this.factory.createAccumulator(UpdateMemory.NOOP);
        singleStep.addInput(this.input);
        Block singleStepResult = AggregationTestUtils.getFinalBlock(singleStep);
        Accumulator partialStep = this.factory.createAccumulator(UpdateMemory.NOOP);
        partialStep.addInput(this.input);
        Block intermediate = AggregationTestUtils.getIntermediateBlock(partialStep);
        Accumulator finalStep = this.factory.createAccumulator(UpdateMemory.NOOP);
        finalStep.addIntermediate(intermediate);
        finalStep.addIntermediate(intermediate);
        Block actual = AggregationTestUtils.getFinalBlock(finalStep);
        Map expected = Maps.transformValues(TestDoubleHistogramAggregation.extractSingleValue(singleStepResult), value -> value * 2.0);
        Assert.assertEquals(TestDoubleHistogramAggregation.extractSingleValue(actual), (Map)expected);
    }

    @Test
    public void testNull() {
        Accumulator accumulator = this.factory.createAccumulator(UpdateMemory.NOOP);
        Block result = AggregationTestUtils.getFinalBlock(accumulator);
        Assert.assertTrue((result.getPositionCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.isNull(0));
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testBadNumberOfBuckets() {
        Accumulator singleStep = this.factory.createAccumulator(UpdateMemory.NOOP);
        singleStep.addInput(TestDoubleHistogramAggregation.makeInput(0));
        AggregationTestUtils.getFinalBlock(singleStep);
    }

    private static Map<Double, Double> extractSingleValue(Block block) {
        MapType mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE);
        return (Map)mapType.getObjectValue(null, block, 0);
    }

    private static Page makeInput(int numberOfBuckets) {
        PageBuilder builder = new PageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
        for (int i = 0; i < 100; ++i) {
            builder.declarePosition();
            BigintType.BIGINT.writeLong(builder.getBlockBuilder(0), (long)numberOfBuckets);
            DoubleType.DOUBLE.writeDouble(builder.getBlockBuilder(1), (double)i);
            DoubleType.DOUBLE.writeDouble(builder.getBlockBuilder(2), 1.0);
        }
        return builder.build();
    }
}

