/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.testng.annotations.Test;

public class TestDoubleRegrSlopeAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        return new Block[]{BlockAssertions.createDoubleSequenceBlock(start, start + length), BlockAssertions.createDoubleSequenceBlock(start + 2, start + 2 + length)};
    }

    @Override
    protected String getFunctionName() {
        return "regr_slope";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"double", (Object)"double");
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length <= 1) {
            return null;
        }
        SimpleRegression regression = new SimpleRegression();
        for (int i = start; i < start + length; ++i) {
            regression.addData((double)(i + 2), (double)i);
        }
        return regression.getSlope();
    }

    @Test
    public void testNonTrivialResult() {
        this.testNonTrivialAggregation(new Double[]{1.0, 2.0, 3.0, 4.0, 5.0}, new Double[]{1.0, 4.0, 9.0, 16.0, 25.0});
        this.testNonTrivialAggregation(new Double[]{1.0, 4.0, 9.0, 16.0, 25.0}, new Double[]{1.0, 2.0, 3.0, 4.0, 5.0});
    }

    private void testNonTrivialAggregation(Double[] y, Double[] x) {
        SimpleRegression regression = new SimpleRegression();
        for (int i = 0; i < x.length; ++i) {
            regression.addData(x[i].doubleValue(), y[i].doubleValue());
        }
        double expected = regression.getSlope();
        Preconditions.checkArgument((Double.isFinite(expected) && expected != 0.0 ? 1 : 0) != 0, (Object)"Expected result is trivial");
        this.testAggregation(expected, BlockAssertions.createDoublesBlock(y), BlockAssertions.createDoublesBlock(x));
    }
}

