/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.type.IntervalYearMonthType;
import com.facebook.presto.type.SqlIntervalYearMonth;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class TestIntervalYearToMonthAverageAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = IntervalYearMonthType.INTERVAL_YEAR_MONTH.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            IntervalYearMonthType.INTERVAL_YEAR_MONTH.writeLong(blockBuilder, (long)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    public SqlIntervalYearMonth getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        double sum = 0.0;
        for (int i = start; i < start + length; ++i) {
            sum += (double)i;
        }
        return new SqlIntervalYearMonth(Math.toIntExact(Math.round(sum / (double)length)));
    }

    @Override
    protected String getFunctionName() {
        return "avg";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"interval year to month");
    }
}

