/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.apache.datasketches.common.ArrayOfBooleansSerDe;
import org.apache.datasketches.common.ArrayOfDoublesSerDe;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.kll.KllItemsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestKllSketchAggregationFunction
extends AbstractTestFunctions {
    private static final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = metadata.getFunctionAndTypeManager();
    private static final JavaAggregationFunctionImplementation DOUBLE_FUNCTION = TestKllSketchAggregationFunction.getFunction(new Type[]{DoubleType.DOUBLE});
    private static final JavaAggregationFunctionImplementation DOUBLE_WITH_K_FUNCTION = TestKllSketchAggregationFunction.getFunction("sketch_kll_with_k", new Type[]{DoubleType.DOUBLE, BigintType.BIGINT});
    private static final JavaAggregationFunctionImplementation BIGINT_FUNCTION = TestKllSketchAggregationFunction.getFunction(new Type[]{BigintType.BIGINT});
    private static final JavaAggregationFunctionImplementation VARCHAR_FUNCTION = TestKllSketchAggregationFunction.getFunction(new Type[]{VarcharType.VARCHAR});
    private static final JavaAggregationFunctionImplementation BOOLEAN_FUNCTION = TestKllSketchAggregationFunction.getFunction(new Type[]{BooleanType.BOOLEAN});

    @Test
    public void testDouble() {
        double[] items = DoubleStream.iterate(0.0, i -> i + ThreadLocalRandom.current().nextDouble()).limit(100L).toArray();
        BlockBuilder out = DoubleType.DOUBLE.createBlockBuilder(null, items.length);
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Double::compareTo, (ArrayOfItemsSerDe)new ArrayOfDoublesSerDe());
        Arrays.stream(items).forEach(item -> {
            DoubleType.DOUBLE.writeDouble(out, item);
            sketch.update((Object)item);
        });
        Block input = out.build();
        SqlVarbinary result = (SqlVarbinary)AggregationTestUtils.executeAggregation(DOUBLE_FUNCTION, input);
        KllItemsSketch recreated = KllItemsSketch.wrap((Memory)WritableMemory.writableWrap((byte[])result.getBytes()), Double::compareTo, (ArrayOfItemsSerDe)new ArrayOfDoublesSerDe());
        TestKllSketchAggregationFunction.checkSketchesEqual(DoubleStream.of(items).boxed().toArray(Double[]::new), sketch, recreated);
    }

    @Test
    public void testDoubleWithK() {
        double[] items = DoubleStream.iterate(0.0, i -> i + ThreadLocalRandom.current().nextDouble()).limit(100L).toArray();
        BlockBuilder out = DoubleType.DOUBLE.createBlockBuilder(null, items.length);
        BlockBuilder kBlock = BigintType.BIGINT.createBlockBuilder(null, items.length);
        int k = 150;
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance((int)k, Double::compareTo, (ArrayOfItemsSerDe)new ArrayOfDoublesSerDe());
        Arrays.stream(items).forEach(item -> {
            DoubleType.DOUBLE.writeDouble(out, item);
            sketch.update((Object)item);
            BigintType.BIGINT.writeLong(kBlock, (long)k);
        });
        Block input = out.build();
        SqlVarbinary result = (SqlVarbinary)AggregationTestUtils.executeAggregation(DOUBLE_WITH_K_FUNCTION, input, kBlock.build());
        KllItemsSketch recreated = KllItemsSketch.wrap((Memory)WritableMemory.writableWrap((byte[])result.getBytes()), Double::compareTo, (ArrayOfItemsSerDe)new ArrayOfDoublesSerDe());
        TestKllSketchAggregationFunction.checkSketchesEqual(DoubleStream.of(items).boxed().toArray(Double[]::new), sketch, recreated);
    }

    @Test
    public void testInvalidK() {
        double[] items = DoubleStream.iterate(0.0, i -> i + ThreadLocalRandom.current().nextDouble()).limit(10L).toArray();
        BlockBuilder inputBlock = DoubleType.DOUBLE.createBlockBuilder(null, items.length);
        BlockBuilder kBlockLow = BigintType.BIGINT.createBlockBuilder(null, items.length);
        Arrays.stream(items).forEach(item -> {
            DoubleType.DOUBLE.writeDouble(inputBlock, item);
            BigintType.BIGINT.writeLong(kBlockLow, 7L);
        });
        Block input = inputBlock.build();
        TestKllSketchAggregationFunction.assertThrows(() -> AggregationTestUtils.executeAggregation(DOUBLE_WITH_K_FUNCTION, inputBlock.build(), kBlockLow.build()), PrestoException.class, "k value must satisfy 8 <= k <= 65535: 7");
        BlockBuilder kBlockHigh = BigintType.BIGINT.createBlockBuilder(null, items.length);
        Arrays.stream(items).forEach(item -> BigintType.BIGINT.writeLong(kBlockHigh, 65536L));
        TestKllSketchAggregationFunction.assertThrows(() -> AggregationTestUtils.executeAggregation(DOUBLE_WITH_K_FUNCTION, input, kBlockHigh.build()), PrestoException.class, "k value must satisfy 8 <= k <= 65535: 65536");
    }

    @Test
    public void testBigint() {
        Long[] items = (Long[])LongStream.iterate(0L, i -> i + ThreadLocalRandom.current().nextLong(0L, 100L)).limit(100L).boxed().toArray(Long[]::new);
        BlockBuilder out = BigintType.BIGINT.createBlockBuilder(null, items.length);
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Long::compareTo, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        Arrays.stream(items).forEach(item -> {
            BigintType.BIGINT.writeLong(out, item.longValue());
            sketch.update(item);
        });
        Block input = out.build();
        SqlVarbinary result = (SqlVarbinary)AggregationTestUtils.executeAggregation(BIGINT_FUNCTION, input);
        KllItemsSketch recreated = KllItemsSketch.wrap((Memory)WritableMemory.writableWrap((byte[])result.getBytes()), Long::compareTo, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        TestKllSketchAggregationFunction.checkSketchesEqual(items, sketch, recreated);
    }

    @Test
    public void testVarchar() {
        String[] items = "abcdefghijklmnopqrstuvwxyz".split("");
        BlockBuilder out = VarcharType.VARCHAR.createBlockBuilder(null, items.length);
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(String::compareTo, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Arrays.stream(items).forEach(item -> {
            VarcharType.VARCHAR.writeString(out, item);
            sketch.update(item);
        });
        Block input = out.build();
        SqlVarbinary result = (SqlVarbinary)AggregationTestUtils.executeAggregation(VARCHAR_FUNCTION, input);
        KllItemsSketch recreated = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])result.getBytes()), String::compareTo, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        TestKllSketchAggregationFunction.checkSketchesEqual(items, sketch, recreated);
    }

    @Test
    public void testBoolean() {
        Boolean[] items = (Boolean[])IntStream.iterate(0, i -> i + 1).limit(10L).mapToObj(i -> i % 2 == 0).toArray(Boolean[]::new);
        BlockBuilder out = BooleanType.BOOLEAN.createBlockBuilder(null, items.length);
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Boolean::compareTo, (ArrayOfItemsSerDe)new ArrayOfBooleansSerDe());
        Arrays.stream(items).forEach(item -> {
            sketch.update(item);
            BooleanType.BOOLEAN.writeBoolean(out, item.booleanValue());
        });
        Block input = out.build();
        SqlVarbinary result = (SqlVarbinary)AggregationTestUtils.executeAggregation(BOOLEAN_FUNCTION, input);
        KllItemsSketch recreated = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])result.getBytes()), Boolean::compareTo, (ArrayOfItemsSerDe)new ArrayOfBooleansSerDe());
        TestKllSketchAggregationFunction.checkSketchesEqual(items, sketch, recreated);
    }

    @Test
    public void testEmptyInput() {
        AggregationTestUtils.assertAggregation(DOUBLE_FUNCTION, null, DoubleType.DOUBLE.createBlockBuilder(null, 0).build());
    }

    private static void assertThrows(Assert.ThrowingRunnable runnable, Class<?> exceptionType, @Language(value="regexp") String regex) {
        try {
            runnable.run();
            throw new AssertionError((Object)"no exception was thrown");
        }
        catch (Throwable e) {
            Assert.assertEquals(e.getClass(), exceptionType);
            Assert.assertTrue((boolean)Optional.ofNullable(e.getMessage()).orElse("").matches(regex), (String)String.format("Error message: '%s' didn't match regex: '%s'", e.getMessage(), regex));
            return;
        }
    }

    private static <T> void checkSketchesEqual(T[] items, KllItemsSketch<T> expected, KllItemsSketch<T> actual) {
        Arrays.stream(items).forEach(item -> Assert.assertEquals((double)actual.getRank(item), (double)expected.getRank(item), (double)1.0E-8));
        Assert.assertEquals((long[])actual.getSortedView().getCumulativeWeights(), (long[])expected.getSortedView().getCumulativeWeights(), (String)"weights are not equal");
        Assert.assertEquals((Object[])actual.getSortedView().getQuantiles(), (Object[])expected.getSortedView().getQuantiles(), (String)"quantiles are not equal");
    }

    private static JavaAggregationFunctionImplementation getFunction(Type ... types) {
        return TestKllSketchAggregationFunction.getFunction("sketch_kll", types);
    }

    private static JavaAggregationFunctionImplementation getFunction(String name, Type ... types) {
        return FUNCTION_AND_TYPE_MANAGER.getJavaAggregateFunctionImplementation(metadata.getFunctionAndTypeManager().lookupFunction(name, TypeSignatureProvider.fromTypes((Type[])types)));
    }
}

