/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.differentialentropy.AbstractTestReservoirAggregation;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.Test;

public class TestUnweightedReservoirAggregation
extends AbstractTestReservoirAggregation {
    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="In differential_entropy UDF, max samples must be positive: -200")
    public void testInvalidMaxSamples() {
        AggregationTestUtils.aggregation(this.getFunction(), BlockAssertions.createLongsBlock(-200), BlockAssertions.createDoublesBlock(0.1));
    }

    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        int positionCount = 2 * length;
        BlockBuilder samples = DoubleType.DOUBLE.createBlockBuilder(null, positionCount);
        for (int weight = 1; weight < 3; ++weight) {
            for (int i = start; i < start + length; ++i) {
                DoubleType.DOUBLE.writeDouble(samples, (double)i);
            }
        }
        return new Block[]{BlockAssertions.createRLEBlock(500L, positionCount), samples.build()};
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"integer", (Object)"double");
    }
}

