/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.facebook.presto.operator.aggregation.differentialentropy.WeightedDoubleReservoirSample;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestWeightedDoubleReservoirSample {
    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Maximum number of samples must be positive: 0")
    public void testIllegalMaxSamples() {
        new WeightedDoubleReservoirSample(0);
    }

    @Test
    public void testGetters() {
        WeightedDoubleReservoirSample reservoir = new WeightedDoubleReservoirSample(200);
        Assert.assertEquals((long)reservoir.getMaxSamples(), (long)200L);
        Assert.assertEquals((double)reservoir.getTotalPopulationWeight(), (double)0.0);
    }

    @Test
    public void testFew() {
        WeightedDoubleReservoirSample reservoir = new WeightedDoubleReservoirSample(200);
        reservoir.add(1.0, 1.0);
        reservoir.add(2.0, 1.0);
        reservoir.add(3.0, 0.5);
        Assert.assertEquals((double[])Arrays.stream(reservoir.getSamples()).sorted().toArray(), (double[])new double[]{1.0, 2.0, 3.0});
        Assert.assertEquals((double)reservoir.getTotalPopulationWeight(), (double)2.5);
    }

    @Test
    public void testMany() {
        WeightedDoubleReservoirSample reservoir = new WeightedDoubleReservoirSample(200);
        long streamLength = 1000000L;
        int i = 0;
        while ((long)i < streamLength) {
            Assert.assertEquals((double)reservoir.getTotalPopulationWeight(), (double)i, (double)1.0E-4);
            reservoir.add((double)i, 1.0);
            ++i;
        }
        double[] quantized = new double[4];
        int count = 0;
        for (double sample : reservoir.getSamples()) {
            int index;
            ++count;
            int n = index = (int)(4.0 * sample / (double)(streamLength + 1L));
            quantized[n] = quantized[n] + 1.0;
        }
        Assert.assertEquals((int)count, (int)200, (String)String.format("Number of samples should be full: got=%s, expected=%s", count, 200));
        int expectedMin = 25;
        for (int i2 = 0; i2 < 4; ++i2) {
            Assert.assertTrue((quantized[i2] > (double)expectedMin ? 1 : 0) != 0, (String)String.format("Expected quantized[i] > got: i=%s, quantized=%s, got=%s", i2, quantized[i2], 35));
        }
    }

    @Test
    public void testManyWeighted() {
        WeightedDoubleReservoirSample reservoir = new WeightedDoubleReservoirSample(200);
        long streamLength = 1000000L;
        double epsilon = 1.0E-8;
        int i = 0;
        while ((long)i < streamLength) {
            Assert.assertEquals((double)reservoir.getTotalPopulationWeight(), (double)(epsilon * (double)i), (double)(epsilon / 100.0));
            reservoir.add(3.0, epsilon);
            ++i;
        }
        i = 0;
        while ((long)i < streamLength) {
            reservoir.add((double)i, 9.999999999E9);
            ++i;
        }
        double[] quantized = new double[4];
        int count = 0;
        for (double sample : reservoir.getSamples()) {
            int index;
            ++count;
            int n = index = (int)(4.0 * sample / (double)(streamLength + 1L));
            quantized[n] = quantized[n] + 1.0;
        }
        Assert.assertEquals((int)count, (int)200, (String)String.format("Number of samples should be full: got=%s, expected=%s", count, 200));
        int expectedMin = 25;
        for (int i2 = 0; i2 < 4; ++i2) {
            Assert.assertTrue((quantized[i2] > (double)expectedMin ? 1 : 0) != 0, (String)String.format("Expected quantized[i] > got: i=%s, quantized=%s, got=%s", i2, quantized[i2], expectedMin));
        }
    }
}

