/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class TestNoisyAggregationUtils {
    public static final BiFunction<Object, Object, Boolean> notEqualDoubleAssertion = (actual, expected) -> !new Double(actual.toString()).equals(new Double(expected.toString()));
    public static final BiFunction<Object, Object, Boolean> equalDoubleAssertion = (actual, expected) -> Math.abs(new Double(actual.toString()) - new Double(expected.toString())) <= 1.0E-12;
    public static final BiFunction<Object, Object, Boolean> equalLongAssertion = (actual, expected) -> new Long(actual.toString()).equals(new Long(expected.toString()));
    public static final double DEFAULT_TEST_STANDARD_DEVIATION = 1.0;
    public static final BiFunction<Object, Object, Boolean> withinSomeStdAssertion = (actual, expected) -> {
        double actualValue = new Double(actual.toString());
        double expectedValue = new Double(expected.toString());
        return expectedValue - 50.0 <= actualValue && actualValue <= expectedValue + 50.0;
    };

    private TestNoisyAggregationUtils() {
    }

    public static <T> List<T> createTestValues(int numRows, boolean includeNull, T value, boolean fixedValue) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < numRows; ++i) {
            if (fixedValue) {
                values.add(value);
                continue;
            }
            if (value instanceof Double) {
                values.add(Double.valueOf(i));
                continue;
            }
            if (value instanceof Integer) {
                values.add(i);
                continue;
            }
            if (value instanceof Long) {
                values.add(Long.valueOf(i));
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            values.add(i % 2 == 0);
        }
        if (includeNull) {
            values.remove(0);
            values.add(null);
        }
        return values;
    }

    public static String buildData(int numRows, boolean includeNullValue, List<String> types) {
        int i;
        int finalNumRows = numRows;
        if (includeNullValue) {
            finalNumRows = numRows - 1;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(SELECT ");
        sb.append("CAST(index AS bigint) AS index, ");
        for (i = 0; i < types.size(); ++i) {
            String type = types.get(i);
            String typeString = type.equals("decimal") ? "DECIMAL(38)" : type;
            String column = TestNoisyAggregationUtils.buildColumnName(type);
            sb.append("CAST(").append(column).append(" AS ").append(typeString).append(") AS ").append(column);
            if (i < types.size() - 1) {
                sb.append(",");
            }
            sb.append(" ");
        }
        sb.append("FROM (VALUES ");
        for (i = 0; i < finalNumRows; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            TestNoisyAggregationUtils.buildRow(sb, i, types, false);
        }
        if (includeNullValue) {
            sb.append(",");
            TestNoisyAggregationUtils.buildRow(sb, finalNumRows, types, true);
        }
        sb.append(") AS t (").append("index");
        for (String type : types) {
            sb.append(", ").append(TestNoisyAggregationUtils.buildColumnName(type));
        }
        sb.append("))");
        return sb.toString();
    }

    public static String buildColumnName(String type) {
        return "col_" + type;
    }

    public static void buildRow(StringBuilder sb, int index, List<String> types, boolean isNullRow) {
        sb.append("(").append(isNullRow ? "NULL" : Integer.valueOf(index));
        for (String type : types) {
            sb.append(", ");
            if (isNullRow) {
                sb.append("NULL");
                continue;
            }
            switch (type) {
                case "tinyint": 
                case "smallint": 
                case "integer": 
                case "bigint": {
                    sb.append(index);
                    break;
                }
                case "real": 
                case "double": 
                case "decimal": {
                    sb.append(index).append(".0");
                    break;
                }
                case "varchar": 
                case "char": 
                case "varbinary": 
                case "json": {
                    sb.append("'{}'");
                    break;
                }
                case "boolean": {
                    sb.append(index % 2 == 0 ? "true" : "false");
                }
            }
        }
        sb.append(")");
    }

    public static double sum(List<Double> values) {
        return values.stream().mapToDouble(f -> f == null ? 0.0 : f).sum();
    }

    public static double sumLong(List<Long> values) {
        return values.stream().mapToLong(v -> v == null ? 0L : v).sum();
    }

    public static double countTrue(List<Boolean> values) {
        return values.stream().mapToLong(v -> v == null || v == false ? 0L : 1L).sum();
    }

    public static double avg(List<Double> values) {
        return TestNoisyAggregationUtils.sum(values) / TestNoisyAggregationUtils.countNonNull(values);
    }

    public static double avgLong(List<Long> values) {
        return TestNoisyAggregationUtils.sumLong(values) / (double)TestNoisyAggregationUtils.countNonNullLong(values);
    }

    public static double countNonNull(List<Double> values) {
        return values.stream().mapToLong(f -> f == null ? 0L : 1L).sum();
    }

    public static long countNonNullLong(List<Long> values) {
        return values.stream().mapToLong(v -> v == null ? 0L : 1L).sum();
    }

    public static List<String> toNullableStringList(List<Long> values) {
        return values.stream().map(v -> v == null ? null : String.valueOf(v)).collect(Collectors.toList());
    }
}

