/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.aggregation.noisyaggregation.AbstractTestNoisySfmAggregation;
import org.testng.annotations.Test;

public class TestNoisyApproximateCountDistinctSfmAggregation
extends AbstractTestNoisySfmAggregation {
    @Override
    protected String getFunctionName() {
        return "noisy_approx_distinct_sfm";
    }

    @Override
    protected long getCardinalityFromResult(Object result) {
        return new Long(result.toString());
    }

    @Test
    public void testNonPrivateIntegerCount() {
        Block valuesBlock = BlockAssertions.createLongSequenceBlock(1, 100000);
        this.assertCardinality(valuesBlock, (Type)BigintType.BIGINT, Double.POSITIVE_INFINITY, 99466, 0L);
        this.assertCardinality(valuesBlock, (Type)BigintType.BIGINT, Double.POSITIVE_INFINITY, 8192, 100219, 0L);
        this.assertCardinality(valuesBlock, (Type)BigintType.BIGINT, Double.POSITIVE_INFINITY, 2048, 32, 100102, 0L);
    }

    @Test
    public void testPrivateIntegerCount() {
        Block valuesBlock = BlockAssertions.createLongSequenceBlock(1, 100000);
        this.assertCardinality(valuesBlock, (Type)BigintType.BIGINT, 8.0, 100000, 25000L);
        this.assertCardinality(valuesBlock, (Type)BigintType.BIGINT, 8.0, 8192, 100000, 25000L);
        this.assertCardinality(valuesBlock, (Type)BigintType.BIGINT, 8.0, 2048, 32, 100000, 25000L);
    }

    @Test
    public void testNonPrivateDoubleCount() {
        Block valuesBlock = BlockAssertions.createDoubleSequenceBlock(1, 100000);
        this.assertCardinality(valuesBlock, (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY, 99670, 0L);
        this.assertCardinality(valuesBlock, (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY, 8192, 100078, 0L);
        this.assertCardinality(valuesBlock, (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY, 2048, 32, 98350, 0L);
    }

    @Test
    public void testPrivateDoubleCount() {
        Block valuesBlock = BlockAssertions.createDoubleSequenceBlock(1, 100000);
        this.assertCardinality(valuesBlock, (Type)DoubleType.DOUBLE, 8.0, 100000, 25000L);
        this.assertCardinality(valuesBlock, (Type)DoubleType.DOUBLE, 8.0, 8192, 100000, 25000L);
        this.assertCardinality(valuesBlock, (Type)DoubleType.DOUBLE, 8.0, 2048, 32, 100000, 25000L);
    }

    @Test
    public void testNonPrivateStringCount() {
        Block valuesBlock = BlockAssertions.createStringSequenceBlock(1, 100000);
        this.assertCardinality(valuesBlock, (Type)VarcharType.VARCHAR, Double.POSITIVE_INFINITY, 100190, 0L);
        this.assertCardinality(valuesBlock, (Type)VarcharType.VARCHAR, Double.POSITIVE_INFINITY, 8192, 99982, 0L);
        this.assertCardinality(valuesBlock, (Type)VarcharType.VARCHAR, Double.POSITIVE_INFINITY, 2048, 32, 100773, 0L);
    }

    @Test
    public void testPrivateStringCount() {
        Block valuesBlock = BlockAssertions.createStringSequenceBlock(1, 100000);
        this.assertCardinality(valuesBlock, (Type)VarcharType.VARCHAR, 8.0, 100000, 25000L);
        this.assertCardinality(valuesBlock, (Type)VarcharType.VARCHAR, 8.0, 8192, 100000, 25000L);
        this.assertCardinality(valuesBlock, (Type)VarcharType.VARCHAR, 8.0, 2048, 32, 100000, 25000L);
    }
}

