/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.aggregation.noisyaggregation.AbstractTestNoisySfmAggregation;
import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.SfmSketch;
import org.testng.annotations.Test;

public class TestNoisyApproximateSetSfmAggregation
extends AbstractTestNoisySfmAggregation {
    @Override
    protected String getFunctionName() {
        return "noisy_approx_set_sfm";
    }

    @Override
    protected long getCardinalityFromResult(Object result) {
        return this.getSketchFromResult(result).cardinality();
    }

    private boolean sketchSizesMatch(Object a, Object b) {
        SfmSketch sketchA = this.getSketchFromResult(a);
        SfmSketch sketchB = this.getSketchFromResult(b);
        return sketchA.getBitmap().length() == sketchB.getBitmap().length();
    }

    private void assertSketchSize(Block valuesBlock, Type valueType, double epsilon, int numberOfBuckets, int precision, SqlVarbinary expected) {
        this.assertFunction(valuesBlock, valueType, epsilon, numberOfBuckets, precision, this::sketchSizesMatch, expected);
    }

    private void assertSketchSize(Block valuesBlock, Type valueType, double epsilon, int numberOfBuckets, SqlVarbinary expected) {
        this.assertFunction(valuesBlock, valueType, epsilon, numberOfBuckets, this::sketchSizesMatch, expected);
    }

    private void assertSketchSize(Block valuesBlock, Type valueType, double epsilon, SqlVarbinary expected) {
        this.assertFunction(valuesBlock, valueType, epsilon, this::sketchSizesMatch, expected);
    }

    @Test
    public void testNonPrivateInteger() {
        Block valuesBlock = BlockAssertions.createLongSequenceBlock(1, 100000);
        SqlVarbinary refSketch = this.toSqlVarbinary(this.createLongSketch(4096, 24, 1, 100000));
        this.assertCardinality(valuesBlock, (Type)BigintType.BIGINT, Double.POSITIVE_INFINITY, refSketch, 0L);
        this.assertSketchSize(valuesBlock, (Type)BigintType.BIGINT, Double.POSITIVE_INFINITY, refSketch);
        refSketch = this.toSqlVarbinary(this.createLongSketch(8192, 24, 1, 100000));
        this.assertCardinality(valuesBlock, (Type)BigintType.BIGINT, Double.POSITIVE_INFINITY, 8192, refSketch, 0L);
        this.assertSketchSize(valuesBlock, (Type)BigintType.BIGINT, Double.POSITIVE_INFINITY, 8192, refSketch);
        refSketch = this.toSqlVarbinary(this.createLongSketch(2048, 32, 1, 100000));
        this.assertCardinality(valuesBlock, (Type)BigintType.BIGINT, Double.POSITIVE_INFINITY, 2048, 32, refSketch, 0L);
        this.assertSketchSize(valuesBlock, (Type)BigintType.BIGINT, Double.POSITIVE_INFINITY, 2048, 32, refSketch);
    }

    @Test
    public void testPrivateInteger() {
        Block valuesBlock = BlockAssertions.createLongSequenceBlock(1, 100000);
        SqlVarbinary refSketch = this.toSqlVarbinary(this.createLongSketch(4096, 24, 1, 100000));
        this.assertCardinality(valuesBlock, (Type)BigintType.BIGINT, 8.0, refSketch, 50000L);
        this.assertSketchSize(valuesBlock, (Type)BigintType.BIGINT, 8.0, refSketch);
        refSketch = this.toSqlVarbinary(this.createLongSketch(8192, 24, 1, 100000));
        this.assertCardinality(valuesBlock, (Type)BigintType.BIGINT, 8.0, 8192, refSketch, 50000L);
        this.assertSketchSize(valuesBlock, (Type)BigintType.BIGINT, 8.0, 8192, refSketch);
        refSketch = this.toSqlVarbinary(this.createLongSketch(2048, 32, 1, 100000));
        this.assertCardinality(valuesBlock, (Type)BigintType.BIGINT, 8.0, 2048, 32, refSketch, 50000L);
        this.assertSketchSize(valuesBlock, (Type)BigintType.BIGINT, 8.0, 2048, 32, refSketch);
    }

    @Test
    public void testNonPrivateDouble() {
        Block valuesBlock = BlockAssertions.createDoubleSequenceBlock(1, 100000);
        SqlVarbinary refSketch = this.toSqlVarbinary(this.createDoubleSketch(4096, 24, 1, 100000));
        this.assertCardinality(valuesBlock, (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY, refSketch, 0L);
        this.assertSketchSize(valuesBlock, (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY, refSketch);
        refSketch = this.toSqlVarbinary(this.createDoubleSketch(8192, 24, 1, 100000));
        this.assertCardinality(valuesBlock, (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY, 8192, refSketch, 0L);
        this.assertSketchSize(valuesBlock, (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY, 8192, refSketch);
        refSketch = this.toSqlVarbinary(this.createDoubleSketch(2048, 32, 1, 100000));
        this.assertCardinality(valuesBlock, (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY, 2048, 32, refSketch, 0L);
        this.assertSketchSize(valuesBlock, (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY, 2048, 32, refSketch);
    }

    @Test
    public void testPrivateDouble() {
        Block valuesBlock = BlockAssertions.createDoubleSequenceBlock(1, 100000);
        SqlVarbinary refSketch = this.toSqlVarbinary(this.createDoubleSketch(4096, 24, 1, 100000));
        this.assertCardinality(valuesBlock, (Type)DoubleType.DOUBLE, 8.0, refSketch, 50000L);
        this.assertSketchSize(valuesBlock, (Type)DoubleType.DOUBLE, 8.0, refSketch);
        refSketch = this.toSqlVarbinary(this.createDoubleSketch(8192, 24, 1, 100000));
        this.assertCardinality(valuesBlock, (Type)DoubleType.DOUBLE, 8.0, 8192, refSketch, 50000L);
        this.assertSketchSize(valuesBlock, (Type)DoubleType.DOUBLE, 8.0, 8192, refSketch);
        refSketch = this.toSqlVarbinary(this.createDoubleSketch(2048, 32, 1, 100000));
        this.assertCardinality(valuesBlock, (Type)DoubleType.DOUBLE, 8.0, 2048, 32, refSketch, 50000L);
        this.assertSketchSize(valuesBlock, (Type)DoubleType.DOUBLE, 8.0, 2048, 32, refSketch);
    }

    @Test
    public void testNonPrivateString() {
        Block valuesBlock = BlockAssertions.createStringSequenceBlock(1, 100000);
        SqlVarbinary refSketch = this.toSqlVarbinary(this.createStringSketch(4096, 24, 1, 100000));
        this.assertCardinality(valuesBlock, (Type)VarcharType.VARCHAR, Double.POSITIVE_INFINITY, refSketch, 0L);
        this.assertSketchSize(valuesBlock, (Type)VarcharType.VARCHAR, Double.POSITIVE_INFINITY, refSketch);
        refSketch = this.toSqlVarbinary(this.createStringSketch(8192, 24, 1, 100000));
        this.assertCardinality(valuesBlock, (Type)VarcharType.VARCHAR, Double.POSITIVE_INFINITY, 8192, refSketch, 0L);
        this.assertSketchSize(valuesBlock, (Type)VarcharType.VARCHAR, Double.POSITIVE_INFINITY, 8192, refSketch);
        refSketch = this.toSqlVarbinary(this.createStringSketch(2048, 32, 1, 100000));
        this.assertCardinality(valuesBlock, (Type)VarcharType.VARCHAR, Double.POSITIVE_INFINITY, 2048, 32, refSketch, 0L);
        this.assertSketchSize(valuesBlock, (Type)VarcharType.VARCHAR, Double.POSITIVE_INFINITY, 2048, 32, refSketch);
    }

    @Test
    public void testPrivateString() {
        Block valuesBlock = BlockAssertions.createStringSequenceBlock(1, 100000);
        SqlVarbinary refSketch = this.toSqlVarbinary(this.createStringSketch(4096, 24, 1, 100000));
        this.assertCardinality(valuesBlock, (Type)VarcharType.VARCHAR, 8.0, refSketch, 50000L);
        this.assertSketchSize(valuesBlock, (Type)VarcharType.VARCHAR, 8.0, refSketch);
        refSketch = this.toSqlVarbinary(this.createStringSketch(8192, 24, 1, 100000));
        this.assertCardinality(valuesBlock, (Type)VarcharType.VARCHAR, 8.0, 8192, refSketch, 50000L);
        this.assertSketchSize(valuesBlock, (Type)VarcharType.VARCHAR, 8.0, 8192, refSketch);
        refSketch = this.toSqlVarbinary(this.createStringSketch(2048, 32, 1, 100000));
        this.assertCardinality(valuesBlock, (Type)VarcharType.VARCHAR, 8.0, 2048, 32, refSketch, 50000L);
        this.assertSketchSize(valuesBlock, (Type)VarcharType.VARCHAR, 8.0, 2048, 32, refSketch);
    }
}

