/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=3)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkArraysOverlap {
    private static final int POSITIONS = 10000;
    private static final int SMALL_ARRAY_SIZE = 10;
    private static final int LARGE_ARRAY_SIZE = 1500;

    public static void main(String[] args) throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkArraysOverlap().smallBenchmark(data);
        new BenchmarkArraysOverlap().largeBenchmark(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkArraysOverlap.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @Benchmark
    @OperationsPerInvocation(value=100000)
    public List<Optional<Page>> smallBenchmark(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getSmallPage()));
    }

    @Benchmark
    @OperationsPerInvocation(value=15000000)
    public List<Optional<Page>> largeBenchmark(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getLargePage()));
    }

    @Test
    public void verify() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkArraysOverlap().smallBenchmark(data);
        new BenchmarkArraysOverlap().largeBenchmark(data);
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final Map<String, Type> TYPE_MAP = ImmutableMap.of((Object)"BIGINT", (Object)BigintType.BIGINT, (Object)"BOOLEAN", (Object)BooleanType.BOOLEAN, (Object)"VARCHAR", (Object)VarcharType.VARCHAR, (Object)"DOUBLE", (Object)DoubleType.DOUBLE);
        private String name = "arrays_overlap";
        private Page smallPage;
        private Page largePage;
        private PageProcessor pageProcessor;
        @Param(value={"BIGINT", "DOUBLE", "VARCHAR", "BOOLEAN"})
        private String elementType = "BIGINT";
        @Param(value={"ELEMENT", "ARRAY"})
        private String typeClass = "ELEMENT";

        private static Block createChannel(int positionCount, int arraySize, ArrayType arrayType, TypeClass typeClass) {
            BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, positionCount);
            Type basicElementType = typeClass.equals((Object)TypeClass.ELEMENT) ? arrayType.getElementType() : ((ArrayType)arrayType.getElementType()).getElementType();
            for (int position = 0; position < positionCount; ++position) {
                BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
                for (int i = 0; i < arraySize; ++i) {
                    if (basicElementType.getJavaType() == Long.TYPE) {
                        if (typeClass.equals((Object)TypeClass.ELEMENT)) {
                            basicElementType.writeLong(entryBuilder, ThreadLocalRandom.current().nextLong());
                            continue;
                        }
                        arrayType.getElementType().writeObject(entryBuilder, (Object)BlockAssertions.createLongSequenceBlock(0, ThreadLocalRandom.current().nextInt() % 10));
                        continue;
                    }
                    if (basicElementType.equals(VarcharType.VARCHAR)) {
                        if (typeClass.equals((Object)TypeClass.ELEMENT)) {
                            basicElementType.writeSlice(entryBuilder, Slices.utf8Slice((String)("test_string " + ThreadLocalRandom.current().nextInt() % 5)));
                            continue;
                        }
                        List<Slice> slices = IntStream.range(0, ThreadLocalRandom.current().nextInt() % 10).mapToObj(val -> Slices.utf8Slice((String)("test_string " + ThreadLocalRandom.current().nextInt() % 5))).collect(Collectors.toList());
                        arrayType.getElementType().writeObject(entryBuilder, (Object)BlockAssertions.createSlicesBlock(slices));
                        continue;
                    }
                    if (basicElementType.equals(BooleanType.BOOLEAN)) {
                        if (typeClass.equals((Object)TypeClass.ELEMENT)) {
                            basicElementType.writeBoolean(entryBuilder, ThreadLocalRandom.current().nextBoolean());
                            continue;
                        }
                        arrayType.getElementType().writeObject(entryBuilder, (Object)BlockAssertions.createBooleanSequenceBlock(0, ThreadLocalRandom.current().nextInt() % 10));
                        continue;
                    }
                    if (basicElementType.equals(DoubleType.DOUBLE)) {
                        if (typeClass.equals((Object)TypeClass.ELEMENT)) {
                            basicElementType.writeDouble(entryBuilder, ThreadLocalRandom.current().nextDouble());
                            continue;
                        }
                        arrayType.getElementType().writeObject(entryBuilder, (Object)BlockAssertions.createDoubleSequenceBlock(0, ThreadLocalRandom.current().nextInt() % 10));
                        continue;
                    }
                    throw new UnsupportedOperationException();
                }
                blockBuilder.closeEntry();
            }
            return blockBuilder.build();
        }

        @Setup
        public void setup() {
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            FunctionAndTypeManager functionAndTypeManager = metadata.getFunctionAndTypeManager();
            ExpressionCompiler compiler = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
            ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
            ArrayType arrayType = new ArrayType(TYPE_MAP.get(this.elementType));
            TypeClass typeClassVal = TypeClass.valueOf(this.typeClass);
            if (typeClassVal.equals((Object)TypeClass.ARRAY)) {
                arrayType = new ArrayType((Type)arrayType);
            }
            FunctionHandle functionHandle = functionAndTypeManager.lookupFunction(this.name, TypeSignatureProvider.fromTypes((Type[])new Type[]{arrayType, arrayType}));
            projectionsBuilder.add((Object)new CallExpression(this.name, functionHandle, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)arrayType), (Object)Expressions.field((int)1, (Type)arrayType))));
            ImmutableList projections = projectionsBuilder.build();
            this.pageProcessor = (PageProcessor)compiler.compilePageProcessor(TestingConnectorSession.SESSION.getSqlFunctionProperties(), Optional.empty(), (List)projections).get();
            this.largePage = new Page(new Block[]{BenchmarkData.createChannel(10000, 1500, arrayType, typeClassVal), BenchmarkData.createChannel(10000, 1500, arrayType, typeClassVal)});
            this.smallPage = new Page(new Block[]{BenchmarkData.createChannel(10000, 10, arrayType, typeClassVal), BenchmarkData.createChannel(10000, 10, arrayType, typeClassVal)});
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getSmallPage() {
            return this.smallPage;
        }

        public Page getLargePage() {
            return this.largePage;
        }

        static enum TypeClass {
            ELEMENT,
            ARRAY;

        }
    }
}

