/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import org.testng.annotations.Test;

public class TestArrayFindFirstIndexFunction
extends AbstractTestFunctions {
    @Test
    public void testBasic() {
        this.assertFunction("find_first_index(ARRAY [5, 6], x -> x = 5)", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("find_first_index(ARRAY [BIGINT '5', BIGINT '6'], x -> x = 5)", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("find_first_index(ARRAY [5, 6], x -> x > 5)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("find_first_index(ARRAY [null, false, true, false, true, false], x -> nullif(x, false))", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("find_first_index(ARRAY [null, true, false, null, true, false, null], x -> not x)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("find_first_index(ARRAY [4.8E0, 6.2E0], x -> x > 5)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("find_first_index(ARRAY ['abc', 'def', 'ayz'], x -> substr(x, 1, 1) = 'a')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("find_first_index(ARRAY [ARRAY ['abc', null, '123'], ARRAY ['def', 'x', '456']], x -> x[2] IS NULL)", (Type)BigintType.BIGINT, 1L);
    }

    @Test
    public void testPositiveOffset() {
        this.assertFunction("find_first_index(ARRAY [5, 6], 2, x -> x = 5)", (Type)BigintType.BIGINT, null);
        this.assertFunction("find_first_index(ARRAY [5, 6], 4, x -> x > 0)", (Type)BigintType.BIGINT, null);
        this.assertFunction("find_first_index(ARRAY [5, 6, 7, 8], 3, x -> x > 5)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("find_first_index(ARRAY [3, 4, 5, 6], 2, x -> x > 0)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("find_first_index(ARRAY [3, 4, 5, 6], 2, x -> x < 4)", (Type)BigintType.BIGINT, null);
        this.assertFunction("find_first_index(ARRAY [null, false, true, null, true, false], 4, x -> nullif(x, false))", (Type)BigintType.BIGINT, 5L);
        this.assertFunction("find_first_index(ARRAY [4.8E0, 6.2E0, 7.8E0], 3, x -> x > 5)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("find_first_index(ARRAY ['abc', 'def', 'ayz'], 2, x -> substr(x, 1, 1) = 'a')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("find_first_index(ARRAY [ARRAY ['abc', null, '123'], ARRAY ['def', null, '456']], 2, x -> x[2] IS NULL)", (Type)BigintType.BIGINT, 2L);
    }

    @Test
    public void testNegativeOffset() {
        this.assertFunction("find_first_index(ARRAY [5, 6], -2, x -> x > 5)", (Type)BigintType.BIGINT, null);
        this.assertFunction("find_first_index(ARRAY [5, 6], -4, x -> x > 0)", (Type)BigintType.BIGINT, null);
        this.assertFunction("find_first_index(ARRAY [5, 6, 7, 8], -2, x -> x > 5)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("find_first_index(ARRAY [9, 6, 3, 8], -2, x -> x > 5)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("find_first_index(ARRAY [3, 4, 5, 6], -2, x -> x > 0)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("find_first_index(ARRAY [3, 4, 5, 6], -2, x -> x > 5)", (Type)BigintType.BIGINT, null);
        this.assertFunction("find_first_index(ARRAY [null, false, true, null, true, false], -3, x -> nullif(x, false))", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("find_first_index(ARRAY [4.8E0, 6.2E0, 7.8E0], -2, x -> x > 5)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("find_first_index(ARRAY ['abc', 'def', 'ayz'], -2, x -> substr(x, 1, 1) = 'a')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("find_first_index(ARRAY [ARRAY ['abc', null, '123'], ARRAY ['def', null, '456']], -2, x -> x[2] IS NULL)", (Type)BigintType.BIGINT, 1L);
    }

    @Test
    public void testEmpty() {
        this.assertFunction("find_first_index(ARRAY [], x -> true)", (Type)BigintType.BIGINT, null);
        this.assertFunction("find_first_index(ARRAY [], x -> false)", (Type)BigintType.BIGINT, null);
        this.assertFunction("find_first_index(CAST (ARRAY [] AS ARRAY(BIGINT)), x -> true)", (Type)BigintType.BIGINT, null);
    }

    @Test
    public void testNullArray() {
        this.assertFunction("find_first_index(ARRAY [NULL], x -> x IS NULL)", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("find_first_index(ARRAY [NULL], x -> x IS NOT NULL)", (Type)BigintType.BIGINT, null);
        this.assertFunction("find_first_index(ARRAY [CAST (NULL AS BIGINT)], x -> x IS NULL)", (Type)BigintType.BIGINT, 1L);
    }

    @Test
    public void testNull() {
        this.assertFunction("find_first_index(NULL, x -> true)", (Type)BigintType.BIGINT, null);
        this.assertFunction("find_first_index(NULL, x -> false)", (Type)BigintType.BIGINT, null);
    }
}

