/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.airlift.stats.cardinality.HyperLogLog;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.ListIterator;
import org.testng.annotations.Test;

public class TestHyperLogLogFunctions
extends AbstractTestFunctions {
    private static final int NUMBER_OF_BUCKETS = 32768;

    private TestHyperLogLogFunctions() {
    }

    @Test
    public void testCardinalityNullArray() {
        this.assertFunction("cardinality(merge_hll(null))", (Type)BigintType.BIGINT, null);
    }

    @Test
    public void testCardinalityMultipleNullColumns() {
        this.assertFunction("cardinality(merge_hll(ARRAY[null, null, null]))", (Type)BigintType.BIGINT, null);
    }

    @Test
    public void testMergeNoColumns() {
        int blockSize = 0;
        long uniqueElements = 10000 * blockSize;
        String projection = this.getMergeProjection(this.getUniqueElements(blockSize, uniqueElements));
        this.functionAssertions.assertFunction("(CAST(" + projection + " AS VARBINARY)) IS NULL", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testCardinalityNoColumns() {
        int blockSize = 0;
        long uniqueElements = 10000 * blockSize;
        String projection = this.getCardinalityProjection(this.getUniqueElements(blockSize, uniqueElements));
        this.assertFunction(projection, (Type)BigintType.BIGINT, null);
    }

    @Test
    public void testMergeSingleColumn() {
        int blockSize = 1;
        long uniqueElements = 10000 * blockSize;
        double error = (double)uniqueElements * 0.05;
        String projection = this.getMergeProjection(this.getUniqueElements(blockSize, uniqueElements));
        this.functionAssertions.assertFunction("(CAST(" + projection + " AS VARBINARY)) IS NULL", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCardinalitySingleColumn() {
        int blockSize = 1;
        long uniqueElements = 10000 * blockSize;
        double error = (double)uniqueElements * 0.05;
        String projection = this.getCardinalityProjection(this.getUniqueElements(blockSize, uniqueElements));
        this.functionAssertions.assertFunctionWithError(projection, (Type)BigintType.BIGINT, uniqueElements, error);
    }

    @Test
    public void testNoisyCardinalitySingleColumn() {
        int[] uniqueElementsCount;
        for (int uniqueElements : uniqueElementsCount = new int[]{0, 10000, 100000, 1000000}) {
            double error = (double)uniqueElements * 0.05;
            HyperLogLog hll = HyperLogLog.newInstance((int)32768);
            for (int i = 0; i < uniqueElements; ++i) {
                hll.add((long)i);
            }
            String projection = this.getNoisyCardinalityProjection(hll);
            this.functionAssertions.assertFunctionWithError(projection, (Type)BigintType.BIGINT, uniqueElements, error);
        }
    }

    @Test
    public void testCardinalityTwoColumns() {
        int blockSize = 2;
        long uniqueElements = 10000 * blockSize;
        double error = (double)uniqueElements * 0.05;
        String projection = this.getCardinalityProjection(this.getUniqueElements(blockSize, uniqueElements));
        this.functionAssertions.assertFunctionWithError(projection, (Type)BigintType.BIGINT, uniqueElements, error);
    }

    @Test
    public void testCardinalityThreeColumns() {
        int blockSize = 3;
        long uniqueElements = 10000 * blockSize;
        double error = (double)uniqueElements * 0.05;
        String projection = this.getCardinalityProjection(this.getUniqueElements(blockSize, uniqueElements));
        this.functionAssertions.assertFunctionWithError(projection, (Type)BigintType.BIGINT, uniqueElements, error);
    }

    @Test
    public void testMergeManyColumns() {
        int blockSize = 254;
        long uniqueElements = 10000 * blockSize;
        double error = (double)uniqueElements * 0.05;
        String projection = this.getMergeProjection(this.getUniqueElements(blockSize, uniqueElements));
        this.functionAssertions.assertFunction("(CAST(" + projection + " AS VARBINARY)) IS NULL", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCardinalityManyColumns() {
        int blockSize = 254;
        long uniqueElements = 1000 * blockSize;
        double error = (double)uniqueElements * 0.05;
        String projection = this.getCardinalityProjection(this.getUniqueElements(blockSize, uniqueElements));
        this.functionAssertions.assertFunctionWithError(projection, (Type)BigintType.BIGINT, uniqueElements, error);
    }

    private List<HyperLogLog> getUniqueElements(int blockSize, long uniqueElements) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int j = 0; j < blockSize; ++j) {
            HyperLogLog firstHll = HyperLogLog.newInstance((int)32768);
            for (long i = (long)j * uniqueElements / (long)blockSize; i < (long)j * uniqueElements / (long)blockSize + uniqueElements / (long)blockSize; ++i) {
                firstHll.add(i);
            }
            builder.add((Object)firstHll);
        }
        return builder.build();
    }

    private String getCardinalityProjection(List<HyperLogLog> list) {
        String projection = "cardinality(merge_hll(ARRAY[";
        ListIterator<HyperLogLog> iterator = list.listIterator();
        ImmutableList.Builder casts = ImmutableList.builder();
        for (HyperLogLog current : list) {
            Slice firstSerial = current.serialize();
            byte[] firstBytes = firstSerial.getBytes();
            String firstEncode = BaseEncoding.base16().lowerCase().encode(firstBytes);
            casts.add((Object)("CAST(X'" + firstEncode + "' AS HyperLogLog)"));
        }
        projection = projection + Joiner.on((String)", ").join((Iterable)casts.build());
        projection = projection + "]))";
        return projection;
    }

    private String getMergeProjection(List<HyperLogLog> list) {
        String projection = "merge_hll(ARRAY[";
        ListIterator<HyperLogLog> iterator = list.listIterator();
        ImmutableList.Builder casts = ImmutableList.builder();
        for (HyperLogLog current : list) {
            Slice firstSerial = current.serialize();
            byte[] firstBytes = firstSerial.getBytes();
            String firstEncode = BaseEncoding.base16().lowerCase().encode(firstBytes);
            casts.add((Object)("CAST(X'" + firstEncode + "' AS HyperLogLog)"));
        }
        projection = projection + Joiner.on((String)", ").join((Iterable)casts.build());
        projection = projection + "])";
        return projection;
    }

    private String getNoisyCardinalityProjection(HyperLogLog hll) {
        Slice serializedHll = hll.serialize();
        byte[] hllBytes = serializedHll.getBytes();
        String encodedHll = BaseEncoding.base16().lowerCase().encode(hllBytes);
        return String.format("noisy_cardinality(CAST(X'%s' AS HyperLogLog), infinity())", encodedHll);
    }
}

