/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.JsonType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import io.airlift.slice.Slices;
import org.testng.annotations.Test;

public class TestJsonFunctions
extends AbstractTestFunctions {
    @Test
    public void testIsJsonScalar() {
        this.assertFunction("IS_JSON_SCALAR(null)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("IS_JSON_SCALAR(JSON 'null')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_JSON_SCALAR(JSON 'true')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_JSON_SCALAR(JSON '1')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_JSON_SCALAR(JSON '\"str\"')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_JSON_SCALAR('null')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_JSON_SCALAR('true')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_JSON_SCALAR('1')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_JSON_SCALAR('\"str\"')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_JSON_SCALAR(JSON '[1, 2, 3]')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IS_JSON_SCALAR(JSON '{\"a\": 1, \"b\": 2}')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IS_JSON_SCALAR('[1, 2, 3]')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IS_JSON_SCALAR('{\"a\": 1, \"b\": 2}')", (Type)BooleanType.BOOLEAN, false);
        this.assertInvalidFunction("IS_JSON_SCALAR('')", StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid JSON value: ");
        this.assertInvalidFunction("IS_JSON_SCALAR('[1')", StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid JSON value: [1");
        this.assertInvalidFunction("IS_JSON_SCALAR('1 trailing')", StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid JSON value: 1 trailing");
        this.assertInvalidFunction("IS_JSON_SCALAR('[1, 2] trailing')", StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid JSON value: [1, 2] trailing");
    }

    @Test
    public void testJsonArrayLength() {
        this.assertFunction("JSON_ARRAY_LENGTH('[]')", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("JSON_ARRAY_LENGTH('[1]')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("JSON_ARRAY_LENGTH('[1, \"foo\", null]')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("JSON_ARRAY_LENGTH('[2, 4, {\"a\": [8, 9]}, [], [5], 4]')", (Type)BigintType.BIGINT, 6L);
        this.assertFunction("JSON_ARRAY_LENGTH(JSON '[]')", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("JSON_ARRAY_LENGTH(JSON '[1]')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("JSON_ARRAY_LENGTH(JSON '[1, \"foo\", null]')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("JSON_ARRAY_LENGTH(JSON '[2, 4, {\"a\": [8, 9]}, [], [5], 4]')", (Type)BigintType.BIGINT, 6L);
        this.assertFunction("JSON_ARRAY_LENGTH(null)", (Type)BigintType.BIGINT, null);
    }

    @Test
    public void testJsonArrayContainsBoolean() {
        this.assertFunction("JSON_ARRAY_CONTAINS('[]', true)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[true]', true)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[false]', false)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[true, false]', false)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[false, true]', true)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[1]', true)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[[true]]', true)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[1, \"foo\", null, \"true\"]', true)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[2, 4, {\"a\": [8, 9]}, [], [5], false]', false)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[]', true)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[true]', true)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[false]', false)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[true, false]', false)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[false, true]', true)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[1]', true)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[[true]]', true)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[1, \"foo\", null, \"true\"]', true)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[2, 4, {\"a\": [8, 9]}, [], [5], false]', false)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS(null, true)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("JSON_ARRAY_CONTAINS(null, null)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("JSON_ARRAY_CONTAINS('[]', null)", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testJsonArrayContainsLong() {
        this.assertFunction("JSON_ARRAY_CONTAINS('[]', 1)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[3]', 3)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[-4]', -4)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[1.0]', 1)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[[2]]', 2)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[1, \"foo\", null, \"8\"]', 8)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[2, 4, {\"a\": [8, 9]}, [], [5], 6]', 6)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[92233720368547758071]', -9)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[]', 1)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[3]', 3)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[-4]', -4)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[1.0]', 1)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[[2]]', 2)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[1, \"foo\", null, \"8\"]', 8)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[2, 4, {\"a\": [8, 9]}, [], [5], 6]', 6)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[92233720368547758071]', -9)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS(null, 1)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("JSON_ARRAY_CONTAINS(null, null)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("JSON_ARRAY_CONTAINS('[3]', null)", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testJsonArrayContainsDouble() {
        this.assertFunction("JSON_ARRAY_CONTAINS('[]', 1)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[1.5]', 1.5)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[-9.5]', -9.5)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[1]', 1.0)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[[2.5]]', 2.5)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[1, \"foo\", null, \"8.2\"]', 8.2)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[2, 4, {\"a\": [8, 9]}, [], [5], 6.1]', 6.1)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[9.6E400]', 4.2)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[]', 1)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[1.5]', 1.5)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[-9.5]', -9.5)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[1]', 1.0)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[[2.5]]', 2.5)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[1, \"foo\", null, \"8.2\"]', 8.2)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[2, 4, {\"a\": [8, 9]}, [], [5], 6.1]', 6.1)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[9.6E400]', 4.2)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS(null, 1.5)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("JSON_ARRAY_CONTAINS(null, null)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("JSON_ARRAY_CONTAINS('[3.5]', null)", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testJsonArrayContainsString() {
        this.assertFunction("JSON_ARRAY_CONTAINS('[]', 'x')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[\"foo\"]', 'foo')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[\"foo\", null]', cast(null as varchar))", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("JSON_ARRAY_CONTAINS('[\"8\"]', '8')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[1, \"foo\", null]', 'foo')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[1, 5]', '5')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[2, 4, {\"a\": [8, 9]}, [], [5], \"6\"]', '6')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[]', 'x')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[\"foo\"]', 'foo')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[\"foo\", null]', cast(null as varchar))", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[\"8\"]', '8')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[1, \"foo\", null]', 'foo')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[1, 5]', '5')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON_ARRAY_CONTAINS(JSON '[2, 4, {\"a\": [8, 9]}, [], [5], \"6\"]', '6')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS(null, 'x')", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("JSON_ARRAY_CONTAINS(null, '')", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("JSON_ARRAY_CONTAINS(null, null)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("JSON_ARRAY_CONTAINS('[\"\"]', null)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("JSON_ARRAY_CONTAINS('[\"\"]', '')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[\"\"]', 'x')", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testJsonArrayGetLong() {
        this.assertFunction("JSON_ARRAY_GET('[1]', 0)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(1)));
        this.assertFunction("JSON_ARRAY_GET('[2, 7, 4]', 1)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(7)));
        this.assertFunction("JSON_ARRAY_GET('[2, 7, 4, 6, 8, 1, 0]', 6)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(0)));
        this.assertFunction("JSON_ARRAY_GET('[]', 0)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET('[1, 3, 2]', 3)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET('[2, 7, 4, 6, 8, 1, 0]', -1)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(0)));
        this.assertFunction("JSON_ARRAY_GET('[2, 7, 4, 6, 8, 1, 0]', -2)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(1)));
        this.assertFunction("JSON_ARRAY_GET('[2, 7, 4, 6, 8, 1, 0]', -7)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(2)));
        this.assertFunction("JSON_ARRAY_GET('[2, 7, 4, 6, 8, 1, 0]', -8)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET(JSON '[1]', 0)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(1)));
        this.assertFunction("JSON_ARRAY_GET(JSON '[2, 7, 4]', 1)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(7)));
        this.assertFunction("JSON_ARRAY_GET(JSON '[2, 7, 4, 6, 8, 1, 0]', 6)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(0)));
        this.assertFunction("JSON_ARRAY_GET(JSON '[]', 0)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET(JSON '[1, 3, 2]', 3)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET(JSON '[2, 7, 4, 6, 8, 1, 0]', -1)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(0)));
        this.assertFunction("JSON_ARRAY_GET(JSON '[2, 7, 4, 6, 8, 1, 0]', -2)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(1)));
        this.assertFunction("JSON_ARRAY_GET(JSON '[2, 7, 4, 6, 8, 1, 0]', -7)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(2)));
        this.assertFunction("JSON_ARRAY_GET(JSON '[2, 7, 4, 6, 8, 1, 0]', -8)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET('[]', null)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET('[1]', null)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET('', null)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET('', 1)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET('', -1)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET('[1]', -9223372036854775807 - 1)", (Type)JsonType.JSON, null);
    }

    @Test
    public void testJsonArrayGetString() {
        this.assertFunction("JSON_ARRAY_GET('[\"jhfa\"]', 0)", (Type)JsonType.JSON, "jhfa");
        this.assertFunction("JSON_ARRAY_GET('[\"jhfa\", null]', 1)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET('[\"as\", \"fgs\", \"tehgf\"]', 1)", (Type)JsonType.JSON, "fgs");
        this.assertFunction("JSON_ARRAY_GET('[\"as\", \"fgs\", \"tehgf\", \"gjyj\", \"jut\"]', 4)", (Type)JsonType.JSON, "jut");
        this.assertFunction("JSON_ARRAY_GET(JSON '[\"jhfa\"]', 0)", (Type)JsonType.JSON, "jhfa");
        this.assertFunction("JSON_ARRAY_GET(JSON '[\"jhfa\", null]', 1)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET(JSON '[\"as\", \"fgs\", \"tehgf\"]', 1)", (Type)JsonType.JSON, "fgs");
        this.assertFunction("JSON_ARRAY_GET(JSON '[\"as\", \"fgs\", \"tehgf\", \"gjyj\", \"jut\"]', 4)", (Type)JsonType.JSON, "jut");
        this.assertFunction("JSON_ARRAY_GET('[\"\"]', 0)", (Type)JsonType.JSON, "");
        this.assertFunction("JSON_ARRAY_GET('[]', 0)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET('[null]', 0)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET('[]', null)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET('[1]', -9223372036854775807 - 1)", (Type)JsonType.JSON, null);
    }

    @Test
    public void testJsonArrayGetDouble() {
        this.assertFunction("JSON_ARRAY_GET('[3.14]', 0)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(3.14)));
        this.assertFunction("JSON_ARRAY_GET('[3.14, null]', 1)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET('[1.12, 3.54, 2.89]', 1)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(3.54)));
        this.assertFunction("JSON_ARRAY_GET('[0.58, 9.7, 7.6, 11.2, 5.02]', 4)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(5.02)));
        this.assertFunction("JSON_ARRAY_GET(JSON '[3.14]', 0)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(3.14)));
        this.assertFunction("JSON_ARRAY_GET(JSON '[3.14, null]', 1)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET(JSON '[1.12, 3.54, 2.89]', 1)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(3.54)));
        this.assertFunction("JSON_ARRAY_GET(JSON '[0.58, 9.7, 7.6, 11.2, 5.02]', 4)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(5.02)));
        this.assertFunction("JSON_ARRAY_GET('[1.0]', -1)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(1.0)));
        this.assertFunction("JSON_ARRAY_GET('[1.0]', null)", (Type)JsonType.JSON, null);
    }

    @Test
    public void testJsonArrayGetBoolean() {
        this.assertFunction("JSON_ARRAY_GET('[true]', 0)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(true)));
        this.assertFunction("JSON_ARRAY_GET('[true, null]', 1)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET('[false, false, true]', 1)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(false)));
        this.assertFunction("JSON_ARRAY_GET('[true, false, false, true, true, false]', 5)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(false)));
        this.assertFunction("JSON_ARRAY_GET(JSON '[true]', 0)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(true)));
        this.assertFunction("JSON_ARRAY_GET(JSON '[true, null]', 1)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET(JSON '[false, false, true]', 1)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(false)));
        this.assertFunction("JSON_ARRAY_GET(JSON '[true, false, false, true, true, false]', 5)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(false)));
        this.assertFunction("JSON_ARRAY_GET('[true]', -1)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf(true)));
    }

    @Test
    public void testJsonArrayGetNonScalar() {
        this.assertFunction("JSON_ARRAY_GET('[{\"hello\":\"world\"}]', 0)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf("{\"hello\":\"world\"}")));
        this.assertFunction("JSON_ARRAY_GET('[{\"hello\":\"world\"}, [1,2,3]]', 1)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf("[1,2,3]")));
        this.assertFunction("JSON_ARRAY_GET('[{\"hello\":\"world\"}, [1,2, {\"x\" : 2} ]]', 1)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf("[1,2,{\"x\":2}]")));
        this.assertFunction("JSON_ARRAY_GET('[{\"hello\":\"world\"}, {\"a\":[{\"x\":99}]}]', 1)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf("{\"a\":[{\"x\":99}]}")));
        this.assertFunction("JSON_ARRAY_GET('[{\"hello\":\"world\"}, {\"a\":[{\"x\":99}]}]', -1)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf("{\"a\":[{\"x\":99}]}")));
        this.assertFunction("JSON_ARRAY_GET('[{\"hello\": null}]', 0)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf("{\"hello\":null}")));
        this.assertFunction("JSON_ARRAY_GET('[{\"\":\"\"}]', 0)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf("{\"\":\"\"}")));
        this.assertFunction("JSON_ARRAY_GET('[{null:null}]', 0)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET('[{null:\"\"}]', 0)", (Type)JsonType.JSON, null);
        this.assertFunction("JSON_ARRAY_GET('[{\"\":null}]', 0)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf("{\"\":null}")));
        this.assertFunction("JSON_ARRAY_GET('[{\"\":null}]', -1)", (Type)JsonType.JSON, Slices.utf8Slice((String)String.valueOf("{\"\":null}")));
    }

    @Test
    public void testJsonArrayContainsInvalid() {
        for (String value : new String[]{"'x'", "2.5", "8", "true", "cast(null as varchar)"}) {
            for (String array : new String[]{"", "123", "[", "[1,0,]", "[1,,0]"}) {
                this.assertFunction(String.format("JSON_ARRAY_CONTAINS('%s', %s)", array, value), (Type)BooleanType.BOOLEAN, null);
            }
        }
    }

    @Test
    public void testInvalidJsonParse() {
        this.assertInvalidFunction("JSON 'INVALID'", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("JSON_PARSE('INVALID')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("JSON_PARSE('\"x\": 1')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
    }

    @Test
    public void testJsonFormat() {
        this.assertFunction("JSON_FORMAT(JSON '[\"a\", \"b\"]')", (Type)VarcharType.VARCHAR, "[\"a\",\"b\"]");
    }
}

