/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPageProcessorCompiler {
    private MetadataManager metadataManager;
    private ExpressionCompiler compiler;

    @BeforeClass
    public void setup() {
        this.metadataManager = MetadataManager.createTestMetadataManager();
        this.compiler = new ExpressionCompiler((Metadata)this.metadataManager, new PageFunctionCompiler((Metadata)this.metadataManager, 0));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.metadataManager = null;
        this.compiler = null;
    }

    @Test
    public void testNoCaching() {
        FunctionAndTypeManager functionAndTypeManager = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
        ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        FunctionHandle functionHandle = functionAndTypeManager.lookupFunction("concat", TypeSignatureProvider.fromTypes((Type[])new Type[]{arrayType, arrayType}));
        projectionsBuilder.add((Object)new CallExpression("concat", functionHandle, (Type)arrayType, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)arrayType), (Object)Expressions.field((int)1, (Type)arrayType))));
        ImmutableList projections = projectionsBuilder.build();
        PageProcessor pageProcessor = (PageProcessor)this.compiler.compilePageProcessor(SessionTestUtils.TEST_SESSION.getSqlFunctionProperties(), Optional.empty(), (List)projections).get();
        PageProcessor pageProcessor2 = (PageProcessor)this.compiler.compilePageProcessor(SessionTestUtils.TEST_SESSION.getSqlFunctionProperties(), Optional.empty(), (List)projections).get();
        Assert.assertTrue((pageProcessor != pageProcessor2 ? 1 : 0) != 0);
    }

    @Test
    public void testSanityRLE() {
        PageProcessor processor = (PageProcessor)this.compiler.compilePageProcessor(SessionTestUtils.TEST_SESSION.getSqlFunctionProperties(), Optional.empty(), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)BigintType.BIGINT), (Object)Expressions.field((int)1, (Type)VarcharType.VARCHAR)), false, 8192).get();
        Slice varcharValue = Slices.utf8Slice((String)"hello");
        Page page = new Page(new Block[]{RunLengthEncodedBlock.create((Type)BigintType.BIGINT, (Object)123L, (int)100), RunLengthEncodedBlock.create((Type)VarcharType.VARCHAR, (Object)varcharValue, (int)100)});
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)100);
        Assert.assertTrue((boolean)(outputPage.getBlock(0) instanceof RunLengthEncodedBlock));
        Assert.assertTrue((boolean)(outputPage.getBlock(1) instanceof RunLengthEncodedBlock));
        RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)outputPage.getBlock(0);
        Assert.assertEquals((long)BigintType.BIGINT.getLong(rleBlock.getValue(), 0), (long)123L);
        RunLengthEncodedBlock rleBlock1 = (RunLengthEncodedBlock)outputPage.getBlock(1);
        Assert.assertEquals((Object)VarcharType.VARCHAR.getSlice(rleBlock1.getValue(), 0), (Object)varcharValue);
    }

    @Test
    public void testSanityFilterOnDictionary() {
        FunctionAndTypeManager functionAndTypeManager = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
        CallExpression lengthVarchar = new CallExpression("length", functionAndTypeManager.lookupFunction("length", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})), (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR)));
        FunctionHandle lessThan = functionAndTypeManager.resolveOperator(OperatorType.LESS_THAN, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}));
        CallExpression filter = new CallExpression(OperatorType.LESS_THAN.name(), lessThan, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)lengthVarchar, (Object)Expressions.constant((Object)10L, (Type)BigintType.BIGINT)));
        PageProcessor processor = (PageProcessor)this.compiler.compilePageProcessor(SessionTestUtils.TEST_SESSION.getSqlFunctionProperties(), Optional.of(filter), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR)), false, 8192).get();
        Page page = new Page(new Block[]{TestPageProcessorCompiler.createDictionaryBlock(TestPageProcessorCompiler.createExpectedValues(10), 100)});
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)100);
        Assert.assertTrue((boolean)(outputPage.getBlock(0) instanceof DictionaryBlock));
        DictionaryBlock dictionaryBlock = (DictionaryBlock)outputPage.getBlock(0);
        Assert.assertEquals((int)dictionaryBlock.getDictionary().getPositionCount(), (int)10);
        Page outputPage2 = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Assert.assertEquals((int)outputPage2.getPositionCount(), (int)100);
        Assert.assertTrue((boolean)(outputPage2.getBlock(0) instanceof DictionaryBlock));
        DictionaryBlock dictionaryBlock2 = (DictionaryBlock)outputPage2.getBlock(0);
        Assert.assertEquals((Object)dictionaryBlock2.getDictionary(), (Object)dictionaryBlock.getDictionary());
    }

    @Test
    public void testSanityFilterOnRLE() {
        FunctionAndTypeManager functionAndTypeManager = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
        FunctionHandle lessThan = functionAndTypeManager.resolveOperator(OperatorType.LESS_THAN, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}));
        CallExpression filter = new CallExpression(OperatorType.LESS_THAN.name(), lessThan, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)BigintType.BIGINT), (Object)Expressions.constant((Object)10L, (Type)BigintType.BIGINT)));
        PageProcessor processor = (PageProcessor)this.compiler.compilePageProcessor(SessionTestUtils.TEST_SESSION.getSqlFunctionProperties(), Optional.of(filter), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)BigintType.BIGINT)), false, 8192).get();
        Page page = new Page(new Block[]{BlockAssertions.createRLEBlock(5L, 100)});
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)100);
        Assert.assertTrue((boolean)(outputPage.getBlock(0) instanceof RunLengthEncodedBlock));
        RunLengthEncodedBlock rle = (RunLengthEncodedBlock)outputPage.getBlock(0);
        Assert.assertEquals((long)BigintType.BIGINT.getLong(rle.getValue(), 0), (long)5L);
    }

    @Test
    public void testSanityColumnarDictionary() {
        PageProcessor processor = (PageProcessor)this.compiler.compilePageProcessor(SessionTestUtils.TEST_SESSION.getSqlFunctionProperties(), Optional.empty(), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR)), false, 8192).get();
        Page page = new Page(new Block[]{TestPageProcessorCompiler.createDictionaryBlock(TestPageProcessorCompiler.createExpectedValues(10), 100)});
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)100);
        Assert.assertTrue((boolean)(outputPage.getBlock(0) instanceof DictionaryBlock));
        DictionaryBlock dictionaryBlock = (DictionaryBlock)outputPage.getBlock(0);
        Assert.assertEquals((int)dictionaryBlock.getDictionary().getPositionCount(), (int)10);
    }

    @Test
    public void testNonDeterministicProject() {
        FunctionAndTypeManager functionAndTypeManager = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
        FunctionHandle lessThan = functionAndTypeManager.resolveOperator(OperatorType.LESS_THAN, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}));
        CallExpression random = new CallExpression("random", functionAndTypeManager.lookupFunction("random", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})), (Type)BigintType.BIGINT, Collections.singletonList(Expressions.constant((Object)10L, (Type)BigintType.BIGINT)));
        InputReferenceExpression col0 = Expressions.field((int)0, (Type)BigintType.BIGINT);
        CallExpression lessThanRandomExpression = new CallExpression(OperatorType.LESS_THAN.name(), lessThan, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)col0, (Object)random));
        PageProcessor processor = (PageProcessor)this.compiler.compilePageProcessor(SessionTestUtils.TEST_SESSION.getSqlFunctionProperties(), Optional.empty(), (List)ImmutableList.of((Object)lessThanRandomExpression), false, 8192).get();
        Assert.assertFalse((boolean)new RowExpressionDeterminismEvaluator(this.metadataManager.getFunctionAndTypeManager()).isDeterministic((RowExpression)lessThanRandomExpression));
        Page page = new Page(new Block[]{BlockAssertions.createLongDictionaryBlock(1, 100)});
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Assert.assertFalse((boolean)(outputPage.getBlock(0) instanceof DictionaryBlock));
    }

    private static DictionaryBlock createDictionaryBlock(Slice[] expectedValues, int positionCount) {
        int dictionarySize = expectedValues.length;
        int[] ids = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            ids[i] = i % dictionarySize;
        }
        return new DictionaryBlock(BlockAssertions.createSlicesBlock(expectedValues), ids);
    }

    private static Slice[] createExpectedValues(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = TestPageProcessorCompiler.createExpectedValue(position);
        }
        return expectedValues;
    }

    private static Slice createExpectedValue(int length) {
        DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(16);
        for (int index = 0; index < length; ++index) {
            dynamicSliceOutput.writeByte(length * (index + 1));
        }
        return dynamicSliceOutput.slice();
    }
}

