/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestParametricScalarImplementationValidation {
    private static final MethodHandle STATE_FACTORY = Reflection.methodHandle(TestParametricScalarImplementationValidation.class, (String)"createState", (Class[])new Class[0]);

    @Test
    public void testSqlFunctionPropertiesPosition() {
        MethodHandle validFunctionMethodHandle = Reflection.methodHandle(TestParametricScalarImplementationValidation.class, (String)"validSqlFunctionPropertiesParameterPosition", (Class[])new Class[]{SqlFunctionProperties.class, Long.TYPE, Long.TYPE});
        BuiltInScalarFunctionImplementation validFunction = new BuiltInScalarFunctionImplementation(false, (List)ImmutableList.of((Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementationChoice.NullConvention)ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementationChoice.NullConvention)ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL)), validFunctionMethodHandle);
        Assert.assertEquals((Object)validFunction.getMethodHandle(), (Object)validFunctionMethodHandle);
        try {
            BuiltInScalarFunctionImplementation invalidFunction = new BuiltInScalarFunctionImplementation(false, (List)ImmutableList.of((Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementationChoice.NullConvention)ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementationChoice.NullConvention)ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL)), Reflection.methodHandle(TestParametricScalarImplementationValidation.class, (String)"invalidSqlFunctionPropertiesParameterPosition", (Class[])new Class[]{Long.TYPE, Long.TYPE, SqlFunctionProperties.class}));
            Assert.fail((String)"expected exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"SqlFunctionProperties must be the first argument when instanceFactory is not present");
        }
        MethodHandle validFunctionWithInstanceFactoryMethodHandle = Reflection.methodHandle(TestParametricScalarImplementationValidation.class, (String)"validSqlFunctionPropertiesParameterPosition", (Class[])new Class[]{Object.class, SqlFunctionProperties.class, Long.TYPE, Long.TYPE});
        BuiltInScalarFunctionImplementation validFunctionWithInstanceFactory = new BuiltInScalarFunctionImplementation(false, (List)ImmutableList.of((Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementationChoice.NullConvention)ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementationChoice.NullConvention)ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL)), validFunctionWithInstanceFactoryMethodHandle, Optional.of(STATE_FACTORY));
        Assert.assertEquals((Object)validFunctionWithInstanceFactory.getMethodHandle(), (Object)validFunctionWithInstanceFactoryMethodHandle);
        try {
            BuiltInScalarFunctionImplementation invalidFunctionWithInstanceFactory = new BuiltInScalarFunctionImplementation(false, (List)ImmutableList.of((Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementationChoice.NullConvention)ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementationChoice.NullConvention)ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL)), Reflection.methodHandle(TestParametricScalarImplementationValidation.class, (String)"invalidSqlFunctionPropertiesParameterPosition", (Class[])new Class[]{Object.class, Long.TYPE, Long.TYPE, SqlFunctionProperties.class}), Optional.of(STATE_FACTORY));
            Assert.fail((String)"expected exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"SqlFunctionProperties must be the second argument when instanceFactory is present");
        }
    }

    public static Object createState() {
        return null;
    }

    public static long validSqlFunctionPropertiesParameterPosition(SqlFunctionProperties properties, long arg1, long arg2) {
        return arg1 + arg2;
    }

    public static long validSqlFunctionPropertiesParameterPosition(Object state, SqlFunctionProperties properties, long arg1, long arg2) {
        return arg1 + arg2;
    }

    public static long invalidSqlFunctionPropertiesParameterPosition(long arg1, long arg2, SqlFunctionProperties properties) {
        return arg1 + arg2;
    }

    public static long invalidSqlFunctionPropertiesParameterPosition(Object state, long arg1, long arg2, SqlFunctionProperties properties) {
        return arg1 + arg2;
    }
}

