/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.SfmSketch;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.operator.scalar.SfmSketchFunctions;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.io.BaseEncoding;
import io.airlift.slice.Slice;
import org.testng.annotations.Test;

public class TestSfmSketchFunctions
extends AbstractTestFunctions {
    @Test
    public void testCardinality() {
        SfmSketch sketch = this.createSketch(1, 10000, 4.0);
        Assert.assertEquals((long)SfmSketchFunctions.cardinality((Slice)sketch.serialize()), (long)sketch.cardinality());
    }

    @Test
    public void testEmptyApproxSet() {
        this.assertFunction("cardinality(noisy_empty_approx_set_sfm(infinity()))", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("cardinality(noisy_empty_approx_set_sfm(infinity(), 4096))", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("cardinality(noisy_empty_approx_set_sfm(infinity(), 4096, 24))", (Type)BigintType.BIGINT, 0L);
    }

    @Test
    public void testCastRoundTrip() {
        this.assertFunction("cardinality(CAST(CAST(noisy_empty_approx_set_sfm(infinity()) AS VARBINARY) AS SFMSKETCH))", (Type)BigintType.BIGINT, 0L);
    }

    @Test
    public void testMergeNullArray() {
        this.assertFunction("merge_sfm(ARRAY[NULL, NULL, NULL]) IS NULL", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testMergeEmptyArray() {
        this.assertFunction("merge_sfm(ARRAY[]) IS NULL", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testMergeSingleArray() {
        String sketchProjection = this.getSketchProjection(this.createSketch(1, 10000, 3.0));
        this.assertFunction("cardinality(merge_sfm(ARRAY[" + sketchProjection + "])) = cardinality(" + sketchProjection + ")", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testMergeManyArrays() {
        String sketchProjection1 = this.getSketchProjection(this.createSketch(1, 50, Double.POSITIVE_INFINITY));
        String sketchProjection2 = this.getSketchProjection(this.createSketch(51, 200, Double.POSITIVE_INFINITY));
        String sketchProjection3 = this.getSketchProjection(this.createSketch(100, 300, Double.POSITIVE_INFINITY));
        String sketchProjectionMerged = this.getSketchProjection(this.createSketch(1, 300, Double.POSITIVE_INFINITY));
        String arrayProjection = "ARRAY[" + sketchProjection1 + ", " + sketchProjection2 + ", " + sketchProjection3 + "]";
        this.assertFunction("CAST(merge_sfm(" + arrayProjection + ") AS VARBINARY) = CAST(" + sketchProjectionMerged + " AS VARBINARY)", (Type)BooleanType.BOOLEAN, true);
    }

    private SfmSketch createSketch(int start, int end, double epsilon) {
        SfmSketch sketch = SfmSketch.create((int)2048, (int)16);
        for (int i = start; i <= end; ++i) {
            sketch.add((long)i);
        }
        if (epsilon < Double.POSITIVE_INFINITY) {
            sketch.enablePrivacy(epsilon);
        }
        return sketch;
    }

    private String getSketchProjection(SfmSketch sketch) {
        byte[] binary = sketch.serialize().getBytes();
        String encoded = BaseEncoding.base16().lowerCase().encode(binary);
        return "CAST(X'" + encoded + "' AS SFMSKETCH)";
    }
}

