/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import org.testng.annotations.Test;

public class TestUrlFunctions
extends AbstractTestFunctions {
    @Test
    public void testUrlExtract() {
        this.validateUrlExtract("http://example.com/path1/p.php?k1=v1&k2=v2#Ref1", "http", "example.com", null, "/path1/p.php", "k1=v1&k2=v2", "Ref1");
        this.validateUrlExtract("http://example.com/path1/p.php?", "http", "example.com", null, "/path1/p.php", "", "");
        this.validateUrlExtract("http://example.com/path1/p.php", "http", "example.com", null, "/path1/p.php", "", "");
        this.validateUrlExtract("http://example.com:8080/path1/p.php?k1=v1&k2=v2#Ref1", "http", "example.com", 8080L, "/path1/p.php", "k1=v1&k2=v2", "Ref1");
        this.validateUrlExtract("https://username@example.com", "https", "example.com", null, "", "", "");
        this.validateUrlExtract("https://username:password@example.com", "https", "example.com", null, "", "", "");
        this.validateUrlExtract("mailto:test@example.com", "mailto", "", null, "", "", "");
        this.validateUrlExtract("foo", "", "", null, "foo", "", "");
        this.validateUrlExtract("http://example.com/^", null, null, null, null, null, null);
    }

    @Test
    public void testUrlExtractParameter() {
        this.assertFunction("url_extract_parameter('http://example.com/path1/p.php?k1=v1&k2=v2&k3&k4#Ref1', 'k1')", (Type)VarcharType.createVarcharType((int)53), "v1");
        this.assertFunction("url_extract_parameter('http://example.com/path1/p.php?k1=v1&k2=v2&k3&k4#Ref1', 'k2')", (Type)VarcharType.createVarcharType((int)53), "v2");
        this.assertFunction("url_extract_parameter('http://example.com/path1/p.php?k1=v1&k2=v2&k3&k4#Ref1', 'k3')", (Type)VarcharType.createVarcharType((int)53), "");
        this.assertFunction("url_extract_parameter('http://example.com/path1/p.php?k1=v1&k2=v2&k3&k4#Ref1', 'k4')", (Type)VarcharType.createVarcharType((int)53), "");
        this.assertFunction("url_extract_parameter('http://example.com/path1/p.php?k1=v1&k2=v2&k3&k4#Ref1', 'k5')", (Type)VarcharType.createVarcharType((int)53), null);
        this.assertFunction("url_extract_parameter('http://example.com/path1/p.php?k1=v1&k1=v2&k1&k1#Ref1', 'k1')", (Type)VarcharType.createVarcharType((int)53), "v1");
        this.assertFunction("url_extract_parameter('http://example.com/path1/p.php?k1&k1=v1&k1&k1#Ref1', 'k1')", (Type)VarcharType.createVarcharType((int)50), "");
        this.assertFunction("url_extract_parameter('http://example.com/path1/p.php?k=a=b=c&x=y#Ref1', 'k')", (Type)VarcharType.createVarcharType((int)47), "a=b=c");
        this.assertFunction("url_extract_parameter('foo', 'k1')", (Type)VarcharType.createVarcharType((int)3), null);
    }

    @Test
    public void testUrlEncode() {
        String[][] outputInputPairs;
        for (String[] outputInputPair : outputInputPairs = new String[][]{{"http%3A%2F%2Ftest", "http://test"}, {"http%3A%2F%2Ftest%3Fa%3Db%26c%3Dd", "http://test?a=b&c=d"}, {"http%3A%2F%2F%E3%83%86%E3%82%B9%E3%83%88", "http://\u30c6\u30b9\u30c8"}, {"%7E%40%3A.-*_%2B+%E2%98%83", "~@:.-*_+ \u2603"}, {"test", "test"}}) {
            String input = outputInputPair[1];
            String output = outputInputPair[0];
            this.assertFunction("url_encode('" + input + "')", (Type)VarcharType.createVarcharType((int)(input.length() * 12)), output);
        }
        this.assertFunction("url_encode('\ud867\ude3d')", (Type)VarcharType.createVarcharType((int)12), "%F0%A9%B8%BD");
    }

    @Test
    public void testUrlDecode() {
        String[][] inputOutputPairs;
        for (String[] inputOutputPair : inputOutputPairs = new String[][]{{"http%3A%2F%2Ftest", "http://test"}, {"http%3A%2F%2Ftest%3Fa%3Db%26c%3Dd", "http://test?a=b&c=d"}, {"http%3A%2F%2F%E3%83%86%E3%82%B9%E3%83%88", "http://\u30c6\u30b9\u30c8"}, {"%7E%40%3A.-*_%2B+%E2%98%83", "~@:.-*_+ \u2603"}, {"test", "test"}}) {
            String input = inputOutputPair[0];
            String output = inputOutputPair[1];
            this.assertFunction("url_decode('" + input + "')", (Type)VarcharType.createVarcharType((int)input.length()), output);
        }
    }

    private void validateUrlExtract(String url, String protocol, String host, Long port, String path, String query, String fragment) {
        this.assertFunction("url_extract_protocol('" + url + "')", (Type)VarcharType.createVarcharType((int)url.length()), protocol);
        this.assertFunction("url_extract_host('" + url + "')", (Type)VarcharType.createVarcharType((int)url.length()), host);
        if (port == null) {
            this.assertFunction("url_extract_port('" + url + "')", (Type)BigintType.BIGINT, null);
        } else {
            this.assertFunction("url_extract_port('" + url + "')", (Type)BigintType.BIGINT, port);
        }
        this.assertFunction("url_extract_path('" + url + "')", (Type)VarcharType.createVarcharType((int)url.length()), path);
        this.assertFunction("url_extract_query('" + url + "')", (Type)VarcharType.createVarcharType((int)url.length()), query);
        this.assertFunction("url_extract_fragment('" + url + "')", (Type)VarcharType.createVarcharType((int)url.length()), fragment);
    }
}

