/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.sql;

import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import org.testng.annotations.Test;

public class TestMapKeyExists
extends AbstractTestFunctions {
    @Test
    public void testBasic() {
        this.assertFunction("MAP_KEY_EXISTS(MAP(ARRAY[1, 2, 3], ARRAY[4, 5, 6]), 2)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP_KEY_EXISTS(MAP(ARRAY[-1, -2, -3], ARRAY[4, 5, 6]), 2)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP_KEY_EXISTS(MAP(ARRAY['ab', 'bc', 'cd'], ARRAY['x', 'y', 'z']), 'abc')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP_KEY_EXISTS(MAP(ARRAY[123.0, 99.5, 1000.99], ARRAY['x', 'y', 'z']), 123.0)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP_KEY_EXISTS(MAP(ARRAY['x', 'y'], ARRAY[NULL, 1]), 'x')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP_KEY_EXISTS(MAP(ARRAY['x', 'y'], ARRAY[NULL, NULL]), 'z')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP_KEY_EXISTS(MAP(ARRAY[NAN(), 123.21], ARRAY['val1', 'val2']), 123.21)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP_KEY_EXISTS(MAP(ARRAY[NAN(), 123.21], ARRAY['val1', 'val2']), NAN())", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testEmpty() {
        this.assertFunction("MAP_KEY_EXISTS(MAP(ARRAY[], ARRAY[]), 5)", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testNull() {
        this.assertFunction("MAP_KEY_EXISTS(NULL, 1)", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testComplexKeys() {
        this.assertFunction("MAP_KEY_EXISTS(MAP(ARRAY[ROW('x', 1), ROW('y', 2)], ARRAY[1, 2]), ROW('x', 1))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP_KEY_EXISTS(MAP(ARRAY[ROW('x', 1), ROW('x', -2)], ARRAY[2, 1]), ROW('y', 1))", (Type)BooleanType.BOOLEAN, false);
    }
}

