/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.unnest;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.block.LongArrayBlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=3)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkCopyBlock {
    private static final int POSITIONS_PER_PAGE = 10000;
    private static final int BLOCK_COUNT = 100;

    @Benchmark
    public void copyBlockByLoop(BenchmarkData data) {
        for (int i = 0; i < 100; ++i) {
            Block block = data.blocks.get(i);
            int positionCount = block.getPositionCount();
            long[] values = new long[positionCount];
            for (int j = 0; j < positionCount; ++j) {
                values[j] = block.getLong(j);
            }
            boolean[] valueIsNull = BenchmarkCopyBlock.copyIsNulls(block);
            LongArrayBlock longArrayBlock = new LongArrayBlock(positionCount, Optional.of(valueIsNull), values);
        }
    }

    @Benchmark
    public void copyBlockByAppend(BenchmarkData data) {
        LongArrayBlockBuilder longArrayBlockBuilder = new LongArrayBlockBuilder(null, 10000);
        for (int i = 0; i < 100; ++i) {
            Block block = data.blocks.get(i);
            int positionCount = block.getPositionCount();
            for (int j = 0; j < positionCount; ++j) {
                BigintType.BIGINT.appendTo(block, j, (BlockBuilder)longArrayBlockBuilder);
            }
            Block block2 = longArrayBlockBuilder.build();
        }
    }

    @Benchmark
    public void copyBlockByWriteLong(BenchmarkData data) {
        LongArrayBlockBuilder longArrayBlockBuilder = new LongArrayBlockBuilder(null, 10000);
        for (int i = 0; i < 100; ++i) {
            Block block = data.blocks.get(i);
            int positionCount = block.getPositionCount();
            for (int j = 0; j < positionCount; ++j) {
                longArrayBlockBuilder.writeLong(block.getLong(i));
            }
            Block block2 = longArrayBlockBuilder.build();
        }
    }

    private static boolean[] copyIsNulls(Block block) {
        int positionCount = block.getPositionCount();
        boolean[] valueIsNull = new boolean[positionCount + 1];
        if (block.mayHaveNull()) {
            for (int i = 0; i < positionCount; ++i) {
                valueIsNull[i] = block.isNull(i);
            }
        }
        return valueIsNull;
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkCopyBlock.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private String typeSignature = "bigint";
        @Param(value={"0.0", "0.2"})
        private float primitiveNullsRatio;
        List<Block> blocks = new ArrayList<Block>();

        @Setup
        public void setup() {
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            Type type = this.getType((Metadata)metadata, this.typeSignature).get();
            for (int i = 0; i < 100; ++i) {
                this.blocks.add(BlockAssertions.createRandomBlockForType(type, 10000, this.primitiveNullsRatio, 0.0f, false, (List<BlockAssertions.Encoding>)ImmutableList.of()));
            }
        }

        public Optional<Type> getType(Metadata metadata, String typeString) {
            if (typeString.equals("NONE")) {
                return Optional.empty();
            }
            TypeSignature signature = TypeSignature.parseTypeSignature((String)typeString);
            return Optional.of(metadata.getType(signature));
        }
    }
}

