/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.airlift.configuration.ConfigurationFactory;
import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.operator.aggregation.arrayagg.ArrayAggGroupImplementation;
import com.facebook.presto.operator.aggregation.histogram.HistogramGroupImplementation;
import com.facebook.presto.operator.aggregation.multimapagg.MultimapAggGroupImplementation;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.RegexLibrary;
import com.facebook.presto.sql.tree.CreateView;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestFeaturesConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((FeaturesConfig)ConfigAssertions.recordDefaults(FeaturesConfig.class)).setCpuCostWeight(75.0).setMemoryCostWeight(10.0).setNetworkCostWeight(15.0).setDistributedIndexJoinsEnabled(false).setJoinDistributionType(FeaturesConfig.JoinDistributionType.AUTOMATIC).setJoinMaxBroadcastTableSize(new DataSize(100.0, DataSize.Unit.MEGABYTE)).setSizeBasedJoinDistributionTypeEnabled(true).setGroupedExecutionEnabled(true).setRecoverableGroupedExecutionEnabled(false).setMaxFailedTaskPercentage(0.3).setConcurrentLifespansPerTask(0).setFastInequalityJoins(true).setColocatedJoinsEnabled(true).setSpatialJoinsEnabled(true).setJoinReorderingStrategy(FeaturesConfig.JoinReorderingStrategy.AUTOMATIC).setPartialMergePushdownStrategy(FeaturesConfig.PartialMergePushdownStrategy.NONE).setMaxReorderedJoins(9).setUseHistoryBasedPlanStatistics(false).setTrackHistoryBasedPlanStatistics(false).setTrackHistoryStatsFromFailedQuery(true).setUsePartialAggregationHistory(false).setTrackPartialAggregationHistory(true).setUsePerfectlyConsistentHistories(false).setHistoryCanonicalPlanNodeLimit(1000).setHistoryBasedOptimizerTimeout(new Duration(10.0, TimeUnit.SECONDS)).setHistoryBasedOptimizerPlanCanonicalizationStrategies("IGNORE_SAFE_CONSTANTS").setLogPlansUsedInHistoryBasedOptimizer(false).setRedistributeWrites(true).setScaleWriters(false).setWriterMinSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).setOptimizedScaleWriterProducerBuffer(false).setOptimizeMetadataQueries(false).setOptimizeMetadataQueriesIgnoreStats(false).setOptimizeMetadataQueriesCallThreshold(100).setOptimizeHashGeneration(true).setPushTableWriteThroughUnion(true).setDictionaryAggregation(false).setAggregationPartitioningMergingStrategy(FeaturesConfig.AggregationPartitioningMergingStrategy.LEGACY).setLegacyArrayAgg(false).setUseAlternativeFunctionSignatures(false).setGroupByUsesEqualTo(false).setLegacyMapSubscript(false).setReduceAggForComplexTypesEnabled(true).setRegexLibrary(RegexLibrary.JONI).setRe2JDfaStatesLimit(Integer.MAX_VALUE).setRe2JDfaRetries(5).setSpillEnabled(false).setJoinSpillingEnabled(true).setAggregationSpillEnabled(true).setDistinctAggregationSpillEnabled(true).setDedupBasedDistinctAggregationSpillEnabled(false).setDistinctAggregationLargeBlockSpillEnabled(false).setDistinctAggregationLargeBlockSizeThreshold(DataSize.valueOf((String)"50MB")).setOrderByAggregationSpillEnabled(true).setWindowSpillEnabled(true).setOrderBySpillEnabled(true).setTopNSpillEnabled(true).setAggregationOperatorUnspillMemoryLimit(DataSize.valueOf((String)"4MB")).setTopNOperatorUnspillMemoryLimit(DataSize.valueOf((String)"4MB")).setSpillerSpillPaths("").setSpillerThreads(4).setSpillMaxUsedSpaceThreshold(0.9).setMemoryRevokingThreshold(0.9).setMemoryRevokingTarget(0.5).setTaskSpillingStrategy(FeaturesConfig.TaskSpillingStrategy.ORDER_BY_CREATE_TIME).setQueryLimitSpillEnabled(false).setSingleStreamSpillerChoice(FeaturesConfig.SingleStreamSpillerChoice.LOCAL_FILE).setSpillerTempStorage("local").setMaxRevocableMemoryPerTask(new DataSize(500.0, DataSize.Unit.MEGABYTE)).setOptimizeMixedDistinctAggregations(false).setLegacyLogFunction(false).setIterativeOptimizerEnabled(true).setIterativeOptimizerTimeout(new Duration(3.0, TimeUnit.MINUTES)).setRuntimeOptimizerEnabled(false).setEnableDynamicFiltering(false).setDynamicFilteringMaxPerDriverRowCount(100).setDynamicFilteringMaxPerDriverSize(new DataSize(10.0, DataSize.Unit.KILOBYTE)).setDynamicFilteringRangeRowLimitPerDriver(0).setFragmentResultCachingEnabled(false).setEnableStatsCalculator(true).setEnableStatsCollectionForTemporaryTable(false).setIgnoreStatsCalculatorFailures(true).setPrintStatsForNonJoinQuery(false).setDefaultFilterFactorEnabled(false).setExchangeCompressionEnabled(false).setExchangeChecksumEnabled(false).setLegacyTimestamp(true).setLegacyRowFieldOrdinalAccess(false).setLegacyCharToVarcharCoercion(false).setEnableIntermediateAggregations(false).setPushAggregationThroughJoin(true).setParseDecimalLiteralsAsDouble(false).setForceSingleNodeOutput(true).setPagesIndexEagerCompactionEnabled(false).setFilterAndProjectMinOutputPageSize(new DataSize(500.0, DataSize.Unit.KILOBYTE)).setFilterAndProjectMinOutputPageRowCount(256).setUseMarkDistinct(true).setExploitConstraints(true).setPreferPartialAggregation(true).setPartialAggregationStrategy(FeaturesConfig.PartialAggregationStrategy.ALWAYS).setPartialAggregationByteReductionThreshold(0.5).setAdaptivePartialAggregationEnabled(false).setAdaptivePartialAggregationRowsReductionRatioThreshold(0.8).setOptimizeTopNRowNumber(true).setOptimizeCaseExpressionPredicate(false).setHistogramGroupImplementation(HistogramGroupImplementation.NEW).setArrayAggGroupImplementation(ArrayAggGroupImplementation.NEW).setMultimapAggGroupImplementation(MultimapAggGroupImplementation.NEW).setDistributedSortEnabled(true).setMaxGroupingSets(2048).setLegacyUnnestArrayRows(false).setJsonSerdeCodeGenerationEnabled(false).setPushLimitThroughOuterJoin(true).setOptimizeConstantGroupingKeys(true).setMaxConcurrentMaterializations(3).setPushdownSubfieldsEnabled(false).setPushdownSubfieldsFromLambdaEnabled(false).setPushdownDereferenceEnabled(false).setTableWriterMergeOperatorEnabled(true).setIndexLoaderTimeout(new Duration(20.0, TimeUnit.SECONDS)).setOptimizedRepartitioningEnabled(false).setListBuiltInFunctionsOnly(true).setPartitioningPrecisionStrategy(FeaturesConfig.PartitioningPrecisionStrategy.AUTOMATIC).setExperimentalFunctionsEnabled(false).setOptimizeCommonSubExpressions(true).setPreferDistributedUnion(true).setOptimizeNullsInJoin(false).setOptimizePayloadJoins(false).setJoinsNotNullInferenceStrategy(FeaturesConfig.JoinNotNullInferenceStrategy.NONE).setSkipRedundantSort(true).setWarnOnNoTableLayoutFilter("").setInlineSqlFunctions(true).setCheckAccessControlOnUtilizedColumnsOnly(false).setCheckAccessControlWithSubfields(false).setAllowWindowOrderByLiterals(true).setEnforceFixedDistributionForOutputOperator(false).setEmptyJoinOptimization(false).setLogFormattedQueryEnabled(false).setLogInvokedFunctionNamesEnabled(false).setSpoolingOutputBufferEnabled(false).setSpoolingOutputBufferThreshold(new DataSize(8.0, DataSize.Unit.MEGABYTE)).setSpoolingOutputBufferTempStorage("local").setPrestoSparkAssignBucketToPartitionForPartitionedTableWriteEnabled(false).setPartialResultsEnabled(false).setPartialResultsCompletionRatioThreshold(0.5).setOffsetClauseEnabled(false).setPartialResultsMaxExecutionTimeMultiplier(2.0).setMaterializedViewDataConsistencyEnabled(true).setMaterializedViewPartitionFilteringEnabled(true).setQueryOptimizationWithMaterializedViewEnabled(false).setVerboseRuntimeStatsEnabled(false).setAggregationIfToFilterRewriteStrategy(FeaturesConfig.AggregationIfToFilterRewriteStrategy.DISABLED).setAnalyzerType("BUILTIN").setPreProcessMetadataCalls(false).setStreamingForPartialAggregationEnabled(false).setMaxStageCountForEagerScheduling(25).setHyperloglogStandardErrorWarningThreshold(0.004).setPreferMergeJoinForSortedInputs(false).setSegmentedAggregationEnabled(false).setQueryAnalyzerTimeout(new Duration(3.0, TimeUnit.MINUTES)).setQuickDistinctLimitEnabled(false).setPushRemoteExchangeThroughGroupId(false).setOptimizeMultipleApproxPercentileOnSameFieldEnabled(true).setNativeExecutionEnabled(false).setNativeExecutionExecutablePath("./presto_server").setNativeExecutionProgramArguments("").setNativeExecutionProcessReuseEnabled(true).setRandomizeOuterJoinNullKeyEnabled(false).setRandomizeOuterJoinNullKeyStrategy(FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.DISABLED).setShardedJoinStrategy(FeaturesConfig.ShardedJoinStrategy.DISABLED).setJoinShardCount(100).setOptimizeConditionalAggregationEnabled(false).setRemoveRedundantDistinctAggregationEnabled(true).setInPredicatesAsInnerJoinsEnabled(false).setPushAggregationBelowJoinByteReductionThreshold(1.0).setPrefilterForGroupbyLimit(false).setFieldNamesInJsonCastEnabled(false).setOptimizeJoinProbeForEmptyBuildRuntimeEnabled(false).setUseDefaultsForCorrelatedAggregationPushdownThroughOuterJoins(true).setMergeDuplicateAggregationsEnabled(true).setMergeAggregationsWithAndWithoutFilter(false).setSimplifyPlanWithEmptyInput(true).setPushDownFilterExpressionEvaluationThroughCrossJoin(FeaturesConfig.PushDownFilterThroughCrossJoinStrategy.REWRITTEN_TO_INNER_JOIN).setDefaultJoinSelectivityCoefficient(0.0).setRewriteCrossJoinWithOrFilterToInnerJoin(true).setRewriteCrossJoinWithArrayContainsFilterToInnerJoin(true).setLeftJoinWithArrayContainsToEquiJoinStrategy(FeaturesConfig.LeftJoinArrayContainsToInnerJoinStrategy.DISABLED).setRewriteCrossJoinWithArrayNotContainsFilterToAntiJoin(true).setLeftJoinNullFilterToSemiJoin(true).setBroadcastJoinWithSmallBuildUnknownProbe(false).setAddPartialNodeForRowNumberWithLimitEnabled(true).setInferInequalityPredicates(false).setPullUpExpressionFromLambdaEnabled(false).setRewriteConstantArrayContainsToInEnabled(false).setUseHBOForScaledWriters(false).setRemoveRedundantCastToVarcharInJoin(true).setHandleComplexEquiJoins(false).setSkipHashGenerationForJoinWithTableScanInput(false).setCteMaterializationStrategy(FeaturesConfig.CteMaterializationStrategy.NONE).setCteFilterAndProjectionPushdownEnabled(true).setKHyperLogLogAggregationGroupNumberLimit(0L).setLimitNumberOfGroupsForKHyperLogLogAggregations(true).setGenerateDomainFilters(false).setRewriteExpressionWithConstantVariable(true).setDefaultWriterReplicationCoefficient(3.0).setDefaultViewSecurityMode(CreateView.Security.DEFINER).setCteHeuristicReplicationThreshold(4).setUseHistograms(false).setLegacyJsonCast(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"cpu-cost-weight", (Object)"0.4").put((Object)"memory-cost-weight", (Object)"0.3").put((Object)"network-cost-weight", (Object)"0.2").put((Object)"experimental.iterative-optimizer-enabled", (Object)"false").put((Object)"experimental.iterative-optimizer-timeout", (Object)"10s").put((Object)"experimental.runtime-optimizer-enabled", (Object)"true").put((Object)"enable-dynamic-filtering", (Object)"true").put((Object)"dynamic-filtering-max-per-driver-row-count", (Object)"256").put((Object)"dynamic-filtering-max-per-driver-size", (Object)"64kB").put((Object)"dynamic-filtering-range-row-limit-per-driver", (Object)"1000").put((Object)"fragment-result-cache.enabled", (Object)"true").put((Object)"experimental.enable-stats-calculator", (Object)"false").put((Object)"experimental.enable-stats-collection-for-temporary-table", (Object)"true").put((Object)"optimizer.ignore-stats-calculator-failures", (Object)"false").put((Object)"print-stats-for-non-join-query", (Object)"true").put((Object)"optimizer.default-filter-factor-enabled", (Object)"true").put((Object)"deprecated.legacy-array-agg", (Object)"true").put((Object)"deprecated.legacy-log-function", (Object)"true").put((Object)"use-alternative-function-signatures", (Object)"true").put((Object)"deprecated.group-by-uses-equal", (Object)"true").put((Object)"deprecated.legacy-map-subscript", (Object)"true").put((Object)"reduce-agg-for-complex-types-enabled", (Object)"false").put((Object)"deprecated.legacy-row-field-ordinal-access", (Object)"true").put((Object)"deprecated.legacy-char-to-varchar-coercion", (Object)"true").put((Object)"distributed-index-joins-enabled", (Object)"true").put((Object)"join-distribution-type", (Object)"BROADCAST").put((Object)"join-max-broadcast-table-size", (Object)"42GB").put((Object)"optimizer.size-based-join-distribution-type-enabled", (Object)"false").put((Object)"grouped-execution-enabled", (Object)"false").put((Object)"recoverable-grouped-execution-enabled", (Object)"true").put((Object)"max-failed-task-percentage", (Object)"0.8").put((Object)"concurrent-lifespans-per-task", (Object)"1").put((Object)"fast-inequality-joins", (Object)"false").put((Object)"colocated-joins-enabled", (Object)"false").put((Object)"spatial-joins-enabled", (Object)"false").put((Object)"optimizer.join-reordering-strategy", (Object)"NONE").put((Object)"experimental.optimizer.partial-merge-pushdown-strategy", (Object)FeaturesConfig.PartialMergePushdownStrategy.PUSH_THROUGH_LOW_MEMORY_OPERATORS.name()).put((Object)"optimizer.max-reordered-joins", (Object)"5").put((Object)"optimizer.use-history-based-plan-statistics", (Object)"true").put((Object)"optimizer.track-history-based-plan-statistics", (Object)"true").put((Object)"optimizer.track-history-stats-from-failed-queries", (Object)"false").put((Object)"optimizer.use-partial-aggregation-history", (Object)"true").put((Object)"optimizer.track-partial-aggregation-history", (Object)"false").put((Object)"optimizer.use-perfectly-consistent-histories", (Object)"true").put((Object)"optimizer.history-canonical-plan-node-limit", (Object)"2").put((Object)"optimizer.history-based-optimizer-plan-canonicalization-strategies", (Object)"IGNORE_SAFE_CONSTANTS,IGNORE_SCAN_CONSTANTS").put((Object)"optimizer.log-plans-used-in-history-based-optimizer", (Object)"true").put((Object)"optimizer.history-based-optimizer-timeout", (Object)"1s").put((Object)"redistribute-writes", (Object)"false").put((Object)"scale-writers", (Object)"true").put((Object)"writer-min-size", (Object)"42GB").put((Object)"optimized-scale-writer-producer-buffer", (Object)"true").put((Object)"optimizer.optimize-metadata-queries", (Object)"true").put((Object)"optimizer.optimize-metadata-queries-ignore-stats", (Object)"true").put((Object)"optimizer.optimize-metadata-queries-call-threshold", (Object)"200").put((Object)"optimizer.optimize-hash-generation", (Object)"false").put((Object)"optimizer.optimize-mixed-distinct-aggregations", (Object)"true").put((Object)"optimizer.push-table-write-through-union", (Object)"false").put((Object)"optimizer.dictionary-aggregation", (Object)"true").put((Object)"optimizer.push-aggregation-through-join", (Object)"false").put((Object)"optimizer.aggregation-partition-merging", (Object)"top_down").put((Object)"regex-library", (Object)"RE2J").put((Object)"re2j.dfa-states-limit", (Object)"42").put((Object)"re2j.dfa-retries", (Object)"42").put((Object)"experimental.spill-enabled", (Object)"true").put((Object)"experimental.join-spill-enabled", (Object)"false").put((Object)"experimental.aggregation-spill-enabled", (Object)"false").put((Object)"experimental.distinct-aggregation-spill-enabled", (Object)"false").put((Object)"experimental.dedup-based-distinct-aggregation-spill-enabled", (Object)"true").put((Object)"experimental.distinct-aggregation-large-block-spill-enabled", (Object)"true").put((Object)"experimental.distinct-aggregation-large-block-size-threshold", (Object)"10MB").put((Object)"experimental.order-by-aggregation-spill-enabled", (Object)"false").put((Object)"experimental.window-spill-enabled", (Object)"false").put((Object)"experimental.order-by-spill-enabled", (Object)"false").put((Object)"experimental.topn-spill-enabled", (Object)"false").put((Object)"experimental.aggregation-operator-unspill-memory-limit", (Object)"100MB").put((Object)"experimental.topn-operator-unspill-memory-limit", (Object)"100MB").put((Object)"experimental.spiller-spill-path", (Object)"/tmp/custom/spill/path1,/tmp/custom/spill/path2").put((Object)"experimental.spiller-threads", (Object)"42").put((Object)"experimental.spiller-max-used-space-threshold", (Object)"0.8").put((Object)"experimental.memory-revoking-threshold", (Object)"0.2").put((Object)"experimental.memory-revoking-target", (Object)"0.8").put((Object)"experimental.spiller.task-spilling-strategy", (Object)"PER_TASK_MEMORY_THRESHOLD").put((Object)"experimental.query-limit-spill-enabled", (Object)"true").put((Object)"experimental.spiller.single-stream-spiller-choice", (Object)"TEMP_STORAGE").put((Object)"experimental.spiller.spiller-temp-storage", (Object)"crail").put((Object)"experimental.spiller.max-revocable-task-memory", (Object)"1GB").put((Object)"exchange.compression-enabled", (Object)"true").put((Object)"exchange.checksum-enabled", (Object)"true").put((Object)"deprecated.legacy-timestamp", (Object)"false").put((Object)"optimizer.enable-intermediate-aggregations", (Object)"true").put((Object)"parse-decimal-literals-as-double", (Object)"true").put((Object)"optimizer.force-single-node-output", (Object)"false").put((Object)"pages-index.eager-compaction-enabled", (Object)"true").put((Object)"experimental.filter-and-project-min-output-page-size", (Object)"1MB").put((Object)"experimental.filter-and-project-min-output-page-row-count", (Object)"2048").put((Object)"histogram.implementation", (Object)"LEGACY").put((Object)"arrayagg.implementation", (Object)"LEGACY").put((Object)"multimapagg.implementation", (Object)"LEGACY").put((Object)"optimizer.use-mark-distinct", (Object)"false").put((Object)"optimizer.exploit-constraints", (Object)"false").put((Object)"optimizer.prefer-partial-aggregation", (Object)"false").put((Object)"optimizer.partial-aggregation-strategy", (Object)"automatic").put((Object)"optimizer.partial-aggregation-byte-reduction-threshold", (Object)"0.8").put((Object)"experimental.adaptive-partial-aggregation", (Object)"true").put((Object)"experimental.adaptive-partial-aggregation-rows-reduction-ratio-threshold", (Object)"0.9").put((Object)"optimizer.optimize-top-n-row-number", (Object)"false").put((Object)"optimizer.optimize-case-expression-predicate", (Object)"true").put((Object)"distributed-sort", (Object)"false").put((Object)"analyzer.max-grouping-sets", (Object)"2047").put((Object)"deprecated.legacy-unnest-array-rows", (Object)"true").put((Object)"experimental.json-serde-codegen-enabled", (Object)"true").put((Object)"optimizer.push-limit-through-outer-join", (Object)"false").put((Object)"optimizer.optimize-constant-grouping-keys", (Object)"false").put((Object)"max-concurrent-materializations", (Object)"5").put((Object)"experimental.pushdown-subfields-enabled", (Object)"true").put((Object)"pushdown-subfields-from-lambda-enabled", (Object)"true").put((Object)"experimental.pushdown-dereference-enabled", (Object)"true").put((Object)"experimental.table-writer-merge-operator-enabled", (Object)"false").put((Object)"index-loader-timeout", (Object)"10s").put((Object)"experimental.optimized-repartitioning", (Object)"true").put((Object)"list-built-in-functions-only", (Object)"false").put((Object)"partitioning-precision-strategy", (Object)"PREFER_EXACT_PARTITIONING").put((Object)"experimental-functions-enabled", (Object)"true").put((Object)"optimize-common-sub-expressions", (Object)"false").put((Object)"prefer-distributed-union", (Object)"false").put((Object)"optimize-nulls-in-join", (Object)"true").put((Object)"optimize-payload-joins", (Object)"true").put((Object)"optimizer.joins-not-null-inference-strategy", (Object)"USE_FUNCTION_METADATA").put((Object)"warn-on-no-table-layout-filter", (Object)"ry@nlikestheyankees,ds").put((Object)"inline-sql-functions", (Object)"false").put((Object)"check-access-control-on-utilized-columns-only", (Object)"true").put((Object)"check-access-control-with-subfields", (Object)"true").put((Object)"optimizer.skip-redundant-sort", (Object)"false").put((Object)"is-allow-window-order-by-literals", (Object)"false").put((Object)"enforce-fixed-distribution-for-output-operator", (Object)"true").put((Object)"optimizer.optimize-joins-with-empty-sources", (Object)"true").put((Object)"log-formatted-query-enabled", (Object)"true").put((Object)"log-invoked-function-names-enabled", (Object)"true").put((Object)"spooling-output-buffer-enabled", (Object)"true").put((Object)"spooling-output-buffer-threshold", (Object)"16MB").put((Object)"spooling-output-buffer-temp-storage", (Object)"tempfs").put((Object)"spark.assign-bucket-to-partition-for-partitioned-table-write-enabled", (Object)"true").put((Object)"partial-results-enabled", (Object)"true").put((Object)"partial-results-completion-ratio-threshold", (Object)"0.9").put((Object)"partial-results-max-execution-time-multiplier", (Object)"1.5").put((Object)"offset-clause-enabled", (Object)"true").put((Object)"materialized-view-data-consistency-enabled", (Object)"false").put((Object)"consider-query-filters-for-materialized-view-partitions", (Object)"false").put((Object)"query-optimization-with-materialized-view-enabled", (Object)"true").put((Object)"analyzer-type", (Object)"CRUX").put((Object)"pre-process-metadata-calls", (Object)"true").put((Object)"verbose-runtime-stats-enabled", (Object)"true").put((Object)"optimizer.aggregation-if-to-filter-rewrite-strategy", (Object)"filter_with_if").put((Object)"streaming-for-partial-aggregation-enabled", (Object)"true").put((Object)"execution-policy.max-stage-count-for-eager-scheduling", (Object)"123").put((Object)"hyperloglog-standard-error-warning-threshold", (Object)"0.02").put((Object)"optimizer.prefer-merge-join-for-sorted-inputs", (Object)"true").put((Object)"optimizer.segmented-aggregation-enabled", (Object)"true").put((Object)"planner.query-analyzer-timeout", (Object)"10s").put((Object)"optimizer.quick-distinct-limit-enabled", (Object)"true").put((Object)"optimizer.push-remote-exchange-through-group-id", (Object)"true").put((Object)"optimizer.optimize-multiple-approx-percentile-on-same-field", (Object)"false").put((Object)"native-execution-enabled", (Object)"true").put((Object)"native-execution-executable-path", (Object)"/bin/echo").put((Object)"native-execution-program-arguments", (Object)"--v 1").put((Object)"native-execution-process-reuse-enabled", (Object)"false").put((Object)"optimizer.randomize-outer-join-null-key", (Object)"true").put((Object)"optimizer.randomize-outer-join-null-key-strategy", (Object)"key_from_outer_join").put((Object)"optimizer.sharded-join-strategy", (Object)"cost_based").put((Object)"optimizer.join-shard-count", (Object)"200").put((Object)"optimizer.optimize-conditional-aggregation-enabled", (Object)"true").put((Object)"optimizer.remove-redundant-distinct-aggregation-enabled", (Object)"false").put((Object)"optimizer.in-predicates-as-inner-joins-enabled", (Object)"true").put((Object)"optimizer.push-aggregation-below-join-byte-reduction-threshold", (Object)"0.9").put((Object)"optimizer.prefilter-for-groupby-limit", (Object)"true").put((Object)"field-names-in-json-cast-enabled", (Object)"true").put((Object)"legacy-json-cast", (Object)"false").put((Object)"optimizer.optimize-probe-for-empty-build-runtime", (Object)"true").put((Object)"optimizer.use-defaults-for-correlated-aggregation-pushdown-through-outer-joins", (Object)"false").put((Object)"optimizer.merge-duplicate-aggregations", (Object)"false").put((Object)"optimizer.merge-aggregations-with-and-without-filter", (Object)"true").put((Object)"optimizer.simplify-plan-with-empty-input", (Object)"false").put((Object)"optimizer.push-down-filter-expression-evaluation-through-cross-join", (Object)"DISABLED").put((Object)"optimizer.rewrite-cross-join-with-or-filter-to-inner-join", (Object)"false").put((Object)"optimizer.rewrite-cross-join-with-array-contains-filter-to-inner-join", (Object)"false").put((Object)"optimizer.left-join-with-array-contains-to-equi-join-strategy", (Object)"ALWAYS_ENABLED").put((Object)"optimizer.rewrite-cross-join-with-array-not-contains-filter-to-anti-join", (Object)"false").put((Object)"optimizer.default-join-selectivity-coefficient", (Object)"0.5").put((Object)"optimizer.rewrite-left-join-with-null-filter-to-semi-join", (Object)"false").put((Object)"experimental.optimizer.broadcast-join-with-small-build-unknown-probe", (Object)"true").put((Object)"optimizer.add-partial-node-for-row-number-with-limit", (Object)"false").put((Object)"optimizer.infer-inequality-predicates", (Object)"true").put((Object)"optimizer.pull-up-expression-from-lambda", (Object)"true").put((Object)"optimizer.rewrite-constant-array-contains-to-in", (Object)"true").put((Object)"optimizer.use-hbo-for-scaled-writers", (Object)"true").put((Object)"optimizer.remove-redundant-cast-to-varchar-in-join", (Object)"false").put((Object)"cte-materialization-strategy", (Object)"ALL").put((Object)"cte-filter-and-projection-pushdown-enabled", (Object)"false").put((Object)"optimizer.handle-complex-equi-joins", (Object)"true").put((Object)"optimizer.skip-hash-generation-for-join-with-table-scan-input", (Object)"true").put((Object)"khyperloglog-agg-group-limit", (Object)"1000").put((Object)"limit-khyperloglog-agg-group-number-enabled", (Object)"false").put((Object)"optimizer.generate-domain-filters", (Object)"true").put((Object)"optimizer.rewrite-expression-with-constant-variable", (Object)"false").put((Object)"optimizer.default-writer-replication-coefficient", (Object)"5.0").put((Object)"default-view-security-mode", (Object)CreateView.Security.INVOKER.name()).put((Object)"cte-heuristic-replication-threshold", (Object)"2").put((Object)"optimizer.use-histograms", (Object)"true").build();
        FeaturesConfig expected = new FeaturesConfig().setCpuCostWeight(0.4).setMemoryCostWeight(0.3).setNetworkCostWeight(0.2).setIterativeOptimizerEnabled(false).setIterativeOptimizerTimeout(new Duration(10.0, TimeUnit.SECONDS)).setRuntimeOptimizerEnabled(true).setEnableDynamicFiltering(true).setDynamicFilteringMaxPerDriverRowCount(256).setDynamicFilteringMaxPerDriverSize(new DataSize(64.0, DataSize.Unit.KILOBYTE)).setDynamicFilteringRangeRowLimitPerDriver(1000).setFragmentResultCachingEnabled(true).setEnableStatsCalculator(false).setEnableStatsCollectionForTemporaryTable(true).setIgnoreStatsCalculatorFailures(false).setPrintStatsForNonJoinQuery(true).setDistributedIndexJoinsEnabled(true).setJoinDistributionType(FeaturesConfig.JoinDistributionType.BROADCAST).setJoinMaxBroadcastTableSize(new DataSize(42.0, DataSize.Unit.GIGABYTE)).setSizeBasedJoinDistributionTypeEnabled(false).setGroupedExecutionEnabled(false).setRecoverableGroupedExecutionEnabled(true).setMaxFailedTaskPercentage(0.8).setConcurrentLifespansPerTask(1).setFastInequalityJoins(false).setColocatedJoinsEnabled(false).setSpatialJoinsEnabled(false).setJoinReorderingStrategy(FeaturesConfig.JoinReorderingStrategy.NONE).setPartialMergePushdownStrategy(FeaturesConfig.PartialMergePushdownStrategy.PUSH_THROUGH_LOW_MEMORY_OPERATORS).setMaxReorderedJoins(5).setUseHistoryBasedPlanStatistics(true).setTrackHistoryBasedPlanStatistics(true).setTrackHistoryStatsFromFailedQuery(false).setUsePartialAggregationHistory(true).setTrackPartialAggregationHistory(false).setUsePerfectlyConsistentHistories(true).setHistoryCanonicalPlanNodeLimit(2).setHistoryBasedOptimizerTimeout(new Duration(1.0, TimeUnit.SECONDS)).setHistoryBasedOptimizerPlanCanonicalizationStrategies("IGNORE_SAFE_CONSTANTS,IGNORE_SCAN_CONSTANTS").setLogPlansUsedInHistoryBasedOptimizer(true).setRedistributeWrites(false).setScaleWriters(true).setWriterMinSize(new DataSize(42.0, DataSize.Unit.GIGABYTE)).setOptimizedScaleWriterProducerBuffer(true).setOptimizeMetadataQueries(true).setOptimizeMetadataQueriesIgnoreStats(true).setOptimizeMetadataQueriesCallThreshold(200).setOptimizeHashGeneration(false).setOptimizeMixedDistinctAggregations(true).setPushTableWriteThroughUnion(false).setDictionaryAggregation(true).setAggregationPartitioningMergingStrategy(FeaturesConfig.AggregationPartitioningMergingStrategy.TOP_DOWN).setPushAggregationThroughJoin(false).setLegacyArrayAgg(true).setUseAlternativeFunctionSignatures(true).setGroupByUsesEqualTo(true).setLegacyMapSubscript(true).setReduceAggForComplexTypesEnabled(false).setRegexLibrary(RegexLibrary.RE2J).setRe2JDfaStatesLimit(42).setRe2JDfaRetries(42).setSpillEnabled(true).setJoinSpillingEnabled(false).setAggregationSpillEnabled(false).setDistinctAggregationSpillEnabled(false).setDedupBasedDistinctAggregationSpillEnabled(true).setDistinctAggregationLargeBlockSpillEnabled(true).setDistinctAggregationLargeBlockSizeThreshold(DataSize.valueOf((String)"10MB")).setOrderByAggregationSpillEnabled(false).setWindowSpillEnabled(false).setOrderBySpillEnabled(false).setTopNSpillEnabled(false).setAggregationOperatorUnspillMemoryLimit(DataSize.valueOf((String)"100MB")).setTopNOperatorUnspillMemoryLimit(DataSize.valueOf((String)"100MB")).setSpillerSpillPaths("/tmp/custom/spill/path1,/tmp/custom/spill/path2").setSpillerThreads(42).setSpillMaxUsedSpaceThreshold(0.8).setMemoryRevokingThreshold(0.2).setMemoryRevokingTarget(0.8).setTaskSpillingStrategy(FeaturesConfig.TaskSpillingStrategy.PER_TASK_MEMORY_THRESHOLD).setQueryLimitSpillEnabled(true).setSingleStreamSpillerChoice(FeaturesConfig.SingleStreamSpillerChoice.TEMP_STORAGE).setSpillerTempStorage("crail").setMaxRevocableMemoryPerTask(new DataSize(1.0, DataSize.Unit.GIGABYTE)).setLegacyLogFunction(true).setExchangeCompressionEnabled(true).setExchangeChecksumEnabled(true).setLegacyTimestamp(false).setLegacyRowFieldOrdinalAccess(true).setLegacyCharToVarcharCoercion(true).setEnableIntermediateAggregations(true).setParseDecimalLiteralsAsDouble(true).setForceSingleNodeOutput(false).setPagesIndexEagerCompactionEnabled(true).setFilterAndProjectMinOutputPageSize(new DataSize(1.0, DataSize.Unit.MEGABYTE)).setFilterAndProjectMinOutputPageRowCount(2048).setUseMarkDistinct(false).setExploitConstraints(false).setPreferPartialAggregation(false).setPartialAggregationStrategy(FeaturesConfig.PartialAggregationStrategy.AUTOMATIC).setPartialAggregationByteReductionThreshold(0.8).setAdaptivePartialAggregationEnabled(true).setAdaptivePartialAggregationRowsReductionRatioThreshold(0.9).setOptimizeTopNRowNumber(false).setOptimizeCaseExpressionPredicate(true).setHistogramGroupImplementation(HistogramGroupImplementation.LEGACY).setArrayAggGroupImplementation(ArrayAggGroupImplementation.LEGACY).setMultimapAggGroupImplementation(MultimapAggGroupImplementation.LEGACY).setDistributedSortEnabled(false).setMaxGroupingSets(2047).setLegacyUnnestArrayRows(true).setDefaultFilterFactorEnabled(true).setJsonSerdeCodeGenerationEnabled(true).setPushLimitThroughOuterJoin(false).setOptimizeConstantGroupingKeys(false).setMaxConcurrentMaterializations(5).setPushdownSubfieldsEnabled(true).setPushdownSubfieldsFromLambdaEnabled(true).setPushdownDereferenceEnabled(true).setTableWriterMergeOperatorEnabled(false).setIndexLoaderTimeout(new Duration(10.0, TimeUnit.SECONDS)).setOptimizedRepartitioningEnabled(true).setListBuiltInFunctionsOnly(false).setPartitioningPrecisionStrategy(FeaturesConfig.PartitioningPrecisionStrategy.PREFER_EXACT_PARTITIONING).setExperimentalFunctionsEnabled(true).setOptimizeCommonSubExpressions(false).setPreferDistributedUnion(false).setOptimizeNullsInJoin(true).setOptimizePayloadJoins(true).setJoinsNotNullInferenceStrategy(FeaturesConfig.JoinNotNullInferenceStrategy.USE_FUNCTION_METADATA).setSkipRedundantSort(false).setWarnOnNoTableLayoutFilter("ry@nlikestheyankees,ds").setInlineSqlFunctions(false).setCheckAccessControlOnUtilizedColumnsOnly(true).setCheckAccessControlWithSubfields(true).setSkipRedundantSort(false).setAllowWindowOrderByLiterals(false).setEnforceFixedDistributionForOutputOperator(true).setEmptyJoinOptimization(true).setLogFormattedQueryEnabled(true).setLogInvokedFunctionNamesEnabled(true).setSpoolingOutputBufferEnabled(true).setSpoolingOutputBufferThreshold(new DataSize(16.0, DataSize.Unit.MEGABYTE)).setSpoolingOutputBufferTempStorage("tempfs").setPrestoSparkAssignBucketToPartitionForPartitionedTableWriteEnabled(true).setPartialResultsEnabled(true).setPartialResultsCompletionRatioThreshold(0.9).setOffsetClauseEnabled(true).setPartialResultsMaxExecutionTimeMultiplier(1.5).setMaterializedViewDataConsistencyEnabled(false).setMaterializedViewPartitionFilteringEnabled(false).setQueryOptimizationWithMaterializedViewEnabled(true).setVerboseRuntimeStatsEnabled(true).setAggregationIfToFilterRewriteStrategy(FeaturesConfig.AggregationIfToFilterRewriteStrategy.FILTER_WITH_IF).setAnalyzerType("CRUX").setPreProcessMetadataCalls(true).setStreamingForPartialAggregationEnabled(true).setMaxStageCountForEagerScheduling(123).setHyperloglogStandardErrorWarningThreshold(0.02).setPreferMergeJoinForSortedInputs(true).setSegmentedAggregationEnabled(true).setQueryAnalyzerTimeout(new Duration(10.0, TimeUnit.SECONDS)).setQuickDistinctLimitEnabled(true).setPushRemoteExchangeThroughGroupId(true).setOptimizeMultipleApproxPercentileOnSameFieldEnabled(false).setNativeExecutionEnabled(true).setNativeExecutionExecutablePath("/bin/echo").setNativeExecutionProgramArguments("--v 1").setNativeExecutionProcessReuseEnabled(false).setRandomizeOuterJoinNullKeyEnabled(true).setRandomizeOuterJoinNullKeyStrategy(FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.KEY_FROM_OUTER_JOIN).setShardedJoinStrategy(FeaturesConfig.ShardedJoinStrategy.COST_BASED).setJoinShardCount(200).setOptimizeConditionalAggregationEnabled(true).setRemoveRedundantDistinctAggregationEnabled(false).setInPredicatesAsInnerJoinsEnabled(true).setPushAggregationBelowJoinByteReductionThreshold(0.9).setPrefilterForGroupbyLimit(true).setOptimizeJoinProbeForEmptyBuildRuntimeEnabled(true).setFieldNamesInJsonCastEnabled(true).setUseDefaultsForCorrelatedAggregationPushdownThroughOuterJoins(false).setMergeDuplicateAggregationsEnabled(false).setMergeAggregationsWithAndWithoutFilter(true).setSimplifyPlanWithEmptyInput(false).setDefaultJoinSelectivityCoefficient(0.5).setPushDownFilterExpressionEvaluationThroughCrossJoin(FeaturesConfig.PushDownFilterThroughCrossJoinStrategy.DISABLED).setRewriteCrossJoinWithOrFilterToInnerJoin(false).setRewriteCrossJoinWithArrayContainsFilterToInnerJoin(false).setLeftJoinWithArrayContainsToEquiJoinStrategy(FeaturesConfig.LeftJoinArrayContainsToInnerJoinStrategy.ALWAYS_ENABLED).setRewriteCrossJoinWithArrayNotContainsFilterToAntiJoin(false).setLeftJoinNullFilterToSemiJoin(false).setBroadcastJoinWithSmallBuildUnknownProbe(true).setAddPartialNodeForRowNumberWithLimitEnabled(false).setInferInequalityPredicates(true).setPullUpExpressionFromLambdaEnabled(true).setRewriteConstantArrayContainsToInEnabled(true).setUseHBOForScaledWriters(true).setRemoveRedundantCastToVarcharInJoin(false).setHandleComplexEquiJoins(true).setSkipHashGenerationForJoinWithTableScanInput(true).setCteMaterializationStrategy(FeaturesConfig.CteMaterializationStrategy.ALL).setCteFilterAndProjectionPushdownEnabled(false).setKHyperLogLogAggregationGroupNumberLimit(1000L).setLimitNumberOfGroupsForKHyperLogLogAggregations(false).setGenerateDomainFilters(true).setRewriteExpressionWithConstantVariable(false).setDefaultWriterReplicationCoefficient(5.0).setDefaultViewSecurityMode(CreateView.Security.INVOKER).setCteHeuristicReplicationThreshold(2).setUseHistograms(true).setLegacyJsonCast(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp=".*\\Qexperimental.spiller-spill-path must be configured when experimental.spill-enabled is set to true\\E.*")
    public void testValidateSpillConfiguredIfEnabled() {
        new ConfigurationFactory((Map)ImmutableMap.of((Object)"experimental.spill-enabled", (Object)"true")).build(FeaturesConfig.class);
    }
}

