/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.spi.MaterializedViewDefinition;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.AbstractAnalyzerTest;
import com.facebook.presto.sql.analyzer.MaterializedViewQueryOptimizer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.relational.RowExpressionDomainTranslator;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.AnalyzerUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestMaterializedViewQueryOptimizer
extends AbstractAnalyzerTest {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final String BASE_TABLE_1 = "t1";
    private static final String BASE_TABLE_2 = "t2";
    private static final String BASE_TABLE_3 = "t3";
    private static final String BASE_TABLE_6 = "t6";
    private static final String BASE_TABLE_7 = "t7";
    private static final String VIEW_1 = "view_1";
    private static final String VIEW_2 = "view_2";
    private static final String VIEW_3 = "view_3";
    private static final String SESSION_SCHEMA = "s1";
    private RowExpressionDomainTranslator domainTranslator;
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("s1").setSystemProperty("parse_decimal_literals_as_double", "true").build();

    @BeforeClass
    public void setupDomainTranslator() {
        this.domainTranslator = new RowExpressionDomainTranslator(this.metadata);
    }

    @Test
    public void testWithSimpleQuery() {
        String originalViewSql = String.format("SELECT a, b FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, b FROM %s", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT a, b FROM %s", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testWithDistinct() {
        String originalViewSql = String.format("SELECT DISTINCT a, b FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT DISTINCT a, b FROM %s", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT DISTINCT a, b FROM %s", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT DISTINCT a, b FROM %s", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT DISTINCT a, b FROM %s", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT DISTINCT a, b FROM %s", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b FROM %s", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testWithAlias() {
        String originalViewSql = String.format("SELECT a as mv_a, b, c as mv_c FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, b, c FROM %s", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT mv_a as a, b, mv_c as c FROM %s", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a as mv_a, b, c as mv_c, d FROM %s", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a as result_a, b as result_b, c, d FROM %s", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT mv_a as result_a, b as result_b, mv_c as c, d FROM %s", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a as b, b as a FROM %s", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b FROM %s", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT b as a, a as b FROM %s", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testWithAllColumnsSelect() {
        String originalViewSql = String.format("SELECT * FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT * FROM %s", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testWithBaseQueryGroupBy() {
        String originalViewSql = String.format("SELECT a as mv_a, b, c as mv_c FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT SUM(a * b), MAX(a + b), c FROM %s GROUP BY c", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT SUM(mv_a * b), MAX(mv_a + b), mv_c as c FROM %s GROUP BY mv_c", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testWithDerivedFields() {
        String originalViewSql = String.format("SELECT SUM(a * b + c) as mv_sum, MAX(a * b + c) as mv_max, d, e FROM %s GROUP BY d, e", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT SUM(a * b + c), MAX(a * b + c), d, e FROM %s GROUP BY d, e", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT SUM(mv_sum), MAX(mv_max), d, e FROM %s GROUP BY d, e", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT SUM(a * b + c) as mv_sum, MAX(a * b + c) as mv_max, d as mv_d, e FROM %s GROUP BY d, e", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT SUM(a * b + c) as sum_of_abc, MAX(a * b + c) as max_of_abc, d, e FROM %s GROUP BY d, e", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT SUM(mv_sum) as sum_of_abc, MAX(mv_max) as max_of_abc, mv_d as d, e FROM %s GROUP BY mv_d, e", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testWithCount() {
        String originalViewSql = String.format("SELECT COUNT(a) as a_count, COUNT(b, c) as bc_count FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT COUNT(a), COUNT(b, c) FROM %s", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT SUM(a_count), SUM(bc_count) FROM %s", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testWithCountDistinct() {
        String originalViewSql = String.format("SELECT COUNT((a)) as a_count, COUNT(b, c) as bc_count FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT COUNT(DISTINCT(a)), COUNT(b, c) FROM %s", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT COUNT(DISTINCT(a)) as a_count, COUNT(b, c) as bc_count FROM %s", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT COUNT(DISTINCT(a)), COUNT(b, c) FROM %s", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testWithArithmeticBinary() {
        String originalViewSql = String.format("SELECT a, b, c FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a + b, a * b - c FROM %s", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT a + b, a * b - c FROM %s", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a as mv_a, b, c as mv_c, d FROM %s", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a + b, c / d, a * c - b * d FROM %s", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT mv_a + b, mv_c / d, mv_a * mv_c - b * d FROM %s", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testWithWhereCondition() {
        String originalViewSql = String.format("SELECT a, b, c, d FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, b FROM %s WHERE a < 10 AND c > 10 or d = 123", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT a, b FROM %s WHERE a < 10 AND c > 10 or d = 123", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a as mv_a, b, c, d as mv_d FROM %s", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE a < 10 AND c > 10 or d = 456", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT mv_a as a, b FROM %s WHERE mv_a < 10 AND c > 10 or mv_d = 456", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testMismatchingColumnTypes() {
        String originalViewSql = String.format("SELECT a, b, c, d FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, b FROM %s WHERE a < 10 AND c > 10 or d = '2000-01-01'", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testColumnsNotInTable() {
        String originalViewSql = String.format("SELECT  a, b, c, d, not_a_column FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, c, not_a_column FROM %s WHERE a > 5 OR IF(b > 4, c, 2) = not_a_column AND d IN (1, 2, 3) AND NOT (a IS NULL)", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testWithOrderBy() {
        String originalViewSql = String.format("SELECT a, b, c FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, b, c FROM %s ORDER BY c ASC, b DESC, a", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT a, b, c FROM %s ORDER BY c ASC, b DESC, a", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a as mv_a, b, c as mv_c FROM %s", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s ORDER BY c ASC, b DESC, a", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT mv_a as a, b, mv_c as c FROM %s ORDER BY mv_c ASC, b DESC, mv_a", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a as mv_a, b, c as mv_c FROM %s", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s ORDER BY c ASC, b DESC, a", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT mv_a as a, b, mv_c as c FROM %s ORDER BY mv_c ASC, b DESC, mv_a", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT MAX(a) as mv_max_a, b FROM %s GROUP BY b", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT MAX(a), b FROM %s GROUP BY b ORDER BY MAX(a) DESC, b ASC", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT MAX(mv_max_a), b FROM %s GROUP BY b ORDER BY MAX(mv_max_a) DESC, b ASC", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testWithNoMatchingBaseTable() {
        String originalViewSql = String.format("SELECT a, b FROM %s", BASE_TABLE_2);
        String baseQuerySql = String.format("SELECT a, b FROM %s", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testWithNoMatchingColumnNames() {
        String originalViewSql = String.format("SELECT a, b, c FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT c, d FROM %s", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, c FROM %s WHERE d = 5", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testWithDifferentFilterCondition() {
        String originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a = 5 OR b = 3", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, c FROM %s WHERE a = 5 OR b = 4", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a = 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, c FROM %s", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testIdentifiersInDifferentNodes() {
        String originalViewSql = String.format("SELECT a, b, c, d FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, c FROM %s WHERE a > 5 OR IF(b > 4, c, 2) = 7 AND d IN (1, 2, 3) AND NOT (a IS NULL)", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT a, c FROM %s WHERE a > 5 OR IF(b > 4, c, 2) = 7 AND d IN (1, 2, 3) AND NOT (a IS NULL)", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        baseQuerySql = String.format("SELECT a, c FROM %s WHERE x = 4", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        baseQuerySql = String.format("SELECT a, c FROM %s WHERE NOT(x IS NULL)", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        baseQuerySql = String.format("SELECT a, c FROM %s WHERE NOT(x IN (4, 5))", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        baseQuerySql = String.format("SELECT a, c FROM %s WHERE IF(a > 2, IF(x > 0, 1, -1), 2) = 0", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testWithGroupBy() {
        String originalViewSql = String.format("SELECT SUM(a) AS a, SUM(b*c) AS bc, d, e FROM %s GROUP BY d, e", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT SUM(a) FROM %s", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT SUM(a) FROM %s", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        baseQuerySql = String.format("SELECT SUM(b*c) FROM %s WHERE d > 10", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT SUM(bc) FROM %s WHERE d > 10", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        baseQuerySql = String.format("SELECT SUM(a), d FROM %s GROUP BY d", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT SUM(a), d FROM %s GROUP BY d", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        baseQuerySql = String.format("SELECT SUM(a), SUM(b*c), d FROM %s GROUP BY d", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT SUM(a), SUM(bc), d FROM %s GROUP BY d", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        baseQuerySql = String.format("SELECT SUM(a), SUM(b*c), d, e FROM %s GROUP BY d, e", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT SUM(a), SUM(bc), d, e FROM %s GROUP BY d, e", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        baseQuerySql = String.format("SELECT SUM(d) FROM %s GROUP BY e", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT SUM(d) FROM %s GROUP BY e", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        baseQuerySql = String.format("SELECT d, e FROM %s", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        baseQuerySql = String.format("SELECT SUM(a) FROM %s WHERE x > 10", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        baseQuerySql = String.format("SELECT SUM(a), x FROM %s GROUP BY x", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        baseQuerySql = String.format("SELECT SUM(a) FROM %s WHERE f IN (1, 2)", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        baseQuerySql = String.format("SELECT SUM(a) FROM %s WHERE IF(f, 1, 0) = 1", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        baseQuerySql = String.format("SELECT MAX(sum_a) FROM (SELECT SUM(a) sum_a, d, e, %s GROUP BY d, e)", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT SUM(a) AS a, b FROM %s GROUP BY c", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT SUM(a) FROM %s GROUP BY c", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT SUM(a) AS a, c FROM %s WHERE b > 0 GROUP BY c", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT SUM(a) FROM %s GROUP BY c", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testWithMissingColumnInOrderBy() {
        String originalViewSql = String.format("SELECT a, b, c FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, c FROM %s ORDER BY b DESC, d", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testWithLimitClause() {
        String originalViewSql = String.format("SELECT a, b, c FROM %s LIMIT 5", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, c FROM %s", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testWithUnsupportedFunction() {
        String originalViewSql = String.format("SELECT GEOMETRIC_MEAN(a) FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT GEOMETRIC_MEAN(a) FROM %s", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a FROM %s", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT GEOMETRIC_MEAN(a) FROM %s", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testAssociativeRewriteOfNonAssociativeFunctions() {
        String originalViewSql = String.format("SELECT AVG(a) FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT AVG(a) FROM %s", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT APPROX_DISTINCT(a) FROM %s", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT APPROX_DISTINCT(a) FROM %s", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testWithTableAlias() {
        String originalViewSql = String.format("SELECT a, b, c FROM %s ORDER BY a, c", BASE_TABLE_1);
        String originalViewSqlWithAliasPartially = String.format("SELECT base1.a, b, c FROM %s base1 ORDER BY base1.a, c", BASE_TABLE_1);
        String originalViewSqlWithAliasFully = String.format("SELECT base1.a, base1.b, base1.c FROM %s base1 ORDER BY base1.a, base1.c", BASE_TABLE_1);
        String originalViewSqlWithTablePrefix = String.format("SELECT %s.a, b, %s.c FROM %s ORDER BY %s.a, %s.c", BASE_TABLE_1, BASE_TABLE_1, BASE_TABLE_1, BASE_TABLE_1, BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, c FROM %s ORDER BY c, a", BASE_TABLE_1);
        String baseQuerySqlWithAliasPartially1 = String.format("SELECT base1.a, c FROM %s base1 ORDER BY c, base1.a", BASE_TABLE_1);
        String baseQuerySqlWithAliasPartially2 = String.format("SELECT a, base1.c FROM %s base1 ORDER BY base1.c, a", BASE_TABLE_1);
        String baseQuerySqlFully = String.format("SELECT base1.a, base1.c FROM %s base1 ORDER BY base1.c, base1.a", BASE_TABLE_1);
        String baseQuerySqlWithTablePrefix = String.format("SELECT %s.a, %s.c FROM %s ORDER BY %s.c, %s.a", BASE_TABLE_1, BASE_TABLE_1, BASE_TABLE_1, BASE_TABLE_1, BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT a, c FROM %s ORDER BY c, a", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithAliasPartially1, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithAliasPartially2, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlFully, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithTablePrefix, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSqlWithAliasPartially, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithAliasPartially1, expectedRewrittenSql, originalViewSqlWithAliasPartially, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithAliasPartially2, expectedRewrittenSql, originalViewSqlWithAliasPartially, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlFully, expectedRewrittenSql, originalViewSqlWithAliasPartially, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithTablePrefix, expectedRewrittenSql, originalViewSqlWithAliasPartially, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSqlWithAliasFully, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithAliasPartially1, expectedRewrittenSql, originalViewSqlWithAliasFully, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithAliasPartially2, expectedRewrittenSql, originalViewSqlWithAliasFully, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlFully, expectedRewrittenSql, originalViewSqlWithAliasFully, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithTablePrefix, expectedRewrittenSql, originalViewSqlWithAliasFully, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSqlWithTablePrefix, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithAliasPartially1, expectedRewrittenSql, originalViewSqlWithTablePrefix, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithAliasPartially2, expectedRewrittenSql, originalViewSqlWithTablePrefix, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlFully, expectedRewrittenSql, originalViewSqlWithTablePrefix, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithTablePrefix, expectedRewrittenSql, originalViewSqlWithTablePrefix, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testAggregationWithTableAlias() {
        String originalViewSql = String.format("SELECT SUM(a) AS sum_a, b FROM %s GROUP BY b", BASE_TABLE_1);
        String originalViewSqlWithAliasPartially1 = String.format("SELECT SUM(base1.a) AS sum_a, b FROM %s base1 GROUP BY b", BASE_TABLE_1);
        String originalViewSqlWithAliasPartially2 = String.format("SELECT SUM(a) AS sum_a, base1.b FROM %s base1 GROUP BY base1.b", BASE_TABLE_1);
        String originalViewSqlWithAliasFully = String.format("SELECT SUM(base1.a) AS sum_a, base1.b FROM %s base1 GROUP BY base1.b", BASE_TABLE_1);
        String originalViewSqlWithTablePrefix = String.format("SELECT SUM(%s.a) AS sum_a, %s.b FROM %s GROUP BY %s.b", BASE_TABLE_1, BASE_TABLE_1, BASE_TABLE_1, BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT SUM(a) AS sum_of_a, b FROM %s GROUP BY b", BASE_TABLE_1);
        String baseQuerySqlWithAliasPartially1 = String.format("SELECT SUM(base1.a) AS sum_of_a, b FROM %s base1 GROUP BY b", BASE_TABLE_1);
        String baseQuerySqlWithAliasPartially2 = String.format("SELECT SUM(a) AS sum_of_a, base1.b FROM %s base1 GROUP BY base1.b", BASE_TABLE_1);
        String baseQuerySqlFully = String.format("SELECT SUM(base1.a) AS sum_of_a, base1.b FROM %s base1 GROUP BY base1.b", BASE_TABLE_1);
        String baseQuerySqlWithTablePrefix = String.format("SELECT SUM(%s.a) AS sum_of_a, %s.b FROM %s GROUP BY %s.b", BASE_TABLE_1, BASE_TABLE_1, BASE_TABLE_1, BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT SUM(sum_a) AS sum_of_a, b FROM %s GROUP BY b", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithAliasPartially1, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithAliasPartially2, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlFully, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithTablePrefix, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSqlWithAliasPartially1, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithAliasPartially1, expectedRewrittenSql, originalViewSqlWithAliasPartially1, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithAliasPartially2, expectedRewrittenSql, originalViewSqlWithAliasPartially1, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlFully, expectedRewrittenSql, originalViewSqlWithAliasPartially1, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithTablePrefix, expectedRewrittenSql, originalViewSqlWithAliasPartially1, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSqlWithAliasPartially2, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithAliasPartially1, expectedRewrittenSql, originalViewSqlWithAliasPartially2, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithAliasPartially2, expectedRewrittenSql, originalViewSqlWithAliasPartially2, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlFully, expectedRewrittenSql, originalViewSqlWithAliasPartially2, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithTablePrefix, expectedRewrittenSql, originalViewSqlWithAliasPartially2, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSqlWithAliasFully, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithAliasPartially1, expectedRewrittenSql, originalViewSqlWithAliasFully, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithAliasPartially2, expectedRewrittenSql, originalViewSqlWithAliasFully, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlFully, expectedRewrittenSql, originalViewSqlWithAliasFully, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithTablePrefix, expectedRewrittenSql, originalViewSqlWithAliasFully, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSqlWithTablePrefix, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithAliasPartially1, expectedRewrittenSql, originalViewSqlWithTablePrefix, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithAliasPartially2, expectedRewrittenSql, originalViewSqlWithTablePrefix, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlFully, expectedRewrittenSql, originalViewSqlWithTablePrefix, BASE_TABLE_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySqlWithTablePrefix, expectedRewrittenSql, originalViewSqlWithTablePrefix, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testWithJoinTables() {
        String originalViewSql = String.format("SELECT %s.a, %s.b FROM %s JOIN %s ON %s.c = %s.c", BASE_TABLE_1, BASE_TABLE_2, BASE_TABLE_1, BASE_TABLE_2, BASE_TABLE_1, BASE_TABLE_2);
        String baseQuerySql = String.format("SELECT a, c FROM %s base1", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT %s.a, %s.b FROM %s JOIN %s ON %s.c = %s.c", BASE_TABLE_1, BASE_TABLE_2, BASE_TABLE_1, BASE_TABLE_2, BASE_TABLE_1, BASE_TABLE_2);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testFilterContainment() {
        String originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a = 5", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a = 5", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a = 5", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a >= 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a = 5", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a = 5", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a >= 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a > 5", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a > 5", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a > 3", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a = 5", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a = 5", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a <> 4", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a = 5", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a = 5", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a > 3", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a > 5", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a > 5", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a = 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a = 4", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a = 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a <> 5", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a > 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a >= 5", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a < 3", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a = 5", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a > 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a > 4", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a > 3", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE c > 5", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s WHERE b = 5.0", BASE_TABLE_7);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE b = 5.0", BASE_TABLE_7);
        expectedRewrittenSql = String.format("SELECT a, b FROM %s WHERE b = 5.0", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_7, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s WHERE b = 'apples'", BASE_TABLE_6);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE b = 'apples'", BASE_TABLE_6);
        expectedRewrittenSql = String.format("SELECT a, b FROM %s WHERE b = 'apples'", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_6, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s WHERE b <> 'banana'", BASE_TABLE_6);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE b = 'apples'", BASE_TABLE_6);
        expectedRewrittenSql = String.format("SELECT a, b FROM %s WHERE b = 'apples'", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_6, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s WHERE b <> 'banana'", BASE_TABLE_6);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE b <> 'banana'", BASE_TABLE_6);
        expectedRewrittenSql = String.format("SELECT a, b FROM %s WHERE b <> 'banana'", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_6, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s WHERE b <> 'banana'", BASE_TABLE_6);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE b > 'banana'", BASE_TABLE_6);
        expectedRewrittenSql = String.format("SELECT a, b FROM %s WHERE b > 'banana'", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_6, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s WHERE b > 'apples'", BASE_TABLE_6);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE b > 'banana'", BASE_TABLE_6);
        expectedRewrittenSql = String.format("SELECT a, b FROM %s WHERE b > 'banana'", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_6, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s WHERE b > '122'", BASE_TABLE_6);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE b > '123'", BASE_TABLE_6);
        expectedRewrittenSql = String.format("SELECT a, b FROM %s WHERE b > '123'", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_6, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s WHERE b <> 'apples'", BASE_TABLE_6);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE b > 'banana'", BASE_TABLE_6);
        expectedRewrittenSql = String.format("SELECT a, b FROM %s WHERE b > 'banana'", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_6, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s WHERE b = 'apples'", BASE_TABLE_6);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE b <> 'banana'", BASE_TABLE_6);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_6, VIEW_1);
    }

    @Test
    public void testFilterContainmentWithAnd() {
        String originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a > 0", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a = 5 AND a > 0", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a = 5 AND a > 0", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a = 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a = 5 AND b = 7", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a = 5 AND b = 7", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a = 5 AND c = 9", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a = 5 AND b = 7 AND c = 9", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a = 5 AND b = 7 AND c = 9", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a > 3 AND a < 9", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a > 5 AND a < 7", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a > 5 AND a < 7", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a < 5 AND b > 9", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a < 3 AND b > 11", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a < 3 AND b > 11", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a < 5 AND b > 7 AND c <> 9", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a < 3 AND b > 9 AND c = 11", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a < 3 AND b > 9 AND c = 11", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a <> 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a < 5 AND a > 5", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a < 5 AND a > 5", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s WHERE a < 9 AND b > 3.0", BASE_TABLE_7);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE a < 7 AND b = 3.1", BASE_TABLE_7);
        expectedRewrittenSql = String.format("SELECT a, b FROM %s WHERE a < 7 AND b = 3.1", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_7, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s WHERE b <> 'banana'", BASE_TABLE_6);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE b <> 'apples' AND b <> 'banana'", BASE_TABLE_6);
        expectedRewrittenSql = String.format("SELECT a, b FROM %s WHERE b <> 'apples' AND b <> 'banana'", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_6, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s WHERE a > 6 AND b <> 'banana'", BASE_TABLE_6);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE a = 8 AND b = 'apples'", BASE_TABLE_6);
        expectedRewrittenSql = String.format("SELECT a, b FROM %s WHERE a = 8 AND b = 'apples'", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_6, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s WHERE b = 'orange'", BASE_TABLE_6);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE b <> 'apples' AND b <> 'banana'", BASE_TABLE_6);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_6, VIEW_1);
    }

    @Test
    public void testFilterContainmentWithOr() {
        String originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a = 5 OR a = 7", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a = 5", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a = 5", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a <> 7", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a = 5 OR a = 6", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a = 5 OR a = 6", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a >= 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a = 5 OR a = 6", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a = 5 OR a = 6", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a <> 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a < 5 OR a > 5", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a < 5 OR a > 5", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a > 3 OR a < 9", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a > 5 OR a < 7", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a > 5 OR a < 7", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a < 3 OR a > 9", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a < 1 OR a > 11", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a < 1 OR a > 11", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a = 3 OR a > 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a > 9 OR a = 3", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a > 9 OR a = 3", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a < 3 OR b > 9", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a < 1 OR b > 11", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a < 1 OR b > 11", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a > 3 AND a < 9 OR a > 10", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a > 5 AND a < 7 OR a > 11", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a > 5 AND a < 7 OR a > 11", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s WHERE b <> 2.91", BASE_TABLE_7);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE b <= 2.9 AND b >= 3.0", BASE_TABLE_7);
        expectedRewrittenSql = String.format("SELECT a, b FROM %s WHERE b <= 2.9 AND b >= 3.0", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_7, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s WHERE b <> 'orange'", BASE_TABLE_6);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE b = 'apples' OR b = 'banana'", BASE_TABLE_6);
        expectedRewrittenSql = String.format("SELECT a, b FROM %s  WHERE b = 'apples' OR b = 'banana'", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_6, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a = 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a = 5 OR a = 6", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a = 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a = 5 OR b = 6", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a > 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a = 5 OR a = 6", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s WHERE b <> 'apples'", BASE_TABLE_6);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE b <> 'apples' OR b <> 'banana'", BASE_TABLE_6);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_6, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s WHERE b <> 'orange'", BASE_TABLE_6);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE b <> 'apples' OR b <> 'banana'", BASE_TABLE_6);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_6, VIEW_1);
    }

    @Test
    public void testFilterContainmentWithIn() {
        String originalViewSql = String.format("SELECT a, b, c FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a IN (5)", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a IN (5)", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a IN (5)", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a IN (5)", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a IN (5)", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a IN (5)", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a = 5", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a = 5", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a = 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a IN (5)", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a IN (5)", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a IN (4,5)", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a IN (5)", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a IN (5)", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a IN (3,4,5)", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a IN (3,5)", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a IN (3,5)", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a >= 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a IN (5,6)", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a IN (5,6)", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a <> 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a IN (4,6)", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a IN (4,6)", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a IN (4,5) AND a IN (5,6,7)", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a IN (5)", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a IN (5)", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a IN (4,5) OR a IN (6,7)", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a IN (5,6)", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a IN (5,6)", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a IN (4,5)", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a IN (3,5) AND a IN (5,6)", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a IN (3,5) AND a IN (5,6)", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a NOT IN (5)", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a NOT IN (5)", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a NOT IN (5)", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a NOT IN (5)", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a NOT IN (4,5)", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a NOT IN (4,5)", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a > 5 OR a < 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a NOT IN (5)", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a NOT IN (5)", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a NOT IN (5,6) AND b IN (6,8)", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a < 5 AND b = 8", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a < 5 AND b = 8", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s WHERE b IN ('USA','CAN')", BASE_TABLE_6);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE b = 'CAN' OR b = 'USA'", BASE_TABLE_6);
        expectedRewrittenSql = String.format("SELECT a, b FROM %s WHERE b = 'CAN' OR b = 'USA'", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_6, VIEW_1);
        originalViewSql = String.format("SELECT a, b FROM %s WHERE b NOT IN ('USA','CAN')", BASE_TABLE_6);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE b = 'ABC'", BASE_TABLE_6);
        expectedRewrittenSql = String.format("SELECT a, b FROM %s WHERE b = 'ABC'", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_6, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a = 5", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a IN (5,6)", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a IN (5,6)", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a IN (5,6,7)", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a IN (5,6)", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a = 7", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a NOT IN (5,6)", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a <= 5", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a NOT IN (5,6)", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a NOT IN (6,7)", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a NOT IN (5,6)", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a IN (6,7)", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void singleSubquerySingleCompatibleView() {
        String subquery;
        String originalViewSql = subquery = String.format("SELECT a, b FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, b FROM (%s)", subquery);
        String expectedRewrittenSql = String.format("SELECT a, b FROM (SELECT a, b FROM (%s))", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void singleSubquerySingleIncompatibleView() {
        String subquery = String.format("SELECT a, b, c FROM %s", BASE_TABLE_1);
        String originalViewSql = String.format("SELECT a, b FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, b FROM (%s)", subquery);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void multipleViewsSameBaseTableAllCompatible() {
        String subquery1 = String.format("SELECT a, b FROM %s", BASE_TABLE_1);
        String subquery2 = String.format("SELECT c FROM %s", BASE_TABLE_1);
        String viewSql1 = subquery1;
        String viewSql2 = subquery2;
        String baseQuerySql = String.format("SELECT a, b, c FROM (%s) UNION ALL (%s)", subquery1, subquery2);
        String expectedRewrittenSql = String.format("SELECT a, b, c FROM (SELECT a, b FROM (%s)) UNION ALL (SELECT c FROM (%s))", VIEW_1, VIEW_2);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)viewSql1, (Object)VIEW_2, (Object)viewSql2)));
    }

    @Test
    public void multipleViewsSameBaseTableNoneCompatible() {
        String subquery1 = String.format("SELECT a, b FROM %s", BASE_TABLE_1);
        String subquery2 = String.format("SELECT b, c FROM %s", BASE_TABLE_1);
        String viewSql1 = String.format("SELECT a FROM %s", BASE_TABLE_1);
        String viewSql2 = String.format("SELECT b FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, b, c FROM (%s) UNION ALL (%s)", subquery1, subquery2);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)viewSql1, (Object)VIEW_2, (Object)viewSql2)));
    }

    @Test
    public void multipleViewsSameBaseTableSomeCompatible() {
        String subquery1 = String.format("SELECT a, b FROM %s", BASE_TABLE_1);
        String subquery2 = String.format("SELECT b, c FROM %s", BASE_TABLE_1);
        String viewSql1 = subquery1;
        String viewSql2 = String.format("SELECT c FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, b, c FROM (%s) UNION ALL (%s)", subquery1, subquery2);
        String expectedRewrittenSql = String.format("SELECT a, b, c FROM (SELECT a, b FROM (%s)) UNION ALL (%s)", VIEW_1, subquery2);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)viewSql1, (Object)VIEW_2, (Object)viewSql2)));
    }

    @Test
    public void multipleSubqueriesDifferentBaseTablesSomeCompatible() {
        String subquery1 = String.format("SELECT a, b FROM %s", BASE_TABLE_1);
        String subquery2 = String.format("SELECT a, b, c FROM %s", BASE_TABLE_2);
        String viewSql1 = subquery1;
        String viewSql2 = String.format("SELECT a, b FROM %s", BASE_TABLE_2);
        String baseQuerySql = String.format("SELECT a, b, c FROM (%s) UNION ALL (%s)", subquery1, subquery2);
        String expectedRewrittenSql = String.format("SELECT a, b, c FROM (SELECT a, b FROM (%s)) UNION ALL (%s)", VIEW_1, subquery2);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)viewSql1, (Object)VIEW_2, (Object)viewSql2)));
    }

    @Test
    public void multipleSubqueriesOptimizableFromSameView() {
        String subquery1 = String.format("SELECT a, b FROM %s", BASE_TABLE_1);
        String subquery2 = String.format("SELECT c FROM %s", BASE_TABLE_1);
        String originalViewSql = String.format("SELECT a, b, c FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, b, c FROM (%s) UNION ALL (%s)", subquery1, subquery2);
        String expectedRewrittenSql = String.format("SELECT a, b, c FROM (SELECT a, b FROM (%s)) UNION ALL (SELECT c FROM (%s))", VIEW_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void singleInvalidSubquery() {
        String subquery1 = String.format("SELECT a, b FROM %s", BASE_TABLE_1);
        String subquery2 = String.format("SELECT c FROM %s", BASE_TABLE_1);
        String viewSql1 = subquery1;
        String viewSql2 = String.format("%s WHERE c > 5", subquery2);
        String baseQuerySql = String.format("SELECT a, b, c FROM (%s) UNION ALL (%s)", subquery1, subquery2);
        String expectedRewrittenSql = String.format("SELECT a, b, c FROM (SELECT a, b FROM (%s)) UNION ALL (%s)", VIEW_1, subquery2);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)viewSql1, (Object)VIEW_2, (Object)viewSql2)));
    }

    @Test
    public void multipleInvalidSubqueries() {
        String subquery1 = String.format("SELECT a, b FROM %s", BASE_TABLE_1);
        String subquery2 = String.format("SELECT c FROM %s", BASE_TABLE_1);
        String viewSql1 = String.format("SELECT a, sum(b) FROM %s GROUP BY a", BASE_TABLE_1);
        String viewSql2 = String.format("%s WHERE c > 5", subquery2);
        String baseQuerySql = String.format("SELECT a, b, c FROM (%s) UNION ALL (%s)", subquery1, subquery2);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)viewSql1, (Object)VIEW_2, (Object)viewSql2)));
    }

    @Test
    public void joinWithSomeValidSubqueries() {
        String subquery1 = String.format("SELECT a, b FROM %s", BASE_TABLE_1);
        String subquery2 = String.format("SELECT c, d, e FROM %s", BASE_TABLE_2);
        String viewSql1 = String.format("SELECT a, b FROM %s", BASE_TABLE_1);
        String viewSql2 = String.format("SELECT c, d FROM %s", BASE_TABLE_2);
        String baseQuerySql = String.format("SELECT s1.a, s1.b, s2.c, s2.d, s2.e FROM (%s) s1 INNER JOIN (%s) s2 ON s1.a = s2.c", subquery1, subquery2);
        String expectedRewrittenSql = String.format("SELECT s1.a, s1.b, s2.c, s2.d, s2.e FROM (SELECT a, b FROM (%s)) s1 INNER JOIN (%s) s2 ON s1.a = s2.c", VIEW_1, subquery2);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)viewSql1, (Object)VIEW_2, (Object)viewSql2)));
    }

    @Test
    public void nestedSubqueries() {
        String subquery1 = String.format("SELECT a, b FROM %s", BASE_TABLE_1);
        String subquery2 = String.format("SELECT c FROM %s", BASE_TABLE_2);
        String subquery3 = String.format("SELECT d, e from %s", BASE_TABLE_3);
        String viewSql1 = subquery1;
        String viewSql2 = subquery2;
        String viewSql3 = String.format("SELECT d FROM %s", BASE_TABLE_3);
        String nestedJoin = String.format("SELECT c, d, e FROM (%s) s2 INNER JOIN (%s) s3 ON s2.c = s3.d", subquery2, subquery3);
        String baseQuerySql = String.format("SELECT a, b, c, d, e FROM (%s) s1 INNER JOIN (%s) nested_join ON s1.a = nested_join.c", subquery1, nestedJoin);
        String expectedRewrittenSql = String.format("SELECT a, b, c, d, e FROM (SELECT a, b FROM (%s)) s1 INNER JOIN (SELECT c, d, e FROM (SELECT c FROM (%s)) s2 INNER JOIN (%s) s3 on s2.c = s3.d) nested_join ON s1.a = nested_join.c", VIEW_1, VIEW_2, subquery3);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)viewSql1), (Object)BASE_TABLE_2, (Object)ImmutableMap.of((Object)VIEW_2, (Object)viewSql2), (Object)BASE_TABLE_3, (Object)ImmutableMap.of((Object)VIEW_3, (Object)viewSql3)));
    }

    @Test
    public void subqueryAggregationSupportedFunction() {
        String subquery1 = String.format("SELECT COUNT(a) AS count_a1, b FROM %s GROUP BY b", BASE_TABLE_1);
        String subquery2 = String.format("SELECT COUNT(a) AS count_a2, c FROM %s GROUP BY c", BASE_TABLE_2);
        String viewSql1 = subquery1;
        String viewSql2 = subquery2;
        String baseQuerySql = String.format("SELECT GREATEST(count_a1, count_a2) AS bigcount FROM (%s) s1 INNER JOIN (%s) s2 ON s1.b = s2.c", subquery1, subquery2);
        String expectedRewrittenSql = String.format("SELECT GREATEST(count_a1, count_a2) AS bigcount FROM (SELECT SUM(count_a1) AS count_a1, b FROM %s GROUP BY b) s1 INNER JOIN (SELECT SUM(count_a2) AS count_a2, c FROM %s GROUP BY c) s2 ON s1.b = s2.c", VIEW_1, VIEW_2);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)viewSql1), (Object)BASE_TABLE_2, (Object)ImmutableMap.of((Object)VIEW_2, (Object)viewSql2)));
        subquery1 = String.format("SELECT MIN(b) AS min_b FROM %s", BASE_TABLE_1);
        subquery2 = String.format("SELECT MIN(c) AS min_c FROM %s", BASE_TABLE_2);
        viewSql1 = subquery1;
        viewSql2 = subquery2;
        baseQuerySql = String.format("SELECT min_b AS miny_b FROM (%s) s1 INNER JOIN (%s) s2 ON s1.min_b = s2.min_c", subquery1, subquery2);
        expectedRewrittenSql = String.format("SELECT min_b AS miny_b FROM (SELECT MIN(min_b) AS min_b FROM %s) s1 \nINNER JOIN (SELECT MIN(min_c) AS min_c FROM %s) s2 \nON s1.min_b = s2.min_c", VIEW_1, VIEW_2);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)viewSql1), (Object)BASE_TABLE_2, (Object)ImmutableMap.of((Object)VIEW_2, (Object)viewSql2)));
    }

    @Test
    public void testAvgRewriteWithSumAndCount() {
        String originalViewSql = String.format("SELECT SUM(a) AS mv_sum, COUNT(a) AS mv_count FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT AVG(a) AS base_avg FROM %s", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT (SUM(mv_sum) / SUM(mv_count)) AS base_avg FROM %s", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT SUM(a, b) AS mv_sum, COUNT(a, b) AS mv_count FROM %s", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT AVG(a, b) AS base_avg FROM %s", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT SUM(a+b) AS mv_sum, COUNT(a+b) AS mv_count FROM %s", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT AVG(a+b) AS base_avg FROM %s", BASE_TABLE_1);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testAvgRewriteWithSumAndCountC() {
        String originalViewSql = String.format("SELECT SUM(a) AS mv_sum, COUNT(a) AS mv_count FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT AVG(a) AS base_avg FROM %s", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT (SUM(mv_sum) / SUM(mv_count)) AS base_avg FROM %s", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testAvgRewriteWithSumAndCountGroupByJoin() {
        String originalViewSql = String.format("SELECT SUM(a) AS mv_sum, COUNT(a) AS mv_count, b, c FROM %s GROUP BY b, c", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT AVG(a), b FROM %s GROUP BY b", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT (SUM(mv_sum) / SUM(mv_count)), b FROM %s GROUP BY b", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
        originalViewSql = String.format("SELECT SUM(a) AS mv_sum, COUNT(a) AS mv_count, b FROM %s GROUP BY b", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT filtered_avg, b, a_count FROM (SELECT base_avg as filtered_avg, b FROM (SELECT AVG(a) AS base_avg, b FROM %s GROUP BY b ORDER BY b) WHERE base_avg < 5.25) s1 INNER JOIN (SELECT COUNT(a) AS a_count, b FROM %s GROUP BY b) s2 ON s1.b = s2.b", BASE_TABLE_1, BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT filtered_avg, b, a_count FROM (SELECT base_avg as filtered_avg, b FROM (SELECT (SUM(mv_sum) / SUM(mv_count)) AS base_avg, b FROM %s GROUP BY b ORDER BY b) WHERE base_avg < 5.25) s1 INNER JOIN (SELECT SUM(mv_count) AS a_count, b FROM %s GROUP BY b) s2 ON s1.b = s2.b", VIEW_1, VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testApproxDistinctRewrite() {
        String originalViewSql = String.format("SELECT cast(APPROX_SET(a) as varbinary) AS mv_approx_set FROM %s", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT APPROX_DISTINCT(a) AS base_approx_distinct FROM %s", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT (CARDINALITY(MERGE(CAST(mv_approx_set AS hyperloglog)))) AS base_approx_distinct FROM %s", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void testApproxDistinctRewriteGroupBy() {
        String originalViewSql = String.format("SELECT cast(APPROX_SET(a) as varbinary) AS mv_approx_set, b, c FROM %s GROUP BY b, c", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT APPROX_DISTINCT(a) AS base_approx_distinct, b FROM %s GROUP BY b", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT (CARDINALITY(MERGE(CAST(mv_approx_set AS hyperloglog)))) AS base_approx_distinct, b FROM %s GROUP BY b", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void subqueryAggregationUnsupportedFunction() {
        String subquery1 = String.format("SELECT GEOMETRIC_MEAN(b) AS mean_b FROM %s", BASE_TABLE_1);
        String subquery2 = String.format("SELECT GEOMETRIC_MEAN(c) AS mean_c FROM %s", BASE_TABLE_2);
        String viewSql1 = subquery1;
        String viewSql2 = subquery2;
        String baseQuerySql = String.format("SELECT mean_b AS meany_b FROM (%s) s1 INNER JOIN (%s) s2 ON s1.mean_b = s2.mean_c", subquery1, subquery2);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)viewSql1), (Object)BASE_TABLE_2, (Object)ImmutableMap.of((Object)VIEW_2, (Object)viewSql2)));
    }

    @Test
    public void subqueryAggregationSomeSupportedFunctions() {
        String subquery1 = String.format("SELECT min(b) AS min_b FROM %s", BASE_TABLE_1);
        String subquery2 = String.format("SELECT GEOMETRIC_MEAN(c) AS mean_c FROM %s", BASE_TABLE_2);
        String viewSql1 = subquery1;
        String viewSql2 = subquery2;
        String baseQuerySql = String.format("SELECT min_b AS miny_b FROM (%s) s1 INNER JOIN (%s) s2 ON s1.min_b = s2.mean_c", subquery1, subquery2);
        String expectedRewrittenSql = String.format("SELECT min_b AS miny_b FROM (SELECT MIN(min_b) AS min_b FROM %s) s1 INNER JOIN (%s) s2 ON s1.min_b = s2.mean_c", VIEW_1, subquery2);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)viewSql1), (Object)BASE_TABLE_2, (Object)ImmutableMap.of((Object)VIEW_2, (Object)viewSql2)));
    }

    @Test
    public void subqueryJoinAggregates() {
        String subquery1 = String.format("SELECT c, sum(b) AS sum_b FROM %s GROUP BY c", BASE_TABLE_1);
        String subquery2 = String.format("SELECT c, sum(a) AS sum_a FROM %s GROUP BY c", BASE_TABLE_2);
        String viewSql1 = subquery1;
        String viewSql2 = subquery2;
        String baseQuerySql = String.format("SELECT sum_b+sum_a AS sum_all FROM (%s) s1 INNER JOIN (%s) s2 ON s1.c = s2.c", subquery1, subquery2);
        String expectedRewrittenSql = String.format("SELECT sum_b+sum_a AS sum_all FROM (SELECT c, sum(sum_b) AS sum_b FROM %s GROUP BY c) s1 INNER JOIN (SELECT c, sum(sum_a) AS sum_a FROM %s GROUP BY c) s2 ON s1.c = s2.c", VIEW_1, VIEW_2);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)viewSql1), (Object)BASE_TABLE_2, (Object)ImmutableMap.of((Object)VIEW_2, (Object)viewSql2)));
    }

    @Test
    public void subqueryJoinAggregatesIncompatibleGroupBy() {
        String subquery1 = String.format("SELECT c, a, sum(b) AS sum_b FROM %s GROUP BY c, a", BASE_TABLE_1);
        String subquery2 = String.format("SELECT c, b, sum(a) AS sum_a FROM %s GROUP BY c, b", BASE_TABLE_2);
        String viewSql1 = String.format("SELECT c, sum(b) AS sum_b FROM %s GROUP BY c", BASE_TABLE_1);
        String viewSql2 = String.format("SELECT c, sum(a) AS sum_a FROM %s GROUP BY c", BASE_TABLE_2);
        String baseQuerySql = String.format("SELECT sum_b+sum_a AS sum_all FROM (%s) s1 INNER JOIN (%s) s2 ON s1.c = s2.c", subquery1, subquery2);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)viewSql1), (Object)BASE_TABLE_2, (Object)ImmutableMap.of((Object)VIEW_2, (Object)viewSql2)));
    }

    @Test
    public void subqueryJoinFilter() {
        String subquery1 = String.format("SELECT a, b FROM %s WHERE b > 5", BASE_TABLE_1);
        String subquery2 = String.format("SELECT c, b FROM %s WHERE b > 5", BASE_TABLE_2);
        String viewSql1 = String.format("SELECT a, b FROM %s WHERE b > 5", BASE_TABLE_1);
        String viewSql2 = String.format("SELECT c, b FROM %s WHERE b > 5", BASE_TABLE_2);
        String baseQuerySql = String.format("SELECT s1.a, s1.b, s2.b, s2.c FROM(SELECT a, b FROM (%s) WHERE b > 5) s1 INNER JOIN (SELECT c, b FROM (%s) WHERE b > 5) s2 ON s1.b = s2.b", subquery1, subquery2);
        String expectedRewrittenSql = String.format("SELECT s1.a, s1.b, s2.b, s2.c FROM(SELECT a, b FROM (SELECT a, b FROM %s WHERE b > 5) WHERE b > 5) s1 INNER JOIN (SELECT c, b FROM (SELECT c, b FROM (%s) WHERE b > 5) WHERE b > 5) s2 ON s1.b = s2.b", VIEW_1, VIEW_2);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)viewSql1), (Object)BASE_TABLE_2, (Object)ImmutableMap.of((Object)VIEW_2, (Object)viewSql2)));
    }

    @Test
    public void subqueryJoinIncompatibleFilter() {
        String subquery1 = String.format("SELECT a, b FROM %s WHERE b > 5", BASE_TABLE_1);
        String subquery2 = String.format("SELECT c, b FROM %s WHERE b > 5", BASE_TABLE_2);
        String viewSql1 = String.format("SELECT a, b FROM %s WHERE b > 6", BASE_TABLE_1);
        String viewSql2 = String.format("SELECT c, b FROM %s WHERE b > 6", BASE_TABLE_2);
        String baseQuerySql = String.format("SELECT s1.a, s1.b, s2.b, s2.c FROM (%s) s1 INNER JOIN (%s) s2 ON s1.b = s2.b", subquery1, subquery2);
        this.assertOptimizedQuery(baseQuerySql, baseQuerySql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)viewSql1), (Object)BASE_TABLE_2, (Object)ImmutableMap.of((Object)VIEW_2, (Object)viewSql2)));
    }

    @Test
    public void subqueryFilterGroupBy() {
        String subquery;
        String originalViewSql = subquery = String.format("SELECT a, b, sum(c) AS sum_c FROM %s WHERE b > 5 GROUP BY a, b", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, b, sum(c) AS sum_c FROM (%s)", subquery);
        String expectedRewrittenSql = String.format("SELECT a, b, sum(c) AS sum_c FROM (SELECT a, b, sum(sum_c) AS sum_c FROM %s WHERE b > 5 GROUP BY a, b)", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, originalViewSql, BASE_TABLE_1, VIEW_1);
    }

    @Test
    public void subqueryMultipleFiltersGroupBys() {
        String subquery1 = String.format("SELECT a, b, sum(c) AS sum_c FROM %s WHERE b > 5 AND a = 3 GROUP BY a, b", BASE_TABLE_1);
        String subquery2 = String.format("SELECT a, b, sum(d) AS sum_d FROM %s WHERE b >= 5 AND a <> 3 GROUP BY a, b", BASE_TABLE_2);
        String viewSql1 = subquery1;
        String viewSql2 = subquery2;
        String baseQuerySql = String.format("SELECT s1.a, s1.b, sum_c, s2.a, s2.b, sum_d FROM(%s) s1 INNER JOIN (%s) s2 ON s1.b = s2.b", subquery1, subquery2);
        String expectedRewrittenSql = String.format("SELECT s1.a, s1.b, sum_c, s2.a, s2.b, sum_d FROM(SELECT a, b, sum(sum_c) AS sum_c FROM (%s) WHERE b > 5 AND a = 3 GROUP BY a, b) s1 INNER JOIN (SELECT a, b, sum(sum_d) AS sum_d FROM (%s) WHERE b >= 5 AND a <> 3 GROUP BY a, b) s2 ON s1.b = s2.b", VIEW_1, VIEW_2);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)viewSql1), (Object)BASE_TABLE_2, (Object)ImmutableMap.of((Object)VIEW_2, (Object)viewSql2)));
    }

    @Test
    public void subqueryJoinAggregatesWith() {
        String subquery1 = String.format("SELECT min(b) AS min_b FROM %s", BASE_TABLE_1);
        String subquery2 = String.format("SELECT GEOMETRIC_MEAN(c) AS mean_c FROM %s", BASE_TABLE_2);
        String viewSql1 = subquery1;
        String viewSql2 = subquery2;
        String baseQuerySql = String.format("WITH s1 AS (%s) SELECT min_b AS miny_b FROM s1 INNER JOIN (%s) s2 ON s1.min_b = s2.mean_c", subquery1, subquery2);
        String expectedRewrittenSql = String.format("WITH s1 AS (SELECT MIN(min_b) AS min_b FROM %s) SELECT min_b AS miny_b FROM s1 INNER JOIN (%s) s2 ON s1.min_b = s2.mean_c", VIEW_1, subquery2);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)viewSql1), (Object)BASE_TABLE_2, (Object)ImmutableMap.of((Object)VIEW_2, (Object)viewSql2)));
    }

    @Test
    public void subqueryInsideWithClause() {
        String subquery1 = String.format("SELECT d, sum(b) as sum_b from %s GROUP BY d", BASE_TABLE_1);
        String subquery2 = String.format("SELECT a, GEOMETRIC_MEAN(c) AS mean_c FROM %s GROUP BY a", BASE_TABLE_2);
        String viewSql1 = subquery1;
        String viewSql2 = subquery2;
        String baseQuerySql = String.format("WITH s3 AS ((%s) UNION ALL (%s)) SELECT d, sum_b, mean_c, a FROM s3", subquery1, subquery2);
        String expectedRewrittenSql = String.format("WITH s3 AS((SELECT d, sum(sum_b) AS sum_b FROM (%s) GROUP BY d) UNION ALL (%s)) SELECT d, sum_b, mean_c, a FROM s3", VIEW_1, subquery2);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)viewSql1), (Object)BASE_TABLE_2, (Object)ImmutableMap.of((Object)VIEW_2, (Object)viewSql2)));
    }

    @Test(enabled=false)
    public void testFilterContainmentDisjunctiveNormalForm() {
        String originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a = 1 AND b = 2 OR b = 3 AND c = 4", BASE_TABLE_1);
        String baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a = 1 AND b = 2 AND c = 3", BASE_TABLE_1);
        String expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a = 1 AND b = 2 AND c = 3", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)originalViewSql)));
        originalViewSql = String.format("SELECT a, b, c FROM %s WHERE a = 1 AND b = 2 OR b = 3 AND c = 4 OR a = 5 AND c = 6", BASE_TABLE_1);
        baseQuerySql = String.format("SELECT a, b, c FROM %s WHERE a = 1 AND b = 2 AND c = 3 OR a = 5 AND b = 7 AND c = 6", BASE_TABLE_1);
        expectedRewrittenSql = String.format("SELECT a, b, c FROM %s WHERE a = 1 AND b = 2 AND c = 3 OR a = 5 AND b = 7 AND c = 6", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)originalViewSql)));
    }

    @Test(enabled=false)
    public void testFilterContainmentWithMismatchStringLength() {
        String originalViewSql = String.format("SELECT a, b FROM %s WHERE b <> 'banana'", BASE_TABLE_6);
        String baseQuerySql = String.format("SELECT a, b FROM %s WHERE b = 'apple'", BASE_TABLE_6);
        String expectedRewrittenSql = String.format("SELECT a, b FROM %s WHERE b = 'apple'", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)originalViewSql)));
        originalViewSql = String.format("SELECT a, b FROM %s WHERE b NOT IN ('USA','CAN')", BASE_TABLE_6);
        baseQuerySql = String.format("SELECT a, b FROM %s WHERE b = 'UK'", BASE_TABLE_6);
        expectedRewrittenSql = String.format("SELECT a, b FROM %s WHERE b = 'UK'", VIEW_1);
        this.assertOptimizedQuery(baseQuerySql, expectedRewrittenSql, (Map<String, Map<String, String>>)ImmutableMap.of((Object)BASE_TABLE_1, (Object)ImmutableMap.of((Object)VIEW_1, (Object)originalViewSql)));
    }

    private void assertOptimizedQuery(String baseQuerySql, String expectedViewSql, String originalViewSql, String baseTableName, String originalViewName) {
        TransactionBuilder.transaction((TransactionManager)this.transactionManager, (AccessControl)this.accessControl).singleStatement().readUncommitted().execute(TEST_SESSION, session -> {
            Query baseQuery = (Query)SQL_PARSER.createStatement(baseQuerySql, AnalyzerUtil.createParsingOptions((Session)session));
            Query expectedViewQuery = (Query)SQL_PARSER.createStatement(expectedViewSql, AnalyzerUtil.createParsingOptions((Session)session));
            this.metadata.createMaterializedView(session, "tpch", null, this.createStubConnectorMaterializedViewDefinition(originalViewName, originalViewSql, SESSION_SCHEMA, (List<SchemaTableName>)ImmutableList.of((Object)new SchemaTableName(SESSION_SCHEMA, baseTableName))), false);
            Query optimizedBaseToViewQuery = (Query)new MaterializedViewQueryOptimizer(this.metadata, session, SQL_PARSER, this.accessControl, this.domainTranslator).process((Node)baseQuery);
            Assert.assertEquals((Object)optimizedBaseToViewQuery, (Object)expectedViewQuery);
            this.metadata.dropMaterializedView(session, QualifiedObjectName.valueOf((String)"tpch", (String)SESSION_SCHEMA, (String)baseTableName));
        });
    }

    private void assertOptimizedQuery(String baseQuerySql, String expectedQueryAfterOptimization, Map<String, Map<String, String>> viewQueries) {
        TransactionBuilder.transaction((TransactionManager)this.transactionManager, (AccessControl)this.accessControl).singleStatement().readUncommitted().execute(TEST_SESSION, session -> {
            Query baseQuery = (Query)SQL_PARSER.createStatement(baseQuerySql, AnalyzerUtil.createParsingOptions((Session)session));
            Query expectedViewQuery = (Query)SQL_PARSER.createStatement(expectedQueryAfterOptimization, AnalyzerUtil.createParsingOptions((Session)session));
            ArrayList<QualifiedObjectName> createdMaterializedViews = new ArrayList<QualifiedObjectName>();
            for (Map.Entry baseToViewMap : viewQueries.entrySet()) {
                for (Map.Entry viewNameToSqlMap : ((Map)baseToViewMap.getValue()).entrySet()) {
                    this.metadata.createMaterializedView(session, "tpch", null, this.createStubConnectorMaterializedViewDefinition((String)viewNameToSqlMap.getKey(), (String)viewNameToSqlMap.getValue(), SESSION_SCHEMA, (List<SchemaTableName>)ImmutableList.of((Object)new SchemaTableName(SESSION_SCHEMA, (String)baseToViewMap.getKey()))), false);
                    createdMaterializedViews.add(QualifiedObjectName.valueOf((String)"tpch", (String)SESSION_SCHEMA, (String)((String)viewNameToSqlMap.getKey())));
                }
            }
            Query optimizedBaseToViewQuery = (Query)new MaterializedViewQueryOptimizer(this.metadata, session, SQL_PARSER, this.accessControl, this.domainTranslator).process((Node)baseQuery);
            Assert.assertEquals((Object)optimizedBaseToViewQuery, (Object)expectedViewQuery);
            for (QualifiedObjectName materializedView : createdMaterializedViews) {
                this.metadata.dropMaterializedView(session, materializedView);
            }
        });
    }

    private MaterializedViewDefinition createStubConnectorMaterializedViewDefinition(String viewName, String viewSql, String schema, List<SchemaTableName> baseTables) {
        return new MaterializedViewDefinition(viewSql, schema, viewName, baseTables, Optional.empty(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());
    }
}

