/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.MaterializedViewRewriteQueryShapeValidator;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMaterializedViewRewriteQueryShapeValidator {
    private static final SqlParser SQL_PARSER = new SqlParser();

    @Test
    public void supportedFunction() {
        TestMaterializedViewRewriteQueryShapeValidator.assertSucceeds("SELECT SUM(x) AS sum_x, y FROM tbl GROUP BY y ORDER BY z");
    }

    @Test
    public void unsupportedFunction() {
        TestMaterializedViewRewriteQueryShapeValidator.assertFails("SELECT GEOMETRIC_MEAN(x) AS geomean_x, y FROM tbl GROUP BY y", "Query shape invalid: geometric_mean function is not supported for materialized view optimizations");
    }

    @Test
    public void havingClause() {
        TestMaterializedViewRewriteQueryShapeValidator.assertFails("SELECT SUM(x) AS sum_x, y FROM tbl GROUP BY y HAVING COUNT(x) < 10", "Query shape invalid: HAVING is not supported for materialized view optimizations");
    }

    private static void assertFails(String baseQuerySql, String expectedErrorMessage) {
        QuerySpecification querySpecification = (QuerySpecification)((Query)SQL_PARSER.createStatement(baseQuerySql)).getQueryBody();
        Optional errorMessage = MaterializedViewRewriteQueryShapeValidator.validate((QuerySpecification)querySpecification);
        Assert.assertTrue((boolean)errorMessage.isPresent());
        com.facebook.presto.testing.assertions.Assert.assertEquals((String)((String)errorMessage.get()), (String)expectedErrorMessage);
    }

    private static void assertSucceeds(String baseQuerySql) {
        QuerySpecification querySpecification = (QuerySpecification)((Query)SQL_PARSER.createStatement(baseQuerySql)).getQueryBody();
        Optional errorMessage = MaterializedViewRewriteQueryShapeValidator.validate((QuerySpecification)querySpecification);
        Assert.assertFalse((boolean)errorMessage.isPresent());
    }
}

