/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.Session;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.TestingBlockEncodingSerde;
import com.facebook.presto.common.block.TestingBlockJsonSerde;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.common.type.TestingTypeDeserializer;
import com.facebook.presto.common.type.TestingTypeManager;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.sql.Optimizer;
import com.facebook.presto.sql.planner.CanonicalPartitioningScheme;
import com.facebook.presto.sql.planner.CanonicalPlanGenerator;
import com.facebook.presto.sql.planner.CanonicalTableScanNode;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCanonicalPlanGenerator
extends BasePlanTest {
    private final ObjectMapper objectMapper;

    public TestCanonicalPlanGenerator() {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde(new BlockEncoding[0]);
        this.objectMapper = new JsonObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer((TypeManager)typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer((BlockEncodingSerde)blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer((BlockEncodingSerde)blockEncodingSerde))).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    }

    @Test
    public void testPartialAggregation() throws Exception {
        this.assertSameCanonicalLeafSubPlan("SELECT avg(totalprice) FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT avg(totalprice) FILTER (WHERE orderstatus != 'F') FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT array_agg(totalprice ORDER BY totalprice) FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT DISTINCT orderstatus FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT count(DISTINCT orderstatus) FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT orderstatus, sum(totalprice) FROM orders GROUP BY orderstatus");
        this.assertSameCanonicalLeafSubPlan("SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY GROUPING SETS (shippriority), (shippriority, custkey)");
        this.assertSameCanonicalLeafSubPlan("SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY GROUPING SETS (shippriority, custkey), (shippriority)");
        this.assertSameCanonicalLeafSubPlan("SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY CUBE (shippriority, custkey)");
        this.assertSameCanonicalLeafSubPlan("SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY ROLLUP (shippriority, custkey)");
        this.assertDifferentCanonicalLeafSubPlan("SELECT avg(totalprice) FROM orders", "SELECT sum(totalprice) FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT avg(totalprice) FROM orders", "SELECT avg(shippriority) FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT count(orderkey) FROM orders", "SELECT count(orderkey) FROM lineitem");
        this.assertDifferentCanonicalLeafSubPlan("SELECT avg(totalprice) FILTER (WHERE orderstatus != 'F') FROM orders", "SELECT avg(totalprice) FILTER (WHERE orderstatus != 'P') FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT array_agg(totalprice ORDER BY orderstatus) FROM orders", "SELECT array_agg(totalprice ORDER BY totalprice) FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT DISTINCT orderstatus FROM orders", "SELECT DISTINCT totalprice FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT count(DISTINCT orderstatus) FROM orders", "SELECT count(orderstatus) FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT orderstatus, sum(totalprice) FROM orders GROUP BY orderstatus", "SELECT shippriority, sum(totalprice) FROM orders GROUP BY shippriority");
        this.assertDifferentCanonicalLeafSubPlan("SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY GROUPING SETS (shippriority), (shippriority, custkey)", "SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY GROUPING SETS (shippriority, custkey)");
        this.assertDifferentCanonicalLeafSubPlan("SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY GROUPING SETS (shippriority), (shippriority, custkey)", "SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY GROUPING SETS (custkey), (shippriority, custkey)");
        this.assertDifferentCanonicalLeafSubPlan("SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY ROLLUP (shippriority, custkey)", "SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY ROLLUP (custkey, shippriority)");
    }

    @Test
    public void testUnnest() throws Exception {
        this.assertSameCanonicalLeafSubPlan("SELECT a.custkey, t.e FROM (SELECT custkey, ARRAY[1, 2, 3] AS my_array FROM orders) a CROSS JOIN UNNEST(my_array) AS t(e)");
        this.assertSameCanonicalLeafSubPlan("SELECT * FROM (SELECT custkey, ARRAY[1, 2, 3] AS my_array FROM orders) a CROSS JOIN UNNEST(my_array) WITH ORDINALITY AS t(e, ord)");
    }

    @Test
    public void testProject() throws Exception {
        this.assertSameCanonicalLeafSubPlan("SELECT 1 + 2 FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT totalprice / 2 FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT custkey + orderkey FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT totalprice / 2 FROM orders", "SELECT totalprice * 2 FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT custkey + orderkey FROM orders", "SELECT custkey + shippriority FROM orders");
    }

    @Test
    public void testFilter() throws Exception {
        this.assertSameCanonicalLeafSubPlan("SELECT totalprice FROM orders WHERE orderkey < 100");
        this.assertDifferentCanonicalLeafSubPlan("SELECT totalprice FROM orders WHERE orderkey < 100", "SELECT totalprice FROM orders WHERE orderkey < 50");
        this.assertDifferentCanonicalLeafSubPlan("SELECT totalprice FROM orders WHERE orderkey < 100", "SELECT totalprice FROM orders WHERE custkey < 100");
        this.assertDifferentCanonicalLeafSubPlan("SELECT totalprice FROM orders", "SELECT totalprice FROM orders WHERE custkey < 100");
    }

    @Test
    public void testTableScan() throws Exception {
        this.assertSameCanonicalLeafSubPlan("SELECT totalprice FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT orderkey, totalprice FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT * FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT * FROM orders", "SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT totalprice FROM orders", "SELECT orderkey, totalprice FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT * FROM orders", "SELECT orderkey, totalprice FROM orders");
    }

    @Test
    public void testTableScanAndProjectWithStrategy() throws Exception {
        this.assertSameCanonicalLeafPlan("SELECT 1 from orders", "SELECT 1 from orders", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentCanonicalLeafPlan("SELECT 1 from orders", "SELECT 2 from orders", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertSameCanonicalLeafPlan("SELECT 1 from orders", "SELECT 2 from orders", PlanCanonicalizationStrategy.IGNORE_SAFE_CONSTANTS);
        this.assertSameCanonicalLeafPlan("SELECT CAST(1 AS VARCHAR) from orders", "SELECT CAST(2 AS VARCHAR) from orders", PlanCanonicalizationStrategy.IGNORE_SAFE_CONSTANTS);
        this.assertSameCanonicalLeafPlan("SELECT 1 from orders", "SELECT 2 from orders", PlanCanonicalizationStrategy.IGNORE_SCAN_CONSTANTS);
        this.assertSameCanonicalLeafPlan("SELECT CAST(1 AS VARCHAR) from orders", "SELECT CAST(2 AS VARCHAR) from orders", PlanCanonicalizationStrategy.IGNORE_SCAN_CONSTANTS);
        this.assertSameCanonicalLeafPlan("SELECT totalprice, custkey + (totalprice / 10) from orders", "SELECT custkey + (totalprice / 10), totalprice from orders", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentCanonicalLeafPlan("SELECT totalprice, custkey + (totalprice / 10) from orders", "SELECT custkey + (totalprice / 5), totalprice from orders", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertSameCanonicalLeafPlan("SELECT totalprice, custkey + (totalprice / 10) from orders", "SELECT custkey + (totalprice / 5), totalprice from orders", PlanCanonicalizationStrategy.IGNORE_SAFE_CONSTANTS);
        this.assertSameCanonicalLeafPlan("SELECT totalprice, custkey + (totalprice / 10) from orders", "SELECT custkey + (totalprice / 5), totalprice from orders", PlanCanonicalizationStrategy.IGNORE_SCAN_CONSTANTS);
    }

    @Test
    public void testFilterWithStrategy() throws Exception {
        this.assertSameCanonicalLeafPlan("SELECT totalprice from orders WHERE custkey > 100 AND custkey < 120", "SELECT totalprice from orders WHERE custkey > 100 AND custkey < 120", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentCanonicalLeafPlan("SELECT totalprice from orders WHERE custkey > 100 AND custkey < 110", "SELECT totalprice from orders WHERE custkey > 100 AND custkey < 120", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentCanonicalLeafPlan("SELECT totalprice from orders WHERE custkey > 100 AND custkey < 120", "SELECT totalprice from orders WHERE custkey > 100 AND custkey < 110", PlanCanonicalizationStrategy.IGNORE_SAFE_CONSTANTS);
        this.assertDifferentCanonicalLeafPlan("SELECT totalprice from orders WHERE custkey > 100 AND custkey < 120", "SELECT totalprice from orders WHERE custkey > 100 AND custkey < 110", PlanCanonicalizationStrategy.IGNORE_SCAN_CONSTANTS);
        this.assertSameCanonicalLeafPlan("SELECT totalprice from orders WHERE custkey IN (10,20,30)", "SELECT totalprice from orders WHERE custkey IN (10,30,20)", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentCanonicalLeafPlan("SELECT totalprice from orders WHERE custkey IN (10,20,30)", "SELECT totalprice from orders WHERE custkey IN (10,30,40)", PlanCanonicalizationStrategy.IGNORE_SAFE_CONSTANTS);
        this.assertSameCanonicalLeafPlan("SELECT totalprice, CAST(3 AS VARCHAR) from orders WHERE custkey > 100 AND custkey < 120", "SELECT totalprice, CAST(2 AS VARCHAR) as x from orders WHERE custkey > 100 AND custkey < 120", PlanCanonicalizationStrategy.IGNORE_SAFE_CONSTANTS);
        this.assertDifferentCanonicalLeafPlan("SELECT totalprice from orders WHERE custkey IN (10,20,30)", "SELECT totalprice from orders WHERE custkey IN (10,30,40)", PlanCanonicalizationStrategy.IGNORE_SCAN_CONSTANTS);
        this.assertSameCanonicalLeafPlan("SELECT totalprice, CAST(3 AS VARCHAR) from orders WHERE custkey > 100 AND custkey < 120", "SELECT totalprice, CAST(2 AS VARCHAR) as x from orders WHERE custkey > 100 AND custkey < 120", PlanCanonicalizationStrategy.IGNORE_SCAN_CONSTANTS);
    }

    private static List<SubPlan> getLeafSubPlans(SubPlan subPlan) {
        if (subPlan.getChildren().isEmpty()) {
            return ImmutableList.of((Object)subPlan);
        }
        return (List)subPlan.getChildren().stream().map(TestCanonicalPlanGenerator::getLeafSubPlans).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    private void assertSameCanonicalLeafSubPlan(String sql) throws Exception {
        this.assertSameCanonicalLeafSubPlan(sql, sql);
    }

    private void assertSameCanonicalLeafSubPlan(String sql1, String sql2) throws Exception {
        SubPlan subplan = this.subplan(String.format("( %s ) UNION ALL ( %s )", sql1, sql2), Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, false);
        List leafCanonicalPlans = TestCanonicalPlanGenerator.getLeafSubPlans(subplan).stream().map(SubPlan::getFragment).map(fragment -> CanonicalPlanGenerator.generateCanonicalPlanFragment((PlanNode)fragment.getRoot(), (PartitioningScheme)fragment.getPartitioningScheme(), (ObjectMapper)this.objectMapper, (Session)this.getQueryRunner().getDefaultSession())).map(Optional::get).collect(Collectors.toList());
        Assert.assertEquals((int)leafCanonicalPlans.size(), (int)2);
        Assert.assertEquals(leafCanonicalPlans.get(0), leafCanonicalPlans.get(1));
        String s1 = this.objectMapper.writeValueAsString(leafCanonicalPlans.get(0));
        String s2 = this.objectMapper.writeValueAsString(leafCanonicalPlans.get(0));
        Assert.assertEquals((String)s1, (String)s2);
    }

    private void assertDifferentCanonicalLeafSubPlan(String sql1, String sql2) throws Exception {
        PlanFragment fragment1 = ((SubPlan)Iterables.getOnlyElement(TestCanonicalPlanGenerator.getLeafSubPlans(this.subplan(sql1, Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, false)))).getFragment();
        PlanFragment fragment2 = ((SubPlan)Iterables.getOnlyElement(TestCanonicalPlanGenerator.getLeafSubPlans(this.subplan(sql2, Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, false)))).getFragment();
        Optional canonicalPlan1 = CanonicalPlanGenerator.generateCanonicalPlanFragment((PlanNode)fragment1.getRoot(), (PartitioningScheme)fragment1.getPartitioningScheme(), (ObjectMapper)this.objectMapper, (Session)this.getQueryRunner().getDefaultSession());
        Optional canonicalPlan2 = CanonicalPlanGenerator.generateCanonicalPlanFragment((PlanNode)fragment2.getRoot(), (PartitioningScheme)fragment2.getPartitioningScheme(), (ObjectMapper)this.objectMapper, (Session)this.getQueryRunner().getDefaultSession());
        Assert.assertTrue((boolean)canonicalPlan1.isPresent());
        Assert.assertTrue((boolean)canonicalPlan2.isPresent());
        Assert.assertNotEquals((Object)this.objectMapper.writeValueAsString((Object)canonicalPlan1), (Object)this.objectMapper.writeValueAsString((Object)canonicalPlan2));
    }

    private void assertSameCanonicalLeafPlan(String sql1, String sql2, PlanCanonicalizationStrategy strategy) throws Exception {
        SubPlan subplan = this.subplan(String.format("( %s ) UNION ALL ( %s )", sql1, sql2), Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, false);
        List leafCanonicalPlans = TestCanonicalPlanGenerator.getLeafSubPlans(subplan).stream().map(SubPlan::getFragment).map(fragment -> CanonicalPlanGenerator.generateCanonicalPlan((PlanNode)fragment.getRoot(), (PlanCanonicalizationStrategy)strategy, (ObjectMapper)this.objectMapper, (Session)this.getQueryRunner().getDefaultSession())).map(Optional::get).collect(Collectors.toList());
        Assert.assertEquals((int)leafCanonicalPlans.size(), (int)2);
        Assert.assertEquals(leafCanonicalPlans.get(0), leafCanonicalPlans.get(1));
        String s1 = this.objectMapper.writeValueAsString(leafCanonicalPlans.get(0));
        String s2 = this.objectMapper.writeValueAsString(leafCanonicalPlans.get(0));
        Assert.assertEquals((String)s1, (String)s2);
    }

    private void assertDifferentCanonicalLeafPlan(String sql1, String sql2, PlanCanonicalizationStrategy strategy) throws Exception {
        PlanFragment fragment1 = ((SubPlan)Iterables.getOnlyElement(TestCanonicalPlanGenerator.getLeafSubPlans(this.subplan(sql1, Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, false)))).getFragment();
        PlanFragment fragment2 = ((SubPlan)Iterables.getOnlyElement(TestCanonicalPlanGenerator.getLeafSubPlans(this.subplan(sql2, Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, false)))).getFragment();
        Optional canonicalPlan1 = CanonicalPlanGenerator.generateCanonicalPlan((PlanNode)fragment1.getRoot(), (PlanCanonicalizationStrategy)strategy, (ObjectMapper)this.objectMapper, (Session)this.getQueryRunner().getDefaultSession());
        Optional canonicalPlan2 = CanonicalPlanGenerator.generateCanonicalPlan((PlanNode)fragment2.getRoot(), (PlanCanonicalizationStrategy)strategy, (ObjectMapper)this.objectMapper, (Session)this.getQueryRunner().getDefaultSession());
        Assert.assertTrue((boolean)canonicalPlan1.isPresent());
        Assert.assertTrue((boolean)canonicalPlan2.isPresent());
        Assert.assertNotEquals((Object)this.objectMapper.writeValueAsString((Object)canonicalPlan1), (Object)this.objectMapper.writeValueAsString((Object)canonicalPlan2));
    }

    @Test
    public void testCanonicalPartitioningScheme() {
        Assert.assertEquals((Set)((Set)Arrays.stream(PartitioningScheme.class.getDeclaredFields()).filter(f -> !f.isSynthetic()).map(Field::getName).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"partitioning", (Object)"outputLayout", (Object)"hashColumn", (Object)"replicateNullsAndAny", (Object)"bucketToPartition"));
        Assert.assertEquals((Set)((Set)Arrays.stream(Partitioning.class.getDeclaredFields()).filter(f -> !f.isSynthetic()).map(Field::getName).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"handle", (Object)"arguments"));
        Assert.assertEquals((Set)((Set)Arrays.stream(PartitioningHandle.class.getDeclaredFields()).filter(f -> !f.isSynthetic()).map(Field::getName).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"connectorId", (Object)"transactionHandle", (Object)"connectorHandle"));
        Assert.assertEquals((Set)((Set)Arrays.stream(CanonicalPartitioningScheme.class.getDeclaredFields()).filter(f -> !f.isSynthetic()).map(Field::getName).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"connectorId", (Object)"connectorHandle", (Object)"arguments", (Object)"outputLayout"));
    }

    @Test
    public void testCanonicalTableScanNodeField() {
        Assert.assertEquals((Set)((Set)Arrays.stream(TableScanNode.class.getDeclaredFields()).filter(f -> !f.isSynthetic()).map(Field::getName).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"table", (Object)"assignments", (Object)"outputVariables", (Object)"currentConstraint", (Object)"enforcedConstraint", (Object)"tableConstraints", (Object[])new String[0]));
        Assert.assertEquals((Set)((Set)Arrays.stream(CanonicalTableScanNode.class.getDeclaredFields()).filter(f -> !f.isSynthetic()).map(Field::getName).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"table", (Object)"assignments", (Object)"outputVariables"));
        Assert.assertEquals((Set)((Set)Arrays.stream(TableHandle.class.getDeclaredFields()).filter(f -> !f.isSynthetic()).map(Field::getName).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"connectorId", (Object)"connectorHandle", (Object)"transaction", (Object)"layout", (Object)"dynamicFilter"));
        Assert.assertEquals((Set)((Set)Arrays.stream(CanonicalTableScanNode.CanonicalTableHandle.class.getDeclaredFields()).filter(f -> !f.isSynthetic()).map(Field::getName).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"connectorId", (Object)"tableHandle", (Object)"layoutIdentifier", (Object)"layoutHandle"));
    }
}

