/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.InequalityInference;
import com.facebook.presto.sql.planner.TestEqualityInference;
import com.facebook.presto.sql.planner.optimizations.ExpressionEquivalence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInequalityInference {
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = FunctionAndTypeManager.createTestFunctionAndTypeManager();
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final MetadataManager METADATA = MetadataManager.createTestMetadataManager();
    private static final ExpressionEquivalence EXPRESSION_EQUIVALENCE = new ExpressionEquivalence((Metadata)METADATA, SQL_PARSER);

    @Test
    public void testCanonicalization() {
        InequalityInference.Builder builder = new InequalityInference.Builder(FUNCTION_AND_TYPE_MANAGER, EXPRESSION_EQUIVALENCE, Optional.empty());
        CallExpression canonicalExpression = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a1"), (RowExpression)TestEqualityInference.variable("a2"));
        CallExpression expression = TestEqualityInference.compare(OperatorType.GREATER_THAN, (RowExpression)TestEqualityInference.variable("a2"), (RowExpression)TestEqualityInference.variable("a1"));
        Assert.assertEquals((Object)builder.canonicalizeInequality((RowExpression)expression), (Object)canonicalExpression);
        canonicalExpression = TestEqualityInference.compare(OperatorType.LESS_THAN_OR_EQUAL, (RowExpression)TestEqualityInference.variable("a1"), (RowExpression)TestEqualityInference.variable("a2"));
        expression = TestEqualityInference.compare(OperatorType.GREATER_THAN_OR_EQUAL, (RowExpression)TestEqualityInference.variable("a2"), (RowExpression)TestEqualityInference.variable("a1"));
        Assert.assertEquals((Object)builder.canonicalizeInequality((RowExpression)expression), (Object)canonicalExpression);
        canonicalExpression = TestEqualityInference.compare(OperatorType.LESS_THAN, TestEqualityInference.add("a1", "a2"), (RowExpression)TestEqualityInference.variable("a3"));
        expression = TestEqualityInference.compare(OperatorType.GREATER_THAN, (RowExpression)TestEqualityInference.variable("a3"), TestEqualityInference.add("a1", "a2"));
        Assert.assertEquals((Object)builder.canonicalizeInequality((RowExpression)expression), (Object)canonicalExpression);
        canonicalExpression = TestEqualityInference.compare(OperatorType.LESS_THAN, TestEqualityInference.multiply("a1", "a2"), (RowExpression)TestEqualityInference.variable("a3"));
        expression = TestEqualityInference.compare(OperatorType.GREATER_THAN, (RowExpression)TestEqualityInference.variable("a3"), TestEqualityInference.multiply("a1", "a2"));
        Assert.assertEquals((Object)builder.canonicalizeInequality((RowExpression)expression), (Object)canonicalExpression);
        canonicalExpression = TestEqualityInference.compare(OperatorType.LESS_THAN, TestEqualityInference.add("a1", "a2"), (RowExpression)TestEqualityInference.variable("a3"));
        expression = TestEqualityInference.compare(OperatorType.GREATER_THAN, (RowExpression)TestEqualityInference.variable("a3"), TestEqualityInference.add("a2", "a1"));
        Assert.assertNotEquals((Object)builder.canonicalizeInequality((RowExpression)expression), (Object)canonicalExpression);
    }

    @Test
    public void testSimpleTransitivity() {
        InequalityInference.Builder builder = new InequalityInference.Builder(FUNCTION_AND_TYPE_MANAGER, EXPRESSION_EQUIVALENCE, Optional.empty());
        CallExpression exp1 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.number(5L));
        CallExpression exp2 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a2"), (RowExpression)TestEqualityInference.variable("a1"));
        ImmutableSet toBeInferred = ImmutableSet.of((Object)TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a2"), TestEqualityInference.number(5L)));
        this.assertInferredInequalites((ImmutableSet<RowExpression>)toBeInferred, builder, new RowExpression[]{exp1, exp2});
        builder = new InequalityInference.Builder(FUNCTION_AND_TYPE_MANAGER, EXPRESSION_EQUIVALENCE, Optional.empty());
        exp1 = TestEqualityInference.compare(OperatorType.GREATER_THAN, (RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.number(5L));
        exp2 = TestEqualityInference.compare(OperatorType.GREATER_THAN, (RowExpression)TestEqualityInference.variable("a2"), (RowExpression)TestEqualityInference.variable("a1"));
        toBeInferred = ImmutableSet.of((Object)TestEqualityInference.compare(OperatorType.LESS_THAN, TestEqualityInference.number(5L), (RowExpression)TestEqualityInference.variable("a2")));
        this.assertInferredInequalites((ImmutableSet<RowExpression>)toBeInferred, builder, new RowExpression[]{exp1, exp2});
        builder = new InequalityInference.Builder(FUNCTION_AND_TYPE_MANAGER, EXPRESSION_EQUIVALENCE, Optional.empty());
        exp1 = TestEqualityInference.compare(OperatorType.LESS_THAN_OR_EQUAL, (RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.number(5L));
        exp2 = TestEqualityInference.compare(OperatorType.LESS_THAN_OR_EQUAL, (RowExpression)TestEqualityInference.variable("a2"), (RowExpression)TestEqualityInference.variable("a1"));
        toBeInferred = ImmutableSet.of((Object)TestEqualityInference.compare(OperatorType.LESS_THAN_OR_EQUAL, (RowExpression)TestEqualityInference.variable("a2"), TestEqualityInference.number(5L)));
        this.assertInferredInequalites((ImmutableSet<RowExpression>)toBeInferred, builder, new RowExpression[]{exp1, exp2});
        builder = new InequalityInference.Builder(FUNCTION_AND_TYPE_MANAGER, EXPRESSION_EQUIVALENCE, Optional.empty());
        exp1 = TestEqualityInference.compare(OperatorType.GREATER_THAN_OR_EQUAL, (RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.number(5L));
        exp2 = TestEqualityInference.compare(OperatorType.GREATER_THAN_OR_EQUAL, (RowExpression)TestEqualityInference.variable("a2"), (RowExpression)TestEqualityInference.variable("a1"));
        toBeInferred = ImmutableSet.of((Object)TestEqualityInference.compare(OperatorType.LESS_THAN_OR_EQUAL, TestEqualityInference.number(5L), (RowExpression)TestEqualityInference.variable("a2")));
        this.assertInferredInequalites((ImmutableSet<RowExpression>)toBeInferred, builder, new RowExpression[]{exp1, exp2});
        builder = new InequalityInference.Builder(FUNCTION_AND_TYPE_MANAGER, EXPRESSION_EQUIVALENCE, Optional.empty());
        exp1 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.number(5L));
        exp2 = TestEqualityInference.compare(OperatorType.GREATER_THAN, (RowExpression)TestEqualityInference.variable("a1"), (RowExpression)TestEqualityInference.variable("a2"));
        toBeInferred = ImmutableSet.of((Object)TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a2"), TestEqualityInference.number(5L)));
        this.assertInferredInequalites((ImmutableSet<RowExpression>)toBeInferred, builder, new RowExpression[]{exp1, exp2});
        builder = new InequalityInference.Builder(FUNCTION_AND_TYPE_MANAGER, EXPRESSION_EQUIVALENCE, Optional.empty());
        exp1 = TestEqualityInference.compare(OperatorType.GREATER_THAN, (RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.number(5L));
        exp2 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a1"), (RowExpression)TestEqualityInference.variable("a2"));
        toBeInferred = ImmutableSet.of((Object)TestEqualityInference.compare(OperatorType.LESS_THAN, TestEqualityInference.number(5L), (RowExpression)TestEqualityInference.variable("a2")));
        this.assertInferredInequalites((ImmutableSet<RowExpression>)toBeInferred, builder, new RowExpression[]{exp1, exp2});
        builder = new InequalityInference.Builder(FUNCTION_AND_TYPE_MANAGER, EXPRESSION_EQUIVALENCE, Optional.empty());
        exp1 = TestEqualityInference.compare(OperatorType.GREATER_THAN_OR_EQUAL, (RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.number(5L));
        exp2 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a1"), (RowExpression)TestEqualityInference.variable("a2"));
        toBeInferred = ImmutableSet.of((Object)TestEqualityInference.compare(OperatorType.LESS_THAN, TestEqualityInference.number(5L), (RowExpression)TestEqualityInference.variable("a2")));
        this.assertInferredInequalites((ImmutableSet<RowExpression>)toBeInferred, builder, new RowExpression[]{exp1, exp2});
        builder = new InequalityInference.Builder(FUNCTION_AND_TYPE_MANAGER, EXPRESSION_EQUIVALENCE, Optional.empty());
        exp1 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.number(5L));
        exp2 = TestEqualityInference.compare(OperatorType.GREATER_THAN_OR_EQUAL, (RowExpression)TestEqualityInference.variable("a1"), (RowExpression)TestEqualityInference.variable("a2"));
        toBeInferred = ImmutableSet.of((Object)TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a2"), TestEqualityInference.number(5L)));
        this.assertInferredInequalites((ImmutableSet<RowExpression>)toBeInferred, builder, new RowExpression[]{exp1, exp2});
        builder = new InequalityInference.Builder(FUNCTION_AND_TYPE_MANAGER, EXPRESSION_EQUIVALENCE, Optional.of(ImmutableList.of((Object)TestEqualityInference.variable("a2"))));
        exp1 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.number(5L));
        exp2 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a2"), (RowExpression)TestEqualityInference.variable("a1"));
        toBeInferred = ImmutableSet.of();
        this.assertInferredInequalites((ImmutableSet<RowExpression>)toBeInferred, builder, new RowExpression[]{exp1, exp2});
    }

    @Test
    public void testChainOfTransitivity() {
        InequalityInference.Builder builder = new InequalityInference.Builder(FUNCTION_AND_TYPE_MANAGER, EXPRESSION_EQUIVALENCE, Optional.empty());
        CallExpression exp1 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.number(5L));
        CallExpression exp2 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a2"), (RowExpression)TestEqualityInference.variable("a1"));
        CallExpression exp3 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a3"), (RowExpression)TestEqualityInference.variable("a2"));
        CallExpression exp4 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a4"), (RowExpression)TestEqualityInference.variable("a3"));
        ImmutableSet toBeInferred = ImmutableSet.of((Object)TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a2"), TestEqualityInference.number(5L)), (Object)TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a3"), TestEqualityInference.number(5L)), (Object)TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a4"), TestEqualityInference.number(5L)));
        this.assertInferredInequalites((ImmutableSet<RowExpression>)toBeInferred, builder, new RowExpression[]{exp1, exp2, exp3, exp4});
        builder = new InequalityInference.Builder(FUNCTION_AND_TYPE_MANAGER, EXPRESSION_EQUIVALENCE, Optional.empty());
        exp1 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.number(10L));
        exp2 = TestEqualityInference.compare(OperatorType.GREATER_THAN_OR_EQUAL, (RowExpression)TestEqualityInference.variable("a1"), (RowExpression)TestEqualityInference.variable("a2"));
        exp3 = TestEqualityInference.compare(OperatorType.EQUAL, (RowExpression)TestEqualityInference.variable("a3"), (RowExpression)TestEqualityInference.variable("a2"));
        exp4 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a4"), (RowExpression)TestEqualityInference.variable("a3"));
        toBeInferred = ImmutableSet.of((Object)TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a2"), TestEqualityInference.number(10L)));
        this.assertInferredInequalites((ImmutableSet<RowExpression>)toBeInferred, builder, new RowExpression[]{exp1, exp2, exp3, exp4});
        builder = new InequalityInference.Builder(FUNCTION_AND_TYPE_MANAGER, EXPRESSION_EQUIVALENCE, Optional.empty());
        exp1 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.number(10L));
        exp2 = TestEqualityInference.compare(OperatorType.GREATER_THAN_OR_EQUAL, (RowExpression)TestEqualityInference.variable("a1"), (RowExpression)TestEqualityInference.variable("a2"));
        exp3 = TestEqualityInference.compare(OperatorType.LESS_THAN_OR_EQUAL, (RowExpression)TestEqualityInference.variable("a3"), (RowExpression)TestEqualityInference.variable("a2"));
        exp4 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a4"), (RowExpression)TestEqualityInference.variable("a3"));
        CallExpression exp5 = TestEqualityInference.compare(OperatorType.GREATER_THAN, (RowExpression)TestEqualityInference.variable("a4"), TestEqualityInference.number(1L));
        CallExpression exp6 = TestEqualityInference.compare(OperatorType.GREATER_THAN_OR_EQUAL, (RowExpression)TestEqualityInference.variable("a5"), (RowExpression)TestEqualityInference.variable("a4"));
        CallExpression exp7 = TestEqualityInference.compare(OperatorType.LESS_THAN_OR_EQUAL, (RowExpression)TestEqualityInference.variable("a5"), (RowExpression)TestEqualityInference.variable("a6"));
        toBeInferred = ImmutableSet.of((Object)TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a2"), TestEqualityInference.number(10L)), (Object)TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a3"), TestEqualityInference.number(10L)), (Object)TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a4"), TestEqualityInference.number(10L)), (Object)TestEqualityInference.compare(OperatorType.LESS_THAN, TestEqualityInference.number(1L), (RowExpression)TestEqualityInference.variable("a5")), (Object)TestEqualityInference.compare(OperatorType.LESS_THAN, TestEqualityInference.number(1L), (RowExpression)TestEqualityInference.variable("a6")), (Object)TestEqualityInference.compare(OperatorType.LESS_THAN, TestEqualityInference.number(1L), (RowExpression)TestEqualityInference.variable("a3")), (Object[])new RowExpression[]{TestEqualityInference.compare(OperatorType.LESS_THAN, TestEqualityInference.number(1L), (RowExpression)TestEqualityInference.variable("a2")), TestEqualityInference.compare(OperatorType.LESS_THAN, TestEqualityInference.number(1L), (RowExpression)TestEqualityInference.variable("a1"))});
        this.assertInferredInequalites((ImmutableSet<RowExpression>)toBeInferred, builder, new RowExpression[]{exp1, exp2, exp3, exp4, exp5, exp6, exp7});
        builder = new InequalityInference.Builder(FUNCTION_AND_TYPE_MANAGER, EXPRESSION_EQUIVALENCE, Optional.of(ImmutableList.of((Object)TestEqualityInference.variable("a5"), (Object)TestEqualityInference.variable("a4"))));
        exp1 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.number(10L));
        exp2 = TestEqualityInference.compare(OperatorType.GREATER_THAN_OR_EQUAL, (RowExpression)TestEqualityInference.variable("a1"), (RowExpression)TestEqualityInference.variable("a2"));
        exp3 = TestEqualityInference.compare(OperatorType.LESS_THAN_OR_EQUAL, (RowExpression)TestEqualityInference.variable("a3"), (RowExpression)TestEqualityInference.variable("a2"));
        exp4 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a4"), (RowExpression)TestEqualityInference.variable("a3"));
        exp5 = TestEqualityInference.compare(OperatorType.GREATER_THAN, (RowExpression)TestEqualityInference.variable("a4"), TestEqualityInference.number(1L));
        exp6 = TestEqualityInference.compare(OperatorType.GREATER_THAN_OR_EQUAL, (RowExpression)TestEqualityInference.variable("a5"), (RowExpression)TestEqualityInference.variable("a4"));
        exp7 = TestEqualityInference.compare(OperatorType.LESS_THAN_OR_EQUAL, (RowExpression)TestEqualityInference.variable("a5"), (RowExpression)TestEqualityInference.variable("a6"));
        toBeInferred = ImmutableSet.of((Object)TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a2"), TestEqualityInference.number(10L)), (Object)TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a3"), TestEqualityInference.number(10L)), (Object)TestEqualityInference.compare(OperatorType.LESS_THAN, TestEqualityInference.number(1L), (RowExpression)TestEqualityInference.variable("a3")), (Object)TestEqualityInference.compare(OperatorType.LESS_THAN, TestEqualityInference.number(1L), (RowExpression)TestEqualityInference.variable("a2")), (Object)TestEqualityInference.compare(OperatorType.LESS_THAN, TestEqualityInference.number(1L), (RowExpression)TestEqualityInference.variable("a1")));
        this.assertInferredInequalites((ImmutableSet<RowExpression>)toBeInferred, builder, new RowExpression[]{exp1, exp2, exp3, exp4, exp5, exp6, exp7});
    }

    @Test
    public void testTransitivityWithExpressions() {
        RowExpression a1Plusa2 = TestEqualityInference.add("a1", "a2");
        RowExpression a2Plusa1 = TestEqualityInference.add("a2", "a1");
        RowExpression a3Multiplya4 = TestEqualityInference.multiply("a3", "a4");
        RowExpression a4Multiplya3 = TestEqualityInference.multiply("a4", "a3");
        InequalityInference.Builder builder = new InequalityInference.Builder(FUNCTION_AND_TYPE_MANAGER, EXPRESSION_EQUIVALENCE, Optional.empty());
        CallExpression exp1 = TestEqualityInference.compare(OperatorType.LESS_THAN, a1Plusa2, TestEqualityInference.number(5L));
        CallExpression exp2 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a5"), a2Plusa1);
        CallExpression exp3 = TestEqualityInference.compare(OperatorType.LESS_THAN, a3Multiplya4, TestEqualityInference.number(100L));
        CallExpression exp4 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a6"), a4Multiplya3);
        ImmutableSet toBeInferred = ImmutableSet.of((Object)TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a5"), TestEqualityInference.number(5L)), (Object)TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a6"), TestEqualityInference.number(100L)));
        this.assertInferredInequalites((ImmutableSet<RowExpression>)toBeInferred, builder, new RowExpression[]{exp1, exp2, exp3, exp4});
        RowExpression a1Plusa2Multiplya3 = TestEqualityInference.multiply(TestEqualityInference.add("a1", "a2"), (RowExpression)TestEqualityInference.variable("a3"));
        RowExpression a3Multiplya2Plusa1 = TestEqualityInference.multiply((RowExpression)TestEqualityInference.variable("a3"), TestEqualityInference.add("a1", "a2"));
        builder = new InequalityInference.Builder(FUNCTION_AND_TYPE_MANAGER, EXPRESSION_EQUIVALENCE, Optional.empty());
        exp1 = TestEqualityInference.compare(OperatorType.LESS_THAN, a1Plusa2Multiplya3, TestEqualityInference.number(5L));
        exp2 = TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a5"), a3Multiplya2Plusa1);
        toBeInferred = ImmutableSet.of((Object)TestEqualityInference.compare(OperatorType.LESS_THAN, (RowExpression)TestEqualityInference.variable("a5"), TestEqualityInference.number(5L)));
        this.assertInferredInequalites((ImmutableSet<RowExpression>)toBeInferred, builder, new RowExpression[]{exp1, exp2});
    }

    private void assertInferredInequalites(ImmutableSet<RowExpression> expectedInequalities, InequalityInference.Builder builder, RowExpression ... expressions) {
        Assert.assertEquals((Set)builder.addInequalityInferences(expressions).build().inferInequalities(), expectedInequalities);
    }
}

