/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.testing.Closeables;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.execution.FragmentResultCacheContext;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.StageExecutionDescriptor;
import com.facebook.presto.operator.TableScanOperator;
import com.facebook.presto.operator.TaskOutputOperator;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.Optimizer;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.RemoteSourceFactory;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.TestingOutputBuffer;
import com.facebook.presto.sql.planner.TestingRemoteSourceFactory;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingHandle;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestLocalExecutionPlanner {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s"));
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
    private LocalQueryRunner runner;

    @BeforeClass
    public void setUp() {
        this.runner = new LocalQueryRunner(SessionTestUtils.TEST_SESSION);
        this.runner.createCatalog((String)this.runner.getDefaultSession().getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.runner});
        this.runner = null;
    }

    @Test(enabled=false)
    public void testCompilerFailure() {
        String inner = "(" + Joiner.on((String)" + ").join(Collections.nCopies(100, "rand()")) + ")";
        String outer = Joiner.on((String)" + ").join(Collections.nCopies(100, inner));
        this.assertFails("SELECT " + outer, (ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR);
    }

    private void assertFails(@Language(value="SQL") String sql, ErrorCodeSupplier supplier) {
        try {
            this.runner.execute(sql);
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)supplier.toErrorCode());
        }
    }

    @Test
    public void testCreatingFragmentResultCacheContext() {
        Session session = Session.builder((Session)this.runner.getDefaultSession()).setSystemProperty("fragment_result_caching_enabled", "true").build();
        LocalExecutionPlanner.LocalExecutionPlan planWithoutIntermediateAggregation = this.getLocalExecutionPlan(session);
        Assert.assertEquals((int)planWithoutIntermediateAggregation.getDriverFactories().size(), (int)1);
        Optional contextWithoutIntermediateAggregation = ((DriverFactory)planWithoutIntermediateAggregation.getDriverFactories().get(0)).getFragmentResultCacheContext();
        Assert.assertTrue((boolean)contextWithoutIntermediateAggregation.isPresent());
        session = Session.builder((Session)this.runner.getDefaultSession()).setSystemProperty("fragment_result_caching_enabled", "true").setSystemProperty("enable_intermediate_aggregations", "true").build();
        LocalExecutionPlanner.LocalExecutionPlan planWithIntermediateAggregation = this.getLocalExecutionPlan(session);
        Assert.assertEquals((int)planWithIntermediateAggregation.getDriverFactories().size(), (int)2);
        Optional contextWithIntermediateAggregation = ((DriverFactory)planWithIntermediateAggregation.getDriverFactories().get(0)).getFragmentResultCacheContext();
        Assert.assertTrue((boolean)contextWithIntermediateAggregation.isPresent());
        Assert.assertEquals((String)((FragmentResultCacheContext)contextWithIntermediateAggregation.get()).getHashedCanonicalPlanFragment(), (String)((FragmentResultCacheContext)contextWithoutIntermediateAggregation.get()).getHashedCanonicalPlanFragment());
    }

    @Test
    public void testCustomPlanTranslator() {
        VariableReferenceExpression variable = new VariableReferenceExpression(Optional.empty(), "column", (Type)VarcharType.VARCHAR);
        TableScanNode scan = new TableScanNode(Optional.empty(), new PlanNodeId("sourceId"), new TableHandle(new ConnectorId("test"), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(TestingHandle.INSTANCE)), (List)ImmutableList.of((Object)variable), (Map)ImmutableMap.of((Object)variable, (Object)new TestingMetadata.TestingColumnHandle("column")), TupleDomain.all(), TupleDomain.all());
        CustomNodeA node1 = new CustomNodeA(new PlanNodeId("node1"), (PlanNode)scan);
        CustomNodeB node2 = new CustomNodeB(new PlanNodeId("node2"), node1);
        LocalExecutionPlanner.LocalExecutionPlan plan = this.getLocalExecutionPlan(this.runner.getDefaultSession(), node2, (List<LocalExecutionPlanner.CustomPlanTranslator>)ImmutableList.of((Object)((Object)new CustomOperatorAFactory.PlanTranslator()), (Object)((Object)new CustomOperatorBFactory.PlanTranslator())));
        List driverFactories = plan.getDriverFactories();
        Assert.assertEquals((int)driverFactories.size(), (int)1);
        List operatorFactories = ((DriverFactory)driverFactories.get(0)).getOperatorFactories();
        Assert.assertEquals((int)operatorFactories.size(), (int)4);
        Assert.assertTrue((boolean)(operatorFactories.get(0) instanceof TableScanOperator.TableScanOperatorFactory));
        Assert.assertTrue((boolean)(operatorFactories.get(1) instanceof CustomOperatorAFactory));
        Assert.assertTrue((boolean)(operatorFactories.get(2) instanceof CustomOperatorBFactory));
        Assert.assertTrue((boolean)(operatorFactories.get(3) instanceof TaskOutputOperator.TaskOutputOperatorFactory));
    }

    private LocalExecutionPlanner.LocalExecutionPlan getLocalExecutionPlan(Session session, PlanNode plan, List<LocalExecutionPlanner.CustomPlanTranslator> customPlanTranslators) {
        PlanFragment testFragment = new PlanFragment(new PlanFragmentId(0), plan, (Set)ImmutableSet.of(), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)new PlanNodeId("sourceId")), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (Collection)ImmutableList.of()), (List)ImmutableList.of()), StageExecutionDescriptor.ungroupedExecution(), false, StatsAndCosts.empty(), Optional.empty());
        return TaskTestUtils.createTestingPlanner().plan(TestingTaskContext.createTaskContext((Executor)EXECUTOR, (ScheduledExecutorService)SCHEDULED_EXECUTOR, (Session)session), testFragment, (OutputBuffer)new TestingOutputBuffer(), (RemoteSourceFactory)new TestingRemoteSourceFactory(), new TableWriteInfo(Optional.empty(), Optional.empty(), Optional.empty()), customPlanTranslators);
    }

    private LocalExecutionPlanner.LocalExecutionPlan getLocalExecutionPlan(Session session) {
        SubPlan subPlan = (SubPlan)this.runner.inTransaction(session, transactionSession -> {
            Plan plan = this.runner.createPlan(transactionSession, "SELECT avg(totalprice) FROM orders", Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, false, WarningCollector.NOOP);
            return this.runner.createSubPlans(transactionSession, plan, false);
        });
        Assert.assertEquals((int)subPlan.getChildren().size(), (int)1);
        PlanFragment leafFragment = ((SubPlan)subPlan.getChildren().get(0)).getFragment();
        return TaskTestUtils.createTestingPlanner().plan(TestingTaskContext.createTaskContext((Executor)EXECUTOR, (ScheduledExecutorService)SCHEDULED_EXECUTOR, (Session)session), leafFragment, (OutputBuffer)new TestingOutputBuffer(), (RemoteSourceFactory)new TestingRemoteSourceFactory(), new TableWriteInfo(Optional.empty(), Optional.empty(), Optional.empty()));
    }

    public static abstract class CustomOperatorFactory
    implements OperatorFactory {
        protected final int operatorId;
        protected final PlanNodeId sourceId;

        public CustomOperatorFactory(int operatorId, PlanNodeId sourceId) {
            this.operatorId = operatorId;
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
        }

        public abstract Operator createOperator(DriverContext var1);

        public synchronized void noMoreOperators(Lifespan lifespan) {
        }

        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException();
        }

        public void noMoreOperators() {
        }

        public static class CustomOperator
        implements Operator {
            private final OperatorContext operatorContext;
            private final PlanNodeId planNodeId;
            private boolean finished;

            public CustomOperator(OperatorContext operatorContext, PlanNodeId planNodeId) {
                this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
                this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            }

            public OperatorContext getOperatorContext() {
                return this.operatorContext;
            }

            public void close() {
                this.finish();
            }

            public void finish() {
                this.finished = true;
            }

            public boolean isFinished() {
                return this.finished;
            }

            public boolean needsInput() {
                return false;
            }

            public void addInput(Page page) {
                throw new UnsupportedOperationException(this.getClass().getName() + " can not take input");
            }

            public Page getOutput() {
                return null;
            }
        }
    }

    public static class CustomOperatorBFactory
    extends CustomOperatorFactory {
        public CustomOperatorBFactory(int operatorId, PlanNodeId sourceId) {
            super(operatorId, sourceId);
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.sourceId, CustomOperatorB.class.getSimpleName());
            return new CustomOperatorB(operatorContext, this.sourceId);
        }

        public class CustomOperatorB
        extends CustomOperatorFactory.CustomOperator {
            public CustomOperatorB(OperatorContext operatorContext, PlanNodeId planNodeId) {
                super(operatorContext, planNodeId);
            }
        }

        public static class PlanTranslator
        extends LocalExecutionPlanner.CustomPlanTranslator {
            public Optional<LocalExecutionPlanner.PhysicalOperation> translate(PlanNode node, LocalExecutionPlanner.LocalExecutionPlanContext context, InternalPlanVisitor<LocalExecutionPlanner.PhysicalOperation, LocalExecutionPlanner.LocalExecutionPlanContext> visitor) {
                if (node instanceof CustomNodeB) {
                    CustomOperatorBFactory operatorFactory = new CustomOperatorBFactory(context.getNextOperatorId(), node.getId());
                    LocalExecutionPlanner.PhysicalOperation sourceOperator = (LocalExecutionPlanner.PhysicalOperation)((CustomNodeB)node).getSource().accept(visitor, (Object)context);
                    return Optional.of(new LocalExecutionPlanner.PhysicalOperation((OperatorFactory)operatorFactory, (Map)this.makeLayout(node), context, sourceOperator));
                }
                return Optional.empty();
            }
        }
    }

    public static class CustomOperatorAFactory
    extends CustomOperatorFactory {
        public CustomOperatorAFactory(int operatorId, PlanNodeId sourceId) {
            super(operatorId, sourceId);
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.sourceId, CustomOperatorA.class.getSimpleName());
            return new CustomOperatorA(operatorContext, this.sourceId);
        }

        public static class CustomOperatorA
        extends CustomOperatorFactory.CustomOperator {
            public CustomOperatorA(OperatorContext operatorContext, PlanNodeId planNodeId) {
                super(operatorContext, planNodeId);
            }
        }

        public static class PlanTranslator
        extends LocalExecutionPlanner.CustomPlanTranslator {
            public Optional<LocalExecutionPlanner.PhysicalOperation> translate(PlanNode node, LocalExecutionPlanner.LocalExecutionPlanContext context, InternalPlanVisitor<LocalExecutionPlanner.PhysicalOperation, LocalExecutionPlanner.LocalExecutionPlanContext> visitor) {
                if (node instanceof CustomNodeA) {
                    CustomOperatorAFactory operatorFactory = new CustomOperatorAFactory(context.getNextOperatorId(), node.getId());
                    LocalExecutionPlanner.PhysicalOperation sourceOperator = (LocalExecutionPlanner.PhysicalOperation)((CustomNodeA)node).getSource().accept(visitor, (Object)context);
                    return Optional.of(new LocalExecutionPlanner.PhysicalOperation((OperatorFactory)operatorFactory, (Map)this.makeLayout(node), context, sourceOperator));
                }
                return Optional.empty();
            }
        }
    }

    private static class CustomNode
    extends PlanNode {
        private final PlanNode source;

        protected CustomNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source) {
            super(sourceLocation, id, statsEquivalentPlanNode);
            this.source = source;
        }

        public PlanNode getSource() {
            return this.source;
        }

        public List<PlanNode> getSources() {
            return Collections.singletonList(this.source);
        }

        public List<VariableReferenceExpression> getOutputVariables() {
            return ImmutableList.of();
        }

        public PlanNode replaceChildren(List<PlanNode> newChildren) {
            throw new UnsupportedOperationException();
        }

        public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
            throw new UnsupportedOperationException();
        }
    }

    private static class CustomNodeB
    extends CustomNode {
        protected CustomNodeB(PlanNodeId id, PlanNode source) {
            super(Optional.empty(), id, Optional.empty(), source);
        }
    }

    private static class CustomNodeA
    extends CustomNode {
        protected CustomNodeA(PlanNodeId id, PlanNode source) {
            super(Optional.empty(), id, Optional.empty(), source);
        }
    }
}

