/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.tree.SortItem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPushDownDereferences
extends BasePlanTest {
    public TestPushDownDereferences() {
        super((Map<String, String>)ImmutableMap.of((Object)"pushdown_subfields_enabled", (Object)"true", (Object)"pushdown_dereference_enabled", (Object)"true"));
    }

    @Test
    public void testJoin() {
        this.assertPlan("WITH t(msg) AS (SELECT * FROM (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))))) SELECT b.msg.x FROM t a, t b WHERE a.msg.y = b.msg.y", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"b_x"), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("a_y", "b_y")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_y", (Object)PlanMatchPattern.expression("msg.y")), PlanMatchPattern.values("msg"))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b_y", (Object)PlanMatchPattern.expression("msg.y"), (Object)"b_x", (Object)PlanMatchPattern.expression("msg.x")), PlanMatchPattern.values("msg"))))));
        this.assertPlan("WITH t(msg) AS ( SELECT * FROM (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))))) SELECT a.msg.y FROM t a JOIN t b ON a.msg.y = b.msg.y WHERE a.msg.x > bigint '5'", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"a_y"), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("a_y", "b_y")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_y", (Object)PlanMatchPattern.expression("msg.y")), PlanMatchPattern.filter("msg.x > bigint '5'", PlanMatchPattern.values("msg")))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b_y", (Object)PlanMatchPattern.expression("msg.y")), PlanMatchPattern.values("msg"))))));
        this.assertPlan("WITH t(msg) AS ( SELECT * FROM (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))))) SELECT b.msg.x FROM t a JOIN t b ON a.msg.y = b.msg.y WHERE a.msg.x + b.msg.x < bigint '10'", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"b_x"), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("a_y", "b_y")), Optional.of("a_x + b_x < bigint '10'"), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_y", (Object)PlanMatchPattern.expression("msg.y"), (Object)"a_x", (Object)PlanMatchPattern.expression("msg.x")), PlanMatchPattern.values("msg"))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b_y", (Object)PlanMatchPattern.expression("msg.y"), (Object)"b_x", (Object)PlanMatchPattern.expression("msg.x")), PlanMatchPattern.values("msg"))))));
    }

    @Test
    public void testFilter() {
        this.assertPlan("WITH t(msg) AS (SELECT * FROM (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))))) SELECT a.msg.y, b.msg.x from t a cross join t b where a.msg.x = 7 or is_finite(b.msg.y)", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_x", (Object)PlanMatchPattern.expression("msg.x"), (Object)"a_y", (Object)PlanMatchPattern.expression("msg.y")), PlanMatchPattern.values("msg")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b_x", (Object)PlanMatchPattern.expression("msg.x"), (Object)"b_y", (Object)PlanMatchPattern.expression("msg.y")), PlanMatchPattern.values("msg")))));
    }

    @Test
    public void testWindow() {
        this.assertPlan("WITH t(msg) AS (SELECT * FROM (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))))) SELECT * from (select msg.x as x, ROW_NUMBER() over (partition by msg.y order by msg.y) as rn from t) where rn = 1", PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_x", (Object)PlanMatchPattern.expression("msg.x"), (Object)"a_y", (Object)PlanMatchPattern.expression("msg.y")), PlanMatchPattern.values("msg"))));
    }

    @Test
    public void testSemiJoin() {
        this.assertPlan("WITH t(msg) AS (SELECT * FROM (VALUES ROW(CAST(ROW(1, 2.0, 3) AS ROW(x BIGINT, y DOUBLE, z BIGINT))))) SELECT msg.y FROM t WHERE msg.x IN (SELECT msg.z FROM t)", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("a_x", "b_z", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_x", (Object)PlanMatchPattern.expression("msg.x"), (Object)"a_y", (Object)PlanMatchPattern.expression("msg.y")), PlanMatchPattern.values("msg"))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b_z", (Object)PlanMatchPattern.expression("msg.z")), PlanMatchPattern.values("msg"))))));
    }

    @Test
    public void testLimit() {
        this.assertPlan("WITH t(msg) AS (SELECT * FROM (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))))) SELECT b.msg.x FROM t a, t b WHERE a.msg.y = b.msg.y limit 100", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("a_y", "b_y")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_y", (Object)PlanMatchPattern.expression("msg.y")), PlanMatchPattern.values("msg"))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b_y", (Object)PlanMatchPattern.expression("msg.y"), (Object)"b_x", (Object)PlanMatchPattern.expression("msg.x")), PlanMatchPattern.values("msg"))))));
        this.assertPlan("WITH t(msg) AS ( SELECT * FROM (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))))) SELECT a.msg.y FROM t a JOIN t b ON a.msg.y = b.msg.y WHERE a.msg.x > bigint '5' limit 100", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("a_y", "b_y")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_y", (Object)PlanMatchPattern.expression("msg.y")), PlanMatchPattern.filter("msg.x > bigint '5'", PlanMatchPattern.values("msg")))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b_y", (Object)PlanMatchPattern.expression("msg.y")), PlanMatchPattern.values("msg"))))));
        this.assertPlan("WITH t(msg) AS ( SELECT * FROM (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))))) SELECT b.msg.x FROM t a JOIN t b ON a.msg.y = b.msg.y WHERE a.msg.x + b.msg.x < bigint '10' limit 100", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("a_y", "b_y")), Optional.of("a_x + b_x < bigint '10'"), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_y", (Object)PlanMatchPattern.expression("msg.y"), (Object)"a_x", (Object)PlanMatchPattern.expression("msg.x")), PlanMatchPattern.values("msg"))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b_y", (Object)PlanMatchPattern.expression("msg.y"), (Object)"b_x", (Object)PlanMatchPattern.expression("msg.x")), PlanMatchPattern.values("msg"))))));
    }

    @Test
    public void testSort() {
        ImmutableList orderBy = ImmutableList.of((Object)PlanMatchPattern.sort("b_x", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST));
        this.assertPlan("WITH t(msg) AS ( SELECT * FROM (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))), ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))))) SELECT a.msg.x FROM t a JOIN t b ON a.msg.y = b.msg.y WHERE a.msg.x < bigint '10' ORDER BY b.msg.x", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"expr"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("a_x")), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("a_y", "b_y")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_y", (Object)PlanMatchPattern.expression("msg.y"), (Object)"a_x", (Object)PlanMatchPattern.expression("msg.x")), PlanMatchPattern.filter("msg.x < bigint '10'", PlanMatchPattern.values("msg")))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b_y", (Object)PlanMatchPattern.expression("msg.y"), (Object)"b_x", (Object)PlanMatchPattern.expression("msg.x")), PlanMatchPattern.values("msg"))))))))));
    }

    @Test
    public void testUnnest() {
        this.assertPlan("WITH t(msg, array) AS (SELECT * FROM (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE)), ARRAY[1, 2, 3]))) SELECT a.msg.x FROM t a JOIN t b ON a.msg.y = b.msg.y CROSS JOIN UNNEST (a.array) WHERE a.msg.x + b.msg.x < bigint '10'", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"expr"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("a_x")), PlanMatchPattern.unnest(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("a_y", "b_y")), Optional.of("a_x + b_x < bigint '10'"), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_y", (Object)PlanMatchPattern.expression("msg.y"), (Object)"a_x", (Object)PlanMatchPattern.expression("msg.x"), (Object)"a_z", (Object)PlanMatchPattern.expression("array")), PlanMatchPattern.values("msg", "array"))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b_y", (Object)PlanMatchPattern.expression("msg.y"), (Object)"b_x", (Object)PlanMatchPattern.expression("msg.x")), PlanMatchPattern.values("msg"))))))));
    }
}

