/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.CteConsumerNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

final class CteConsumerMatcher
implements Matcher {
    private final String expectedCteName;

    public CteConsumerMatcher(String cteName) {
        this.expectedCteName = Objects.requireNonNull(cteName, "expectedCteName is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof CteConsumerNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        CteConsumerNode otherNode = (CteConsumerNode)node;
        if (!this.expectedCteName.equalsIgnoreCase(otherNode.getCteId())) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("expectedCteName", (Object)this.expectedCteName).toString();
    }
}

