/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.CachingStatsProvider;
import com.facebook.presto.cost.PlanCostEstimate;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.PlanMatchingVisitor;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Plans;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import java.util.function.Function;

public final class PlanAssert {
    private PlanAssert() {
    }

    public static void assertPlan(Session session, Metadata metadata, StatsCalculator statsCalculator, Plan actual, PlanMatchPattern pattern) {
        CachingStatsProvider statsProvider = new CachingStatsProvider(statsCalculator, session, actual.getTypes());
        PlanAssert.assertPlan(session, metadata, (StatsProvider)statsProvider, actual, Lookup.noLookup(), pattern, Function.identity());
    }

    public static void assertPlanDoesNotMatch(Session session, Metadata metadata, StatsCalculator statsCalculator, Plan actual, PlanMatchPattern pattern) {
        CachingStatsProvider statsProvider = new CachingStatsProvider(statsCalculator, session, actual.getTypes());
        PlanAssert.assertPlanDoesNotMatch(session, metadata, (StatsProvider)statsProvider, actual, Lookup.noLookup(), pattern, Function.identity());
    }

    public static void assertPlan(Session session, Metadata metadata, StatsProvider statsProvider, Plan actual, Lookup lookup, PlanMatchPattern pattern, Function<PlanNode, PlanNode> planSanitizer) {
        MatchResult matches = (MatchResult)actual.getRoot().accept((PlanVisitor)new PlanMatchingVisitor(session, metadata, statsProvider, lookup), (Object)pattern);
        if (!matches.isMatch()) {
            PlanNode resolvedPlan = Plans.resolveGroupReferences((PlanNode)actual.getRoot(), (Lookup)lookup);
            String resolvedFormattedPlan = PlanPrinter.textLogicalPlan((PlanNode)planSanitizer.apply(resolvedPlan), (TypeProvider)actual.getTypes(), (StatsAndCosts)StatsAndCosts.create((PlanNode)resolvedPlan, (StatsProvider)statsProvider, node -> PlanCostEstimate.unknown()), (FunctionAndTypeManager)metadata.getFunctionAndTypeManager(), (Session)session, (int)0);
            throw new AssertionError((Object)String.format("Plan does not match, expected [\n\n%s\n] but found [\n\n%s\n]", pattern, resolvedFormattedPlan));
        }
    }

    public static void assertPlanDoesNotMatch(Session session, Metadata metadata, StatsProvider statsProvider, Plan actual, Lookup lookup, PlanMatchPattern pattern, Function<PlanNode, PlanNode> planSanitizer) {
        MatchResult matches = (MatchResult)actual.getRoot().accept((PlanVisitor)new PlanMatchingVisitor(session, metadata, statsProvider, lookup), (Object)pattern);
        if (matches.isMatch()) {
            PlanNode resolvedPlan = Plans.resolveGroupReferences((PlanNode)actual.getRoot(), (Lookup)lookup);
            String resolvedFormattedPlan = PlanPrinter.textLogicalPlan((PlanNode)planSanitizer.apply(resolvedPlan), (TypeProvider)actual.getTypes(), (StatsAndCosts)StatsAndCosts.empty(), (FunctionAndTypeManager)metadata.getFunctionAndTypeManager(), (Session)session, (int)0);
            throw new AssertionError((Object)String.format("Plan unexpectedly matches the pattern, pattern is [\n\n%s\n] and plan is [\n\n%s\n]", pattern, resolvedFormattedPlan));
        }
    }
}

