/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RemoteSourceMatcher
implements Matcher {
    private List<PlanFragmentId> sourceFragmentIds;
    private final Map<String, Integer> outputSymbolAliases;

    public RemoteSourceMatcher(List<PlanFragmentId> sourceFragmentIds, Map<String, Integer> outputSymbolAliases) {
        this.sourceFragmentIds = Objects.requireNonNull(sourceFragmentIds, "sourceFragmentIds is null");
        this.outputSymbolAliases = Objects.requireNonNull(outputSymbolAliases, "outputSymbolAliases is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof RemoteSourceNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        RemoteSourceNode remoteSourceNode = (RemoteSourceNode)node;
        if (remoteSourceNode.getSourceFragmentIds().equals(this.sourceFragmentIds)) {
            return MatchResult.match(SymbolAliases.builder().putAll(Maps.transformValues(this.outputSymbolAliases, index -> ExpressionTreeUtils.createSymbolReference((VariableReferenceExpression)((VariableReferenceExpression)remoteSourceNode.getOutputVariables().get((int)index))))).build());
        }
        return MatchResult.NO_MATCH;
    }
}

